/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.ReaderBase;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix", "Configuration"})
public class SequenceFileLogReader
extends ReaderBase {
    private static final Log LOG = LogFactory.getLog(SequenceFileLogReader.class);
    private static final Text WAL_VERSION_KEY = new Text("version");
    private static final int COMPRESSION_VERSION = 1;
    private static final Text WAL_COMPRESSION_TYPE_KEY = new Text("compression.type");
    private static final Text DICTIONARY_COMPRESSION_TYPE = new Text("dictionary");
    protected SequenceFile.Reader reader;
    long entryStart = 0L;

    @Override
    public void close() throws IOException {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException ioe) {
            throw this.addFileInfoToException(ioe);
        }
    }

    @Override
    public long getPosition() throws IOException {
        return this.reader != null ? this.reader.getPosition() : 0L;
    }

    @Override
    public void reset() throws IOException {
        this.reader = new WALReader(this.fs, this.path, this.conf);
    }

    @Override
    protected String initReader(FSDataInputStream stream) throws IOException {
        if (stream != null) {
            stream.close();
        }
        this.reset();
        return null;
    }

    @Override
    protected void initAfterCompression(String cellCodecClsName) throws IOException {
    }

    @Override
    protected void initAfterCompression() throws IOException {
    }

    @Override
    protected boolean hasCompression() {
        return SequenceFileLogReader.isWALCompressionEnabled(this.reader.getMetadata());
    }

    @Override
    protected boolean hasTagCompression() {
        return false;
    }

    static boolean isWALCompressionEnabled(SequenceFile.Metadata metadata) {
        Text txt = metadata.get(WAL_VERSION_KEY);
        if (txt == null || Integer.parseInt(txt.toString()) < 1) {
            return false;
        }
        txt = metadata.get(WAL_COMPRESSION_TYPE_KEY);
        return txt != null && txt.equals((Object)DICTIONARY_COMPRESSION_TYPE);
    }

    @Override
    protected boolean readNext(HLog.Entry e) throws IOException {
        try {
            boolean hasNext = this.reader.next((Writable)e.getKey(), (Writable)e.getEdit());
            if (!hasNext) {
                return false;
            }
            NavigableMap<byte[], Integer> scopes = e.getEdit().getAndRemoveScopes();
            if (scopes != null) {
                e.getKey().readOlderScopes(scopes);
            }
            return true;
        }
        catch (IOException ioe) {
            throw this.addFileInfoToException(ioe);
        }
    }

    @Override
    protected void seekOnFs(long pos) throws IOException {
        try {
            this.reader.seek(pos);
        }
        catch (IOException ioe) {
            throw this.addFileInfoToException(ioe);
        }
    }

    protected IOException addFileInfoToException(IOException ioe) throws IOException {
        long pos = -1L;
        try {
            pos = this.getPosition();
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed getting position to add to throw", (Throwable)e);
        }
        long end = Long.MAX_VALUE;
        try {
            Field fEnd = SequenceFile.Reader.class.getDeclaredField("end");
            fEnd.setAccessible(true);
            end = fEnd.getLong(this.reader);
        }
        catch (NoSuchFieldException nfe) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (Exception e) {
            LOG.warn((Object)"Unexpected exception when accessing the end field", (Throwable)e);
        }
        String msg = (this.path == null ? "" : this.path.toString()) + ", entryStart=" + this.entryStart + ", pos=" + pos + (end == Long.MAX_VALUE ? "" : ", end=" + end) + ", edit=" + this.edit;
        try {
            return (IOException)((IOException)ioe.getClass().getConstructor(String.class).newInstance(msg)).initCause(ioe);
        }
        catch (NoSuchMethodException nfe) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (Exception e) {
            LOG.warn((Object)"Unexpected exception when accessing the end field", (Throwable)e);
        }
        return ioe;
    }

    private static class WALReader
    extends SequenceFile.Reader {
        WALReader(FileSystem fs, Path p, Configuration c) throws IOException {
            super(fs, p, c);
        }

        protected FSDataInputStream openFile(FileSystem fs, Path file, int bufferSize, long length) throws IOException {
            return new WALReaderFSDataInputStream(super.openFile(fs, file, bufferSize, length), length);
        }

        static class WALReaderFSDataInputStream
        extends FSDataInputStream {
            private boolean firstGetPosInvocation = true;
            private long length;

            WALReaderFSDataInputStream(FSDataInputStream is, long l) throws IOException {
                super((InputStream)is);
                this.length = l;
            }

            public long getPos() throws IOException {
                if (this.firstGetPosInvocation) {
                    this.firstGetPosInvocation = false;
                    long adjust = 0L;
                    try {
                        Field fIn = FilterInputStream.class.getDeclaredField("in");
                        fIn.setAccessible(true);
                        Object realIn = fIn.get(this.in);
                        if (realIn.getClass().getName().endsWith("DFSInputStream")) {
                            Method getFileLength = realIn.getClass().getDeclaredMethod("getFileLength", new Class[0]);
                            getFileLength.setAccessible(true);
                            long realLength = (Long)getFileLength.invoke(realIn, new Object[0]);
                            assert (realLength >= this.length);
                            adjust = realLength - this.length;
                        } else {
                            LOG.info((Object)("Input stream class: " + realIn.getClass().getName() + ", not adjusting length"));
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error while trying to get accurate file length.  Truncation / data loss may occur if RegionServers die.", (Throwable)e);
                        throw new IOException(e);
                    }
                    return adjust + super.getPos();
                }
                return super.getPos();
            }
        }
    }
}

