/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.util.FileStatusFilter;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class AbstractFileStatusFilter
implements PathFilter,
FileStatusFilter {
    protected abstract boolean accept(Path var1, Boolean var2);

    @Override
    public boolean accept(FileStatus f) {
        return this.accept(f.getPath(), f.isDir());
    }

    public boolean accept(Path p) {
        return this.accept(p, null);
    }

    protected boolean isFile(FileSystem fs, Boolean isDir, Path p) throws IOException {
        return !this.isDirectory(fs, isDir, p);
    }

    protected boolean isDirectory(FileSystem fs, Boolean isDir, Path p) throws IOException {
        return isDir != null ? isDir.booleanValue() : fs.isDirectory(p);
    }
}

