/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaMockingUtil;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.Progressable;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestCatalogTracker {
    private static final Log LOG = LogFactory.getLog(TestCatalogTracker.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final ServerName SN = ServerName.valueOf((String)"example.org", (int)1234, (long)System.currentTimeMillis());
    private ZooKeeperWatcher watcher;
    private Abortable abortable;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 3);
        UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void afterClass() throws IOException {
        UTIL.getZkCluster().shutdown();
    }

    @Before
    public void before() throws IOException {
        this.abortable = new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
            }

            public boolean isAborted() {
                return false;
            }
        };
        this.watcher = new ZooKeeperWatcher(UTIL.getConfiguration(), this.getClass().getSimpleName(), this.abortable, true);
    }

    @After
    public void after() {
        try {
            MetaRegionTracker.deleteMetaLocation((ZooKeeperWatcher)this.watcher);
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Unable to delete hbase:meta location", (Throwable)e);
        }
        HConnectionManager.deleteConnection((Configuration)UTIL.getConfiguration());
        this.watcher.close();
    }

    private CatalogTracker constructAndStartCatalogTracker(HConnection c) throws IOException, InterruptedException {
        CatalogTracker ct = new CatalogTracker(this.watcher, UTIL.getConfiguration(), c, this.abortable);
        ct.start();
        return ct;
    }

    @Test
    public void testThatIfMETAMovesWeAreNotified() throws IOException, InterruptedException, KeeperException {
        HConnection connection = (HConnection)Mockito.mock(HConnection.class);
        this.constructAndStartCatalogTracker(connection);
        MetaRegionTracker.setMetaLocation((ZooKeeperWatcher)this.watcher, (ServerName)ServerName.valueOf((String)"example.com", (int)1234, (long)System.currentTimeMillis()));
    }

    @Test
    public void testInterruptWaitOnMeta() throws IOException, InterruptedException, ServiceException {
        ClientProtos.ClientService.BlockingInterface client = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        HConnection connection = this.mockConnection(null, client);
        Mockito.when((Object)client.get((RpcController)Mockito.any(), (ClientProtos.GetRequest)Mockito.any())).thenReturn((Object)ClientProtos.GetResponse.newBuilder().build());
        final CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
        ServerName meta = ct.getMetaLocation();
        junit.framework.Assert.assertNull((Object)meta);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ct.waitForMeta();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted", e);
                }
            }
        };
        t.start();
        while (!t.isAlive()) {
            Threads.sleep((long)1L);
        }
        Threads.sleep((long)1L);
        Assert.assertTrue((boolean)t.isAlive());
        ct.stop();
        t.join();
    }

    private void testVerifyMetaRegionLocationWithException(Exception ex) throws IOException, InterruptedException, KeeperException, ServiceException {
        ClientProtos.ClientService.BlockingInterface implementation = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        HConnection connection = this.mockConnection(null, implementation);
        Mockito.when((Object)implementation.get((RpcController)Mockito.any(), (ClientProtos.GetRequest)Mockito.any())).thenThrow(new Throwable[]{new ServiceException((Throwable)ex)});
        CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
        MetaRegionTracker.setMetaLocation((ZooKeeperWatcher)this.watcher, (ServerName)SN);
        long timeout = UTIL.getConfiguration().getLong("hbase.catalog.verification.timeout", 1000L);
        junit.framework.Assert.assertFalse((boolean)ct.verifyMetaRegionLocation(timeout));
    }

    @Test
    public void testGetMetaServerConnectionFails() throws IOException, InterruptedException, KeeperException, ServiceException {
        this.testVerifyMetaRegionLocationWithException(new ConnectException("Connection refused"));
    }

    @Test
    public void testVerifyMetaRegionServerNotRunning() throws IOException, InterruptedException, KeeperException, ServiceException {
        this.testVerifyMetaRegionLocationWithException((Exception)new ServerNotRunningYetException("mock"));
    }

    @Test
    public void testVerifyMetaRegionLocationFails() throws IOException, InterruptedException, KeeperException, ServiceException {
        HConnection connection = (HConnection)Mockito.mock(HConnection.class);
        ServiceException connectException = new ServiceException((Throwable)new ConnectException("Connection refused"));
        AdminProtos.AdminService.BlockingInterface implementation = (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class);
        Mockito.when((Object)implementation.getRegionInfo((RpcController)Mockito.any(), (AdminProtos.GetRegionInfoRequest)Mockito.any())).thenThrow(new Throwable[]{connectException});
        Mockito.when((Object)connection.getAdmin((ServerName)Mockito.any(ServerName.class), Mockito.anyBoolean())).thenReturn((Object)implementation);
        CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
        MetaRegionTracker.setMetaLocation((ZooKeeperWatcher)this.watcher, (ServerName)ServerName.valueOf((String)"example.com", (int)1234, (long)System.currentTimeMillis()));
        junit.framework.Assert.assertFalse((boolean)ct.verifyMetaRegionLocation(100L));
    }

    @Test(expected=NotAllMetaRegionsOnlineException.class)
    public void testTimeoutWaitForMeta() throws IOException, InterruptedException {
        HConnection connection = (HConnection)Mockito.mock(HConnection.class);
        CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
        ct.waitForMeta(100L);
    }

    @Test
    public void testNoTimeoutWaitForMeta() throws IOException, InterruptedException, KeeperException {
        HConnection connection = (HConnection)Mockito.mock(HConnection.class);
        CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
        ServerName hsa = ct.getMetaLocation();
        junit.framework.Assert.assertNull((Object)hsa);
        WaitOnMetaThread t = new WaitOnMetaThread(ct);
        this.startWaitAliveThenWaitItLives(t, 1);
        hsa = this.setMetaLocation();
        t.join();
        junit.framework.Assert.assertTrue((boolean)ct.getMetaLocation().equals((Object)hsa));
    }

    private ServerName setMetaLocation() throws KeeperException {
        MetaRegionTracker.setMetaLocation((ZooKeeperWatcher)this.watcher, (ServerName)SN);
        return SN;
    }

    private HConnection mockConnection(AdminProtos.AdminService.BlockingInterface admin, ClientProtos.ClientService.BlockingInterface client) throws IOException {
        HConnection connection = HConnectionTestingUtility.getMockedConnection(UTIL.getConfiguration());
        ((HConnection)Mockito.doNothing().when((Object)connection)).close();
        HRegionLocation anyLocation = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, SN);
        Mockito.when((Object)connection.getRegionLocation((TableName)Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)anyLocation);
        Mockito.when((Object)connection.locateRegion((TableName)Mockito.any(), (byte[])Mockito.any())).thenReturn((Object)anyLocation);
        if (admin != null) {
            Mockito.when((Object)connection.getAdmin((ServerName)Mockito.any(ServerName.class))).thenReturn((Object)admin);
        }
        if (client != null) {
            Mockito.when((Object)connection.getClient((ServerName)Mockito.any(ServerName.class))).thenReturn((Object)client);
        }
        return connection;
    }

    private Result getMetaTableRowResult() throws IOException {
        return MetaMockingUtil.getMetaTableRowResult(HRegionInfo.FIRST_META_REGIONINFO, SN);
    }

    private void startWaitAliveThenWaitItLives(Thread t, int ms) {
        t.start();
        while (!t.isAlive()) {
        }
        Threads.sleep((long)ms);
        junit.framework.Assert.assertTrue((String)("Assert " + t.getName() + " still waiting"), (boolean)t.isAlive());
    }

    class WaitOnMetaThread
    extends Thread {
        final CatalogTracker ct;

        WaitOnMetaThread(CatalogTracker ct) {
            super("WaitOnMeta");
            this.ct = ct;
        }

        @Override
        public void run() {
            try {
                this.doWaiting();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed wait", e);
            }
            LOG.info((Object)("Exiting " + this.getName()));
        }

        void doWaiting() throws InterruptedException {
            try {
                while (this.ct.waitForMeta(100L) == null) {
                }
            }
            catch (NotAllMetaRegionsOnlineException notAllMetaRegionsOnlineException) {
                // empty catch block
            }
        }
    }

    class CountingProgressable
    implements Progressable {
        final AtomicInteger counter = new AtomicInteger(0);

        CountingProgressable() {
        }

        public void progress() {
            this.counter.incrementAndGet();
        }
    }
}

