/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPutDeleteEtcCellIteration {
    private static final byte[] ROW = new byte[]{114};
    private static final long TIMESTAMP = System.currentTimeMillis();
    private static final int COUNT = 10;

    @Test
    public void testPutIteration() throws IOException {
        Put p = new Put(ROW);
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            p.add(bytes, bytes, TIMESTAMP, bytes);
        }
        int index = 0;
        CellScanner cellScanner = p.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            byte[] bytes = Bytes.toBytes((int)index++);
            cell.equals(new KeyValue(ROW, bytes, bytes, TIMESTAMP, bytes));
        }
        Assert.assertEquals((long)10L, (long)index);
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testPutConcurrentModificationOnIteration() throws IOException {
        Put p = new Put(ROW);
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            p.add(bytes, bytes, TIMESTAMP, bytes);
        }
        int index = 0;
        int trigger = 3;
        CellScanner cellScanner = p.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            byte[] bytes = Bytes.toBytes((int)index++);
            if (trigger == 3) {
                p.add(bytes, bytes, TIMESTAMP, bytes);
            }
            cell.equals(new KeyValue(ROW, bytes, bytes, TIMESTAMP, bytes));
        }
        Assert.assertEquals((long)10L, (long)index);
    }

    @Test
    public void testDeleteIteration() throws IOException {
        Delete d = new Delete(ROW);
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            d.deleteColumn(bytes, bytes, TIMESTAMP);
        }
        int index = 0;
        CellScanner cellScanner = d.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            byte[] bytes = Bytes.toBytes((int)index++);
            cell.equals(new KeyValue(ROW, bytes, bytes, TIMESTAMP, KeyValue.Type.DeleteColumn));
        }
        Assert.assertEquals((long)10L, (long)index);
    }

    @Test
    public void testAppendIteration() throws IOException {
        Append a = new Append(ROW);
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            a.add(bytes, bytes, bytes);
        }
        int index = 0;
        CellScanner cellScanner = a.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            byte[] bytes = Bytes.toBytes((int)index++);
            KeyValue kv = (KeyValue)cell;
            Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getFamily(), (byte[])bytes));
            Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])bytes));
        }
        Assert.assertEquals((long)10L, (long)index);
    }

    @Test
    public void testIncrementIteration() throws IOException {
        Increment increment = new Increment(ROW);
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            increment.addColumn(bytes, bytes, (long)i);
        }
        int index = 0;
        CellScanner cellScanner = increment.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            int value = index;
            byte[] bytes = Bytes.toBytes((int)index++);
            KeyValue kv = (KeyValue)cell;
            Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getFamily(), (byte[])bytes));
            long a = Bytes.toLong((byte[])kv.getValue());
            Assert.assertEquals((long)value, (long)a);
        }
        Assert.assertEquals((long)10L, (long)index);
    }

    @Test
    public void testResultIteration() throws IOException {
        Cell[] cells = new Cell[10];
        for (int i = 0; i < 10; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            cells[i] = new KeyValue(ROW, bytes, bytes, TIMESTAMP, bytes);
        }
        Result r = Result.create(Arrays.asList(cells));
        int index = 0;
        CellScanner cellScanner = r.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            byte[] bytes = Bytes.toBytes((int)index++);
            cell.equals(new KeyValue(ROW, bytes, bytes, TIMESTAMP, bytes));
        }
        Assert.assertEquals((long)10L, (long)index);
    }
}

