/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import com.google.common.io.CountingInputStream;
import com.google.common.io.CountingOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.MessageCodec;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellMessageCodec {
    public static final Log LOG = LogFactory.getLog(TestCellMessageCodec.class);

    @Test
    public void testEmptyWorks() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        DataOutputStream dos = new DataOutputStream((OutputStream)cos);
        MessageCodec cmc = new MessageCodec();
        Codec.Encoder encoder = cmc.getEncoder((OutputStream)dos);
        encoder.flush();
        dos.close();
        long offset = cos.getCount();
        Assert.assertEquals((long)0L, (long)offset);
        CountingInputStream cis = new CountingInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream((InputStream)cis);
        Codec.Decoder decoder = cmc.getDecoder((InputStream)dis);
        Assert.assertFalse((boolean)decoder.advance());
        dis.close();
        Assert.assertEquals((long)0L, (long)cis.getCount());
    }

    @Test
    public void testOne() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        DataOutputStream dos = new DataOutputStream((OutputStream)cos);
        MessageCodec cmc = new MessageCodec();
        Codec.Encoder encoder = cmc.getEncoder((OutputStream)dos);
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"v"));
        encoder.write((Cell)kv);
        encoder.flush();
        dos.close();
        long offset = cos.getCount();
        CountingInputStream cis = new CountingInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream((InputStream)cis);
        Codec.Decoder decoder = cmc.getDecoder((InputStream)dis);
        Assert.assertTrue((boolean)decoder.advance());
        Assert.assertFalse((boolean)decoder.advance());
        dis.close();
        Assert.assertEquals((long)offset, (long)cis.getCount());
    }

    @Test
    public void testThree() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        DataOutputStream dos = new DataOutputStream((OutputStream)cos);
        MessageCodec cmc = new MessageCodec();
        Codec.Encoder encoder = cmc.getEncoder((OutputStream)dos);
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"1"));
        KeyValue kv2 = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"2"), Bytes.toBytes((String)"2"));
        KeyValue kv3 = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"3"), Bytes.toBytes((String)"3"));
        encoder.write((Cell)kv1);
        encoder.write((Cell)kv2);
        encoder.write((Cell)kv3);
        encoder.flush();
        dos.close();
        long offset = cos.getCount();
        CountingInputStream cis = new CountingInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream((InputStream)cis);
        Codec.Decoder decoder = cmc.getDecoder((InputStream)dis);
        Assert.assertTrue((boolean)decoder.advance());
        Cell c = decoder.current();
        Assert.assertTrue((boolean)CellComparator.equals((Cell)c, (Cell)kv1));
        Assert.assertTrue((boolean)decoder.advance());
        c = decoder.current();
        Assert.assertTrue((boolean)CellComparator.equals((Cell)c, (Cell)kv2));
        Assert.assertTrue((boolean)decoder.advance());
        c = decoder.current();
        Assert.assertTrue((boolean)CellComparator.equals((Cell)c, (Cell)kv3));
        Assert.assertFalse((boolean)decoder.advance());
        dis.close();
        Assert.assertEquals((long)offset, (long)cis.getCount());
    }
}

