/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.TreeSet;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyValueMatchingQualifiersFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFirstKeyValueMatchingQualifiersFilter
extends TestCase {
    private static final byte[] ROW = Bytes.toBytes((String)"test");
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"test");
    private static final byte[] COLUMN_QUALIFIER_1 = Bytes.toBytes((String)"foo");
    private static final byte[] COLUMN_QUALIFIER_2 = Bytes.toBytes((String)"foo_2");
    private static final byte[] COLUMN_QUALIFIER_3 = Bytes.toBytes((String)"foo_3");
    private static final byte[] VAL_1 = Bytes.toBytes((String)"a");

    public void testFirstKeyMatchingQualifierFilter() throws Exception {
        TreeSet<byte[]> quals = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        quals.add(COLUMN_QUALIFIER_1);
        quals.add(COLUMN_QUALIFIER_2);
        FirstKeyValueMatchingQualifiersFilter filter = new FirstKeyValueMatchingQualifiersFilter(quals);
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_1, VAL_1);
        TestFirstKeyValueMatchingQualifiersFilter.assertTrue((String)"includeAndSetFlag", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        TestFirstKeyValueMatchingQualifiersFilter.assertTrue((String)"flagIsSetSkipToNextRow", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
        filter.reset();
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_3, VAL_1);
        System.out.println(filter.filterKeyValue((Cell)kv));
        TestFirstKeyValueMatchingQualifiersFilter.assertTrue((String)"includeFlagIsUnset", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        TestFirstKeyValueMatchingQualifiersFilter.assertTrue((String)"includeAndSetFlag", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_1, VAL_1);
        TestFirstKeyValueMatchingQualifiersFilter.assertTrue((String)"flagIsSetSkipToNextRow", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
    }
}

