/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.collect.Multimap;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.TestHRegionServerBulkLoad;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={LargeTests.class})
public class TestLoadIncrementalHFilesSplitRecovery {
    static final Log LOG = LogFactory.getLog(TestHRegionServerBulkLoad.class);
    static HBaseTestingUtility util;
    static boolean useSecure;
    static final int NUM_CFS = 10;
    static final byte[] QUAL;
    static final int ROWCOUNT = 100;
    private static final byte[][] families;

    static byte[] rowkey(int i) {
        return Bytes.toBytes((String)String.format("row_%08d", i));
    }

    static String family(int i) {
        return String.format("family_%04d", i);
    }

    static byte[] value(int i) {
        return Bytes.toBytes((String)String.format("%010d", i));
    }

    public static void buildHFiles(FileSystem fs, Path dir, int value) throws IOException {
        byte[] val = TestLoadIncrementalHFilesSplitRecovery.value(value);
        for (int i = 0; i < 10; ++i) {
            Path testIn = new Path(dir, TestLoadIncrementalHFilesSplitRecovery.family(i));
            TestHRegionServerBulkLoad.createHFile(fs, new Path(testIn, "hfile_" + i), Bytes.toBytes((String)TestLoadIncrementalHFilesSplitRecovery.family(i)), QUAL, val, 100);
        }
    }

    private void setupTable(String table, int cfs) throws IOException {
        try {
            LOG.info((Object)("Creating table " + table));
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)table));
            for (int i = 0; i < cfs; ++i) {
                htd.addFamily(new HColumnDescriptor(TestLoadIncrementalHFilesSplitRecovery.family(i)));
            }
            util.getHBaseAdmin().createTable(htd);
        }
        catch (TableExistsException tee) {
            LOG.info((Object)("Table " + table + " already exists"));
        }
    }

    private void setupTableWithSplitkeys(String table, int cfs, byte[][] SPLIT_KEYS) throws IOException {
        try {
            LOG.info((Object)("Creating table " + table));
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)table));
            for (int i = 0; i < cfs; ++i) {
                htd.addFamily(new HColumnDescriptor(TestLoadIncrementalHFilesSplitRecovery.family(i)));
            }
            util.getHBaseAdmin().createTable(htd, SPLIT_KEYS);
        }
        catch (TableExistsException tee) {
            LOG.info((Object)("Table " + table + " already exists"));
        }
    }

    private Path buildBulkFiles(String table, int value) throws Exception {
        Path dir = util.getDataTestDirOnTestFS(table);
        Path bulk1 = new Path(dir, table + value);
        FileSystem fs = util.getTestFileSystem();
        TestLoadIncrementalHFilesSplitRecovery.buildHFiles(fs, bulk1, value);
        return bulk1;
    }

    private void populateTable(String table, int value) throws Exception {
        LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration());
        Path bulk1 = this.buildBulkFiles(table, value);
        HTable t = new HTable(util.getConfiguration(), Bytes.toBytes((String)table));
        lih.doBulkLoad(bulk1, t);
    }

    private void forceSplit(String table) {
        try {
            int regions;
            HRegionServer hrs = util.getRSForFirstRegionInTable(Bytes.toBytes((String)table));
            for (HRegionInfo hri : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs)) {
                if (!Bytes.equals((byte[])hri.getTable().getName(), (byte[])Bytes.toBytes((String)table))) continue;
                ProtobufUtil.split((AdminProtos.AdminService.BlockingInterface)hrs, (HRegionInfo)hri, (byte[])TestLoadIncrementalHFilesSplitRecovery.rowkey(50));
            }
            do {
                regions = 0;
                for (HRegionInfo hri : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs)) {
                    if (!Bytes.equals((byte[])hri.getTable().getName(), (byte[])Bytes.toBytes((String)table))) continue;
                    ++regions;
                }
                if (regions == 2) continue;
                LOG.info((Object)"Taking some time to complete split...");
                Thread.sleep(250L);
            } while (regions != 2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        util = new HBaseTestingUtility();
        util.getConfiguration().set("hbase.coprocessor.region.classes", "");
        util.startMiniCluster(1);
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        util.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertExpectedTable(String table, int count, int value) throws IOException {
        HTable t = null;
        try {
            Assert.assertEquals((long)util.getHBaseAdmin().listTables(table).length, (long)1L);
            t = new HTable(util.getConfiguration(), table);
            Scan s = new Scan();
            ResultScanner sr = t.getScanner(s);
            int i = 0;
            for (Result r : sr) {
                ++i;
                for (NavigableMap nm : r.getNoVersionMap().values()) {
                    for (byte[] val : nm.values()) {
                        Assert.assertTrue((boolean)Bytes.equals((byte[])val, (byte[])TestLoadIncrementalHFilesSplitRecovery.value(value)));
                    }
                }
            }
            Assert.assertEquals((long)count, (long)i);
        }
        catch (IOException e) {
            Assert.fail((String)"Failed due to exception");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class, timeout=120000L)
    public void testBulkLoadPhaseFailure() throws Exception {
        String table = "bulkLoadPhaseFailure";
        this.setupTable(table, 10);
        final AtomicInteger attmptedCalls = new AtomicInteger();
        final AtomicInteger failedCalls = new AtomicInteger();
        util.getConfiguration().setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 2);
        try {
            LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration()){

                protected List<LoadIncrementalHFiles.LoadQueueItem> tryAtomicRegionLoad(HConnection conn, TableName tableName, byte[] first, Collection<LoadIncrementalHFiles.LoadQueueItem> lqis) throws IOException {
                    int i = attmptedCalls.incrementAndGet();
                    if (i == 1) {
                        HConnection errConn = null;
                        try {
                            errConn = TestLoadIncrementalHFilesSplitRecovery.this.getMockedConnection(util.getConfiguration());
                        }
                        catch (Exception e) {
                            LOG.fatal((Object)"mocking cruft, should never happen", (Throwable)e);
                            throw new RuntimeException("mocking cruft, should never happen");
                        }
                        failedCalls.incrementAndGet();
                        return super.tryAtomicRegionLoad(errConn, tableName, first, lqis);
                    }
                    return super.tryAtomicRegionLoad(conn, tableName, first, lqis);
                }
            };
            Path dir = this.buildBulkFiles(table, 1);
            HTable t = new HTable(util.getConfiguration(), Bytes.toBytes((String)table));
            lih.doBulkLoad(dir, t);
        }
        finally {
            util.getConfiguration().setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        }
        Assert.fail((String)"doBulkLoad should have thrown an exception");
    }

    private HConnection getMockedConnection(Configuration conf) throws IOException, ServiceException {
        HConnection c = (HConnection)Mockito.mock(HConnection.class);
        Mockito.when((Object)c.getConfiguration()).thenReturn((Object)conf);
        ((HConnection)Mockito.doNothing().when((Object)c)).close();
        HRegionLocation loc = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, ServerName.valueOf((String)"example.org", (int)1234, (long)0L));
        Mockito.when((Object)c.getRegionLocation((TableName)Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)loc);
        Mockito.when((Object)c.locateRegion((TableName)Mockito.any(), (byte[])Mockito.any())).thenReturn((Object)loc);
        ClientProtos.ClientService.BlockingInterface hri = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        Mockito.when((Object)hri.bulkLoadHFile((RpcController)Mockito.any(), (ClientProtos.BulkLoadHFileRequest)Mockito.any())).thenThrow(new Throwable[]{new ServiceException((Throwable)new IOException("injecting bulk load error"))});
        Mockito.when((Object)c.getClient((ServerName)Mockito.any(ServerName.class))).thenReturn((Object)hri);
        return c;
    }

    @Test(timeout=120000L)
    public void testSplitWhileBulkLoadPhase() throws Exception {
        String table = "splitWhileBulkloadPhase";
        this.setupTable("splitWhileBulkloadPhase", 10);
        this.populateTable("splitWhileBulkloadPhase", 1);
        this.assertExpectedTable("splitWhileBulkloadPhase", 100, 1);
        final AtomicInteger attemptedCalls = new AtomicInteger();
        LoadIncrementalHFiles lih2 = new LoadIncrementalHFiles(util.getConfiguration()){

            protected void bulkLoadPhase(HTable htable, HConnection conn, ExecutorService pool, Deque<LoadIncrementalHFiles.LoadQueueItem> queue, Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups) throws IOException {
                int i = attemptedCalls.incrementAndGet();
                if (i == 1) {
                    TestLoadIncrementalHFilesSplitRecovery.this.forceSplit("splitWhileBulkloadPhase");
                }
                super.bulkLoadPhase(htable, conn, pool, queue, regionGroups);
            }
        };
        HTable t = new HTable(util.getConfiguration(), Bytes.toBytes((String)"splitWhileBulkloadPhase"));
        Path bulk = this.buildBulkFiles("splitWhileBulkloadPhase", 2);
        lih2.doBulkLoad(bulk, t);
        Assert.assertEquals((long)attemptedCalls.get(), (long)3L);
        this.assertExpectedTable("splitWhileBulkloadPhase", 100, 2);
    }

    @Test(timeout=120000L)
    public void testGroupOrSplitPresplit() throws Exception {
        String table = "groupOrSplitPresplit";
        this.setupTable("groupOrSplitPresplit", 10);
        this.populateTable("groupOrSplitPresplit", 1);
        this.assertExpectedTable("groupOrSplitPresplit", 100, 1);
        this.forceSplit("groupOrSplitPresplit");
        final AtomicInteger countedLqis = new AtomicInteger();
        LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration()){

            protected List<LoadIncrementalHFiles.LoadQueueItem> groupOrSplit(Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups, LoadIncrementalHFiles.LoadQueueItem item, HTable htable, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
                List lqis = super.groupOrSplit(regionGroups, item, htable, startEndKeys);
                if (lqis != null) {
                    countedLqis.addAndGet(lqis.size());
                }
                return lqis;
            }
        };
        Path bulk = this.buildBulkFiles("groupOrSplitPresplit", 2);
        HTable ht = new HTable(util.getConfiguration(), Bytes.toBytes((String)"groupOrSplitPresplit"));
        lih.doBulkLoad(bulk, ht);
        this.assertExpectedTable("groupOrSplitPresplit", 100, 2);
        Assert.assertEquals((long)20L, (long)countedLqis.get());
    }

    @Test(expected=IOException.class, timeout=120000L)
    public void testGroupOrSplitFailure() throws Exception {
        String table = "groupOrSplitFailure";
        this.setupTable(table, 10);
        LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration()){
            int i;
            {
                this.i = 0;
            }

            protected List<LoadIncrementalHFiles.LoadQueueItem> groupOrSplit(Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups, LoadIncrementalHFiles.LoadQueueItem item, HTable table, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
                ++this.i;
                if (this.i == 5) {
                    throw new IOException("failure");
                }
                return super.groupOrSplit(regionGroups, item, table, startEndKeys);
            }
        };
        Path dir = this.buildBulkFiles(table, 1);
        HTable t = new HTable(util.getConfiguration(), Bytes.toBytes((String)table));
        lih.doBulkLoad(dir, t);
        Assert.fail((String)"doBulkLoad should have thrown an exception");
    }

    @Test(timeout=120000L)
    public void testGroupOrSplitWhenRegionHoleExistsInMeta() throws Exception {
        String tableName = "testGroupOrSplitWhenRegionHoleExistsInMeta";
        byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"row_00000100")};
        HTable table = new HTable(util.getConfiguration(), Bytes.toBytes((String)tableName));
        this.setupTableWithSplitkeys(tableName, 10, SPLIT_KEYS);
        Path dir = this.buildBulkFiles(tableName, 2);
        final AtomicInteger countedLqis = new AtomicInteger();
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration()){

            protected List<LoadIncrementalHFiles.LoadQueueItem> groupOrSplit(Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups, LoadIncrementalHFiles.LoadQueueItem item, HTable htable, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
                List lqis = super.groupOrSplit(regionGroups, item, htable, startEndKeys);
                if (lqis != null) {
                    countedLqis.addAndGet(lqis.size());
                }
                return lqis;
            }
        };
        try {
            loader.doBulkLoad(dir, table);
        }
        catch (Exception e) {
            LOG.error((Object)"exeception=", (Throwable)e);
        }
        this.assertExpectedTable(tableName, 100, 2);
        dir = this.buildBulkFiles(tableName, 3);
        CatalogTracker ct = new CatalogTracker(util.getConfiguration());
        List regionInfos = MetaReader.getTableRegions((CatalogTracker)ct, (TableName)TableName.valueOf((String)tableName));
        for (HRegionInfo regionInfo : regionInfos) {
            if (!Bytes.equals((byte[])regionInfo.getStartKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY)) continue;
            MetaEditor.deleteRegion((CatalogTracker)ct, (HRegionInfo)regionInfo);
            break;
        }
        try {
            loader.doBulkLoad(dir, table);
        }
        catch (Exception e) {
            LOG.error((Object)"exeception=", (Throwable)e);
            Assert.assertTrue((String)"IOException expected", (boolean)(e instanceof IOException));
        }
        table.close();
        this.assertExpectedTable(tableName, 100, 2);
    }

    static {
        useSecure = false;
        QUAL = Bytes.toBytes((String)"qual");
        families = new byte[10][];
        for (int i = 0; i < 10; ++i) {
            TestLoadIncrementalHFilesSplitRecovery.families[i] = Bytes.toBytes((String)TestLoadIncrementalHFilesSplitRecovery.family(i));
        }
    }
}

