/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMemStoreLAB {
    @Test
    public void testLABRandomAllocation() {
        Random rand = new Random();
        MemStoreLAB mslab = new MemStoreLAB();
        int expectedOff = 0;
        byte[] lastBuffer = null;
        for (int i = 0; i < 100000; ++i) {
            int size = rand.nextInt(1000);
            MemStoreLAB.Allocation alloc = mslab.allocateBytes(size);
            if (alloc.getData() != lastBuffer) {
                expectedOff = 0;
                lastBuffer = alloc.getData();
            }
            Assert.assertEquals((long)expectedOff, (long)alloc.getOffset());
            Assert.assertTrue((String)("Allocation " + alloc + " overruns buffer"), (alloc.getOffset() + size <= alloc.getData().length ? 1 : 0) != 0);
            expectedOff += size;
        }
    }

    @Test
    public void testLABLargeAllocation() {
        MemStoreLAB mslab = new MemStoreLAB();
        MemStoreLAB.Allocation alloc = mslab.allocateBytes(0x200000);
        Assert.assertNull((String)"2MB allocation shouldn't be satisfied by LAB.", (Object)alloc);
    }

    @Test
    public void testLABThreading() throws Exception {
        Configuration conf = new Configuration();
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(conf);
        final AtomicInteger totalAllocated = new AtomicInteger();
        final MemStoreLAB mslab = new MemStoreLAB();
        ArrayList allocations = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            final LinkedList allocsByThisThread = Lists.newLinkedList();
            allocations.add(allocsByThisThread);
            MultithreadedTestUtil.RepeatingTestThread t = new MultithreadedTestUtil.RepeatingTestThread(ctx){
                private Random r;
                {
                    super(x0);
                    this.r = new Random();
                }

                @Override
                public void doAnAction() throws Exception {
                    int size = this.r.nextInt(1000);
                    MemStoreLAB.Allocation alloc = mslab.allocateBytes(size);
                    totalAllocated.addAndGet(size);
                    allocsByThisThread.add(new AllocRecord(alloc, size));
                }
            };
            ctx.addThread(t);
        }
        ctx.startThreads();
        while (totalAllocated.get() < 0x3200000 && ctx.shouldRun()) {
            Thread.sleep(10L);
        }
        ctx.stop();
        HashMap mapsByChunk = Maps.newHashMap();
        int sizeCounted = 0;
        for (AllocRecord rec : Iterables.concat((Iterable)allocations)) {
            sizeCounted += rec.size;
            if (rec.size == 0) continue;
            Map mapForThisByteArray = (Map)mapsByChunk.get(rec.alloc.getData());
            if (mapForThisByteArray == null) {
                mapForThisByteArray = Maps.newTreeMap();
                mapsByChunk.put(rec.alloc.getData(), mapForThisByteArray);
            }
            AllocRecord oldVal = mapForThisByteArray.put(rec.alloc.getOffset(), rec);
            Assert.assertNull((String)("Already had an entry " + oldVal + " for allocation " + rec), (Object)oldVal);
        }
        Assert.assertEquals((String)"Sanity check test", (long)sizeCounted, (long)totalAllocated.get());
        for (Map allocsInChunk : mapsByChunk.values()) {
            int expectedOff = 0;
            for (AllocRecord alloc : allocsInChunk.values()) {
                Assert.assertEquals((long)expectedOff, (long)alloc.alloc.getOffset());
                Assert.assertTrue((String)("Allocation " + alloc + " overruns buffer"), (alloc.alloc.getOffset() + alloc.size <= alloc.alloc.getData().length ? 1 : 0) != 0);
                expectedOff += alloc.size;
            }
        }
    }

    private static class AllocRecord
    implements Comparable<AllocRecord> {
        private final MemStoreLAB.Allocation alloc;
        private final int size;

        public AllocRecord(MemStoreLAB.Allocation alloc, int size) {
            this.alloc = alloc;
            this.size = size;
        }

        @Override
        public int compareTo(AllocRecord e) {
            if (this.alloc.getData() != e.alloc.getData()) {
                throw new RuntimeException("Can only compare within a particular array");
            }
            return Ints.compare((int)this.alloc.getOffset(), (int)e.alloc.getOffset());
        }

        public String toString() {
            return "AllocRecord(alloc=" + this.alloc + ", size=" + this.size + ")";
        }
    }
}

