/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.ScanDeleteTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestScanDeleteTracker
extends HBaseTestCase {
    private ScanDeleteTracker sdt;
    private long timestamp = 10L;
    private byte deleteType = 0;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sdt = new ScanDeleteTracker();
    }

    public void testDeletedBy_Delete() {
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"qualifier"), this.timestamp, KeyValue.Type.Delete);
        this.sdt.add((Cell)kv);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_DELETED, (Object)ret);
    }

    public void testDeletedBy_DeleteColumn() {
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"qualifier"), this.timestamp, KeyValue.Type.DeleteColumn);
        this.sdt.add((Cell)kv);
        this.timestamp -= 5L;
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"qualifier"), this.timestamp, KeyValue.Type.DeleteColumn);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.COLUMN_DELETED, (Object)ret);
    }

    public void testDeletedBy_DeleteFamily() {
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"qualifier"), this.timestamp, KeyValue.Type.DeleteFamily);
        this.sdt.add((Cell)kv);
        this.timestamp -= 5L;
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"qualifier"), this.timestamp, KeyValue.Type.DeleteColumn);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.FAMILY_DELETED, (Object)ret);
    }

    public void testDeletedBy_DeleteFamilyVersion() {
        byte[] qualifier1 = Bytes.toBytes((String)"qualifier1");
        byte[] qualifier2 = Bytes.toBytes((String)"qualifier2");
        byte[] qualifier3 = Bytes.toBytes((String)"qualifier3");
        byte[] qualifier4 = Bytes.toBytes((String)"qualifier4");
        this.deleteType = KeyValue.Type.DeleteFamilyVersion.getCode();
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), null, this.timestamp, KeyValue.Type.DeleteFamilyVersion);
        this.sdt.add((Cell)kv);
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier1, this.timestamp, KeyValue.Type.DeleteFamilyVersion);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED, (Object)ret);
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier2, this.timestamp, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED, (Object)ret);
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier3, this.timestamp, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED, (Object)ret);
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier4, this.timestamp, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED, (Object)ret);
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier1, this.timestamp + 3L, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)ret);
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier2, this.timestamp - 2L, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)ret);
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier3, this.timestamp - 5L, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)ret);
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier4, this.timestamp + 8L, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)ret);
    }

    public void testDelete_DeleteColumn() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.Delete.getCode();
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier, this.timestamp, KeyValue.Type.Delete);
        this.sdt.add((Cell)kv);
        this.timestamp -= 5L;
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier, this.timestamp, KeyValue.Type.DeleteColumn);
        this.deleteType = KeyValue.Type.DeleteColumn.getCode();
        this.sdt.add((Cell)kv);
        this.timestamp -= 5L;
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier, this.timestamp, KeyValue.Type.DeleteColumn);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.COLUMN_DELETED, (Object)ret);
    }

    public void testDeleteColumn_Delete() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.DeleteColumn.getCode();
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier, this.timestamp, KeyValue.Type.DeleteColumn);
        this.sdt.add((Cell)kv);
        qualifier = Bytes.toBytes((String)"qualifier1");
        this.deleteType = KeyValue.Type.Delete.getCode();
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier, this.timestamp, KeyValue.Type.Delete);
        this.sdt.add((Cell)kv);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.VERSION_DELETED, (Object)ret);
    }

    public void testDelete_KeepDelete() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.Delete.getCode();
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier, this.timestamp, KeyValue.Type.Delete);
        this.sdt.add((Cell)kv);
        this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((boolean)false, (boolean)this.sdt.isEmpty());
    }

    public void testDelete_KeepVersionZero() {
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        this.deleteType = KeyValue.Type.Delete.getCode();
        long deleteTimestamp = 10L;
        long valueTimestamp = 0L;
        this.sdt.reset();
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier, deleteTimestamp, KeyValue.Type.Delete);
        this.sdt.add((Cell)kv);
        kv = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"f"), qualifier, valueTimestamp, KeyValue.Type.Delete);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted((Cell)kv);
        TestScanDeleteTracker.assertEquals((Object)DeleteTracker.DeleteResult.NOT_DELETED, (Object)ret);
    }
}

