/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.TestTableName;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestAccessController2
extends SecureTestUtil {
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f");
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestAccessController2.enableSecurity(conf);
        TestAccessController2.verifyConfiguration(conf);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME.getName());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCreateWithCorrectOwner() throws Exception {
        User testUser = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"TestUser", (String[])new String[0]);
        SecureTestUtil.grantGlobal(TEST_UTIL, testUser.getShortName(), Permission.Action.CREATE);
        TestAccessController2.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTableDescriptor desc = new HTableDescriptor(TestAccessController2.this.TEST_TABLE.getTableName());
                desc.addFamily(new HColumnDescriptor(TEST_FAMILY));
                HBaseAdmin admin = new HBaseAdmin(conf);
                try {
                    admin.createTable(desc);
                }
                finally {
                    admin.close();
                }
                return null;
            }
        }, testUser);
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE.getTableName().getName());
        List perms = AccessControlLists.getTablePermissions((Configuration)conf, (TableName)this.TEST_TABLE.getTableName()).get((Object)testUser.getShortName());
        Assert.assertNotNull((Object)perms);
        Assert.assertFalse((boolean)perms.isEmpty());
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.READ));
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.WRITE));
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.EXEC));
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.CREATE));
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.ADMIN));
    }
}

