/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.QuotaScope;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestQuotaTableUtil {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Connection connection;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 2000);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        this.connection = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
    }

    @After
    public void after() throws IOException {
        this.connection.close();
    }

    @Test
    public void testTableQuotaUtil() throws Exception {
        TableName table = TableName.valueOf((String)"testTableQuotaUtilTable");
        QuotaProtos.Quotas quota = QuotaProtos.Quotas.newBuilder().setThrottle(QuotaProtos.Throttle.newBuilder().setReqNum(ProtobufUtil.toTimedQuota((long)1000L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setWriteNum(ProtobufUtil.toTimedQuota((long)600L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setReadSize(ProtobufUtil.toTimedQuota((long)8192L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).build()).build();
        QuotaUtil.addTableQuota((Connection)this.connection, (TableName)table, (QuotaProtos.Quotas)quota);
        QuotaProtos.Quotas resQuota = QuotaUtil.getTableQuota((Connection)this.connection, (TableName)table);
        Assert.assertEquals((Object)quota, (Object)resQuota);
        QuotaUtil.deleteTableQuota((Connection)this.connection, (TableName)table);
        resQuota = QuotaUtil.getTableQuota((Connection)this.connection, (TableName)table);
        Assert.assertEquals(null, (Object)resQuota);
    }

    @Test
    public void testNamespaceQuotaUtil() throws Exception {
        String namespace = "testNamespaceQuotaUtilNS";
        QuotaProtos.Quotas quota = QuotaProtos.Quotas.newBuilder().setThrottle(QuotaProtos.Throttle.newBuilder().setReqNum(ProtobufUtil.toTimedQuota((long)1000L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setWriteNum(ProtobufUtil.toTimedQuota((long)600L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setReadSize(ProtobufUtil.toTimedQuota((long)8192L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).build()).build();
        QuotaUtil.addNamespaceQuota((Connection)this.connection, (String)"testNamespaceQuotaUtilNS", (QuotaProtos.Quotas)quota);
        QuotaProtos.Quotas resQuota = QuotaUtil.getNamespaceQuota((Connection)this.connection, (String)"testNamespaceQuotaUtilNS");
        Assert.assertEquals((Object)quota, (Object)resQuota);
        QuotaUtil.deleteNamespaceQuota((Connection)this.connection, (String)"testNamespaceQuotaUtilNS");
        resQuota = QuotaUtil.getNamespaceQuota((Connection)this.connection, (String)"testNamespaceQuotaUtilNS");
        Assert.assertEquals(null, (Object)resQuota);
    }

    @Test
    public void testUserQuotaUtil() throws Exception {
        TableName table = TableName.valueOf((String)"testUserQuotaUtilTable");
        String namespace = "testNS";
        String user = "testUser";
        QuotaProtos.Quotas quotaNamespace = QuotaProtos.Quotas.newBuilder().setThrottle(QuotaProtos.Throttle.newBuilder().setReqNum(ProtobufUtil.toTimedQuota((long)50000L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).build()).build();
        QuotaProtos.Quotas quotaTable = QuotaProtos.Quotas.newBuilder().setThrottle(QuotaProtos.Throttle.newBuilder().setReqNum(ProtobufUtil.toTimedQuota((long)1000L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setWriteNum(ProtobufUtil.toTimedQuota((long)600L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setReadSize(ProtobufUtil.toTimedQuota((long)10000L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).build()).build();
        QuotaProtos.Quotas quota = QuotaProtos.Quotas.newBuilder().setThrottle(QuotaProtos.Throttle.newBuilder().setReqSize(ProtobufUtil.toTimedQuota((long)8192L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setWriteSize(ProtobufUtil.toTimedQuota((long)4096L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).setReadNum(ProtobufUtil.toTimedQuota((long)1000L, (TimeUnit)TimeUnit.SECONDS, (QuotaScope)QuotaScope.MACHINE)).build()).build();
        QuotaUtil.addUserQuota((Connection)this.connection, (String)"testUser", (QuotaProtos.Quotas)quota);
        QuotaProtos.Quotas resQuota = QuotaUtil.getUserQuota((Connection)this.connection, (String)"testUser");
        Assert.assertEquals((Object)quota, (Object)resQuota);
        QuotaUtil.addUserQuota((Connection)this.connection, (String)"testUser", (TableName)table, (QuotaProtos.Quotas)quotaTable);
        QuotaProtos.Quotas resQuotaTable = QuotaUtil.getUserQuota((Connection)this.connection, (String)"testUser", (TableName)table);
        Assert.assertEquals((Object)quotaTable, (Object)resQuotaTable);
        QuotaUtil.addUserQuota((Connection)this.connection, (String)"testUser", (String)"testNS", (QuotaProtos.Quotas)quotaNamespace);
        QuotaProtos.Quotas resQuotaNS = QuotaUtil.getUserQuota((Connection)this.connection, (String)"testUser", (String)"testNS");
        Assert.assertEquals((Object)quotaNamespace, (Object)resQuotaNS);
        QuotaUtil.deleteUserQuota((Connection)this.connection, (String)"testUser");
        resQuota = QuotaUtil.getUserQuota((Connection)this.connection, (String)"testUser");
        Assert.assertEquals(null, (Object)resQuota);
        QuotaUtil.deleteUserQuota((Connection)this.connection, (String)"testUser", (TableName)table);
        resQuotaTable = QuotaUtil.getUserQuota((Connection)this.connection, (String)"testUser", (TableName)table);
        Assert.assertEquals(null, (Object)resQuotaTable);
        QuotaUtil.deleteUserQuota((Connection)this.connection, (String)"testUser", (String)"testNS");
        resQuotaNS = QuotaUtil.getUserQuota((Connection)this.connection, (String)"testUser", (String)"testNS");
        Assert.assertEquals(null, (Object)resQuotaNS);
    }
}

