/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public abstract class ZKProcedureUtil
extends ZooKeeperListener
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ZKProcedureUtil.class);
    public static final String ACQUIRED_BARRIER_ZNODE_DEFAULT = "acquired";
    public static final String REACHED_BARRIER_ZNODE_DEFAULT = "reached";
    public static final String ABORT_ZNODE_DEFAULT = "abort";
    public final String baseZNode;
    protected final String acquiredZnode;
    protected final String reachedZnode;
    protected final String abortZnode;

    public ZKProcedureUtil(ZooKeeperWatcher watcher, String procDescription) throws KeeperException {
        super(watcher);
        watcher.registerListener((ZooKeeperListener)this);
        this.baseZNode = ZKUtil.joinZNode((String)watcher.baseZNode, (String)procDescription);
        this.acquiredZnode = ZKUtil.joinZNode((String)this.baseZNode, (String)ACQUIRED_BARRIER_ZNODE_DEFAULT);
        this.reachedZnode = ZKUtil.joinZNode((String)this.baseZNode, (String)REACHED_BARRIER_ZNODE_DEFAULT);
        this.abortZnode = ZKUtil.joinZNode((String)this.baseZNode, (String)ABORT_ZNODE_DEFAULT);
        ZKUtil.createWithParents((ZooKeeperWatcher)watcher, (String)this.acquiredZnode);
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)watcher, (String)this.reachedZnode);
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)watcher, (String)this.abortZnode);
    }

    @Override
    public void close() throws IOException {
    }

    public String getAcquiredBarrierNode(String opInstanceName) {
        return ZKProcedureUtil.getAcquireBarrierNode(this, opInstanceName);
    }

    public String getReachedBarrierNode(String opInstanceName) {
        return ZKProcedureUtil.getReachedBarrierNode(this, opInstanceName);
    }

    public String getAbortZNode(String opInstanceName) {
        return ZKProcedureUtil.getAbortNode(this, opInstanceName);
    }

    public String getAbortZnode() {
        return this.abortZnode;
    }

    public String getBaseZnode() {
        return this.baseZNode;
    }

    public String getAcquiredBarrier() {
        return this.acquiredZnode;
    }

    public static String getAcquireBarrierNode(ZKProcedureUtil controller, String opInstanceName) {
        return ZKUtil.joinZNode((String)controller.acquiredZnode, (String)opInstanceName);
    }

    public static String getReachedBarrierNode(ZKProcedureUtil controller, String opInstanceName) {
        return ZKUtil.joinZNode((String)controller.reachedZnode, (String)opInstanceName);
    }

    public static String getAbortNode(ZKProcedureUtil controller, String opInstanceName) {
        return ZKUtil.joinZNode((String)controller.abortZnode, (String)opInstanceName);
    }

    public ZooKeeperWatcher getWatcher() {
        return this.watcher;
    }

    boolean isInProcedurePath(String path) {
        return path.startsWith(this.baseZNode);
    }

    boolean isAcquiredNode(String path) {
        return path.equals(this.acquiredZnode);
    }

    boolean isAcquiredPathNode(String path) {
        return path.startsWith(this.acquiredZnode) && !path.equals(this.acquiredZnode) && this.isMemberNode(path, this.acquiredZnode);
    }

    boolean isReachedNode(String path) {
        return path.equals(this.reachedZnode);
    }

    boolean isReachedPathNode(String path) {
        return path.startsWith(this.reachedZnode) && !path.equals(this.reachedZnode) && this.isMemberNode(path, this.reachedZnode);
    }

    private boolean isMemberNode(String path, String statePath) {
        int count = 0;
        for (int i = statePath.length(); i < path.length(); ++i) {
            count += path.charAt(i) == '/' ? 1 : 0;
        }
        return count == 2;
    }

    boolean isAbortNode(String path) {
        return path.equals(this.abortZnode);
    }

    public boolean isAbortPathNode(String path) {
        return path.startsWith(this.abortZnode) && !path.equals(this.abortZnode);
    }

    void logZKTree(String root) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)"Current zk system:");
        String prefix = "|-";
        LOG.debug((Object)(prefix + root));
        try {
            this.logZKTree(root, prefix);
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    protected void logZKTree(String root, String prefix) throws KeeperException {
        List children = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.watcher, (String)root);
        if (children == null) {
            return;
        }
        for (String child : children) {
            LOG.debug((Object)(prefix + child));
            String node = ZKUtil.joinZNode((String)(root.equals("/") ? "" : root), (String)child);
            this.logZKTree(node, prefix + "---");
        }
    }

    public void clearChildZNodes() throws KeeperException {
        LOG.info((Object)("Clearing all procedure znodes: " + this.acquiredZnode + " " + this.reachedZnode + " " + this.abortZnode));
        ZKUtil.deleteChildrenRecursively((ZooKeeperWatcher)this.watcher, (String)this.acquiredZnode);
        ZKUtil.deleteChildrenRecursively((ZooKeeperWatcher)this.watcher, (String)this.reachedZnode);
        ZKUtil.deleteChildrenRecursively((ZooKeeperWatcher)this.watcher, (String)this.abortZnode);
    }

    public void clearZNodes(String procedureName) throws KeeperException {
        LOG.info((Object)("Clearing all znodes for procedure " + procedureName + "including nodes " + this.acquiredZnode + " " + this.reachedZnode + " " + this.abortZnode));
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)this.watcher, (String)this.getAcquiredBarrierNode(procedureName));
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)this.watcher, (String)this.getAbortZNode(procedureName));
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)this.watcher, (String)this.getAcquiredBarrierNode(procedureName));
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)this.watcher, (String)this.getReachedBarrierNode(procedureName));
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)this.watcher, (String)this.getAbortZNode(procedureName));
    }
}

