/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.CreateTableHandler;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.namespace.NamespaceAuditor;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.RegionStateListener;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MasterQuotaManager
implements RegionStateListener {
    private static final Log LOG = LogFactory.getLog(MasterQuotaManager.class);
    private final MasterServices masterServices;
    private NamedLock<String> namespaceLocks;
    private NamedLock<TableName> tableLocks;
    private NamedLock<String> userLocks;
    private boolean initialized = false;
    private NamespaceAuditor namespaceQuotaManager;

    public MasterQuotaManager(MasterServices masterServices) {
        this.masterServices = masterServices;
    }

    public void start() throws IOException {
        if (!QuotaUtil.isQuotaEnabled(this.masterServices.getConfiguration())) {
            LOG.info((Object)"Quota support disabled");
            return;
        }
        if (!MetaTableAccessor.tableExists((Connection)this.masterServices.getConnection(), (TableName)QuotaUtil.QUOTA_TABLE_NAME)) {
            LOG.info((Object)"Quota table not found. Creating...");
            this.createQuotaTable();
        }
        LOG.info((Object)"Initializing quota support");
        this.namespaceLocks = new NamedLock();
        this.tableLocks = new NamedLock();
        this.userLocks = new NamedLock();
        this.namespaceQuotaManager = new NamespaceAuditor(this.masterServices);
        this.namespaceQuotaManager.start();
        this.initialized = true;
    }

    public void stop() {
    }

    public boolean isQuotaInitialized() {
        return this.initialized && this.namespaceQuotaManager.isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MasterProtos.SetQuotaResponse setQuota(MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.checkQuotaSupport();
        if (req.hasUserName()) {
            this.userLocks.lock(req.getUserName());
            try {
                if (req.hasTableName()) {
                    this.setUserQuota(req.getUserName(), ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), req);
                }
                if (req.hasNamespace()) {
                    this.setUserQuota(req.getUserName(), req.getNamespace(), req);
                }
                this.setUserQuota(req.getUserName(), req);
            }
            finally {
                this.userLocks.unlock(req.getUserName());
            }
        } else if (req.hasTableName()) {
            TableName table = ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName());
            this.tableLocks.lock(table);
            try {
                this.setTableQuota(table, req);
            }
            finally {
                this.tableLocks.unlock(table);
            }
        } else if (req.hasNamespace()) {
            this.namespaceLocks.lock(req.getNamespace());
            try {
                this.setNamespaceQuota(req.getNamespace(), req);
            }
            finally {
                this.namespaceLocks.unlock(req.getNamespace());
            }
        } else {
            throw new DoNotRetryIOException((Throwable)new UnsupportedOperationException("a user, a table or a namespace must be specified"));
        }
        return MasterProtos.SetQuotaResponse.newBuilder().build();
    }

    public void setUserQuota(final String userName, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public QuotaProtos.Quotas fetch() throws IOException {
                return QuotaUtil.getUserQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), (String)userName);
            }

            @Override
            public void update(QuotaProtos.Quotas quotas) throws IOException {
                QuotaUtil.addUserQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), userName, quotas);
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteUserQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), userName);
            }

            @Override
            public void preApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetUserQuota(userName, quotas);
            }

            @Override
            public void postApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetUserQuota(userName, quotas);
            }
        });
    }

    public void setUserQuota(final String userName, final TableName table, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public QuotaProtos.Quotas fetch() throws IOException {
                return QuotaUtil.getUserQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), (String)userName, (TableName)table);
            }

            @Override
            public void update(QuotaProtos.Quotas quotas) throws IOException {
                QuotaUtil.addUserQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), userName, table, quotas);
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteUserQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), userName, table);
            }

            @Override
            public void preApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetUserQuota(userName, table, quotas);
            }

            @Override
            public void postApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetUserQuota(userName, table, quotas);
            }
        });
    }

    public void setUserQuota(final String userName, final String namespace, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public QuotaProtos.Quotas fetch() throws IOException {
                return QuotaUtil.getUserQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), (String)userName, (String)namespace);
            }

            @Override
            public void update(QuotaProtos.Quotas quotas) throws IOException {
                QuotaUtil.addUserQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), userName, namespace, quotas);
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteUserQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), userName, namespace);
            }

            @Override
            public void preApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetUserQuota(userName, namespace, quotas);
            }

            @Override
            public void postApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetUserQuota(userName, namespace, quotas);
            }
        });
    }

    public void setTableQuota(final TableName table, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public QuotaProtos.Quotas fetch() throws IOException {
                return QuotaUtil.getTableQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), (TableName)table);
            }

            @Override
            public void update(QuotaProtos.Quotas quotas) throws IOException {
                QuotaUtil.addTableQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), table, quotas);
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteTableQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), table);
            }

            @Override
            public void preApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetTableQuota(table, quotas);
            }

            @Override
            public void postApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetTableQuota(table, quotas);
            }
        });
    }

    public void setNamespaceQuota(final String namespace, MasterProtos.SetQuotaRequest req) throws IOException, InterruptedException {
        this.setQuota(req, new SetQuotaOperations(){

            @Override
            public QuotaProtos.Quotas fetch() throws IOException {
                return QuotaUtil.getNamespaceQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), (String)namespace);
            }

            @Override
            public void update(QuotaProtos.Quotas quotas) throws IOException {
                QuotaUtil.addNamespaceQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), namespace, quotas);
            }

            @Override
            public void delete() throws IOException {
                QuotaUtil.deleteNamespaceQuota((Connection)MasterQuotaManager.this.masterServices.getConnection(), namespace);
            }

            @Override
            public void preApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().preSetNamespaceQuota(namespace, quotas);
            }

            @Override
            public void postApply(QuotaProtos.Quotas quotas) throws IOException {
                MasterQuotaManager.this.masterServices.getMasterCoprocessorHost().postSetNamespaceQuota(namespace, quotas);
            }
        });
    }

    public void setNamespaceQuota(NamespaceDescriptor desc) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.addNamespace(desc);
        }
    }

    public void removeNamespaceQuota(String namespace) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.deleteNamespace(namespace);
        }
    }

    private void setQuota(MasterProtos.SetQuotaRequest req, SetQuotaOperations quotaOps) throws IOException, InterruptedException {
        QuotaProtos.Quotas.Builder builder;
        if (req.hasRemoveAll() && req.getRemoveAll()) {
            quotaOps.preApply(null);
            quotaOps.delete();
            quotaOps.postApply(null);
            return;
        }
        QuotaProtos.Quotas quotas = quotaOps.fetch();
        quotaOps.preApply(quotas);
        QuotaProtos.Quotas.Builder builder2 = builder = quotas != null ? quotas.toBuilder() : QuotaProtos.Quotas.newBuilder();
        if (req.hasThrottle()) {
            this.applyThrottle(builder, req.getThrottle());
        }
        if (req.hasBypassGlobals()) {
            this.applyBypassGlobals(builder, req.getBypassGlobals());
        }
        if (QuotaUtil.isEmptyQuota((QuotaProtos.Quotas)(quotas = builder.build()))) {
            quotaOps.delete();
        } else {
            quotaOps.update(quotas);
        }
        quotaOps.postApply(quotas);
    }

    public void checkNamespaceTableAndRegionQuota(TableName tName, int regions) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.checkQuotaToCreateTable(tName, regions);
        }
    }

    public void checkAndUpdateNamespaceRegionQuota(TableName tName, int regions) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.checkQuotaToUpdateRegion(tName, regions);
        }
    }

    public int getRegionCountOfTable(TableName tName) throws IOException {
        if (this.initialized) {
            return this.namespaceQuotaManager.getRegionCountOfTable(tName);
        }
        return -1;
    }

    @Override
    public void onRegionMerged(HRegionInfo hri) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.updateQuotaForRegionMerge(hri);
        }
    }

    @Override
    public void onRegionSplit(HRegionInfo hri) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.checkQuotaToSplitRegion(hri);
        }
    }

    public void removeTableFromNamespaceQuota(TableName tName) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.removeFromNamespaceUsage(tName);
        }
    }

    public NamespaceAuditor getNamespaceQuotaManager() {
        return this.namespaceQuotaManager;
    }

    private void applyThrottle(QuotaProtos.Quotas.Builder quotas, QuotaProtos.ThrottleRequest req) throws IOException {
        if (req.hasType() && (req.hasTimedQuota() || quotas.hasThrottle())) {
            if (req.hasTimedQuota()) {
                this.validateTimedQuota(req.getTimedQuota());
            }
            QuotaProtos.Throttle.Builder throttle = quotas.hasThrottle() ? quotas.getThrottle().toBuilder() : QuotaProtos.Throttle.newBuilder();
            switch (req.getType()) {
                case REQUEST_NUMBER: {
                    if (req.hasTimedQuota()) {
                        throttle.setReqNum(req.getTimedQuota());
                        break;
                    }
                    throttle.clearReqNum();
                    break;
                }
                case REQUEST_SIZE: {
                    if (req.hasTimedQuota()) {
                        throttle.setReqSize(req.getTimedQuota());
                        break;
                    }
                    throttle.clearReqSize();
                    break;
                }
                case WRITE_NUMBER: {
                    if (req.hasTimedQuota()) {
                        throttle.setWriteNum(req.getTimedQuota());
                        break;
                    }
                    throttle.clearWriteNum();
                    break;
                }
                case WRITE_SIZE: {
                    if (req.hasTimedQuota()) {
                        throttle.setWriteSize(req.getTimedQuota());
                        break;
                    }
                    throttle.clearWriteSize();
                    break;
                }
                case READ_NUMBER: {
                    if (req.hasTimedQuota()) {
                        throttle.setReadNum(req.getTimedQuota());
                        break;
                    }
                    throttle.clearReqNum();
                    break;
                }
                case READ_SIZE: {
                    if (req.hasTimedQuota()) {
                        throttle.setReadSize(req.getTimedQuota());
                        break;
                    }
                    throttle.clearReadSize();
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid throttle type: " + req.getType());
                }
            }
            quotas.setThrottle(throttle.build());
        } else {
            quotas.clearThrottle();
        }
    }

    private void applyBypassGlobals(QuotaProtos.Quotas.Builder quotas, boolean bypassGlobals) {
        if (bypassGlobals) {
            quotas.setBypassGlobals(bypassGlobals);
        } else {
            quotas.clearBypassGlobals();
        }
    }

    private void validateTimedQuota(QuotaProtos.TimedQuota timedQuota) throws IOException {
        if (timedQuota.getSoftLimit() < 1L) {
            throw new DoNotRetryIOException((Throwable)new UnsupportedOperationException("The throttle limit must be greater then 0, got " + timedQuota.getSoftLimit()));
        }
    }

    private void checkQuotaSupport() throws IOException {
        if (!QuotaUtil.isQuotaEnabled(this.masterServices.getConfiguration())) {
            throw new DoNotRetryIOException((Throwable)new UnsupportedOperationException("quota support disabled"));
        }
        if (!this.initialized) {
            long maxWaitTime = this.masterServices.getConfiguration().getLong("hbase.master.wait.for.quota.manager.init", 30000L);
            long startTime = EnvironmentEdgeManager.currentTime();
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted while waiting for Quota Manager to be initialized.");
                    break;
                }
            } while (!this.initialized && EnvironmentEdgeManager.currentTime() - startTime < maxWaitTime);
            if (!this.initialized) {
                throw new IOException("Quota manager is uninitialized, please retry later.");
            }
        }
    }

    private void createQuotaTable() throws IOException {
        HRegionInfo[] newRegions = new HRegionInfo[]{new HRegionInfo(QuotaUtil.QUOTA_TABLE_NAME)};
        if (this.masterServices.isMasterProcedureExecutorEnabled()) {
            this.masterServices.getMasterProcedureExecutor().submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)this.masterServices.getMasterProcedureExecutor().getEnvironment(), QuotaUtil.QUOTA_TABLE_DESC, newRegions));
        } else {
            this.masterServices.getExecutorService().submit(new CreateTableHandler(this.masterServices, this.masterServices.getMasterFileSystem(), QuotaUtil.QUOTA_TABLE_DESC, this.masterServices.getConfiguration(), newRegions, this.masterServices).prepare());
        }
    }

    @Override
    public void onRegionSplitReverted(HRegionInfo hri) throws IOException {
        if (this.initialized) {
            this.namespaceQuotaManager.removeRegionFromNamespaceUsage(hri);
        }
    }

    private static class NamedLock<T> {
        private HashSet<T> locks = new HashSet();

        private NamedLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock(T name) throws InterruptedException {
            HashSet<T> hashSet = this.locks;
            synchronized (hashSet) {
                while (this.locks.contains(name)) {
                    this.locks.wait();
                }
                this.locks.add(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(T name) {
            HashSet<T> hashSet = this.locks;
            synchronized (hashSet) {
                this.locks.remove(name);
                this.locks.notifyAll();
            }
        }
    }

    private static interface SetQuotaOperations {
        public QuotaProtos.Quotas fetch() throws IOException;

        public void delete() throws IOException;

        public void update(QuotaProtos.Quotas var1) throws IOException;

        public void preApply(QuotaProtos.Quotas var1) throws IOException;

        public void postApply(QuotaProtos.Quotas var1) throws IOException;
    }
}

