/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.master;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl;
import org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl;
import org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl;
import org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl;
import org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JvmVersion;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.Version;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class MasterStatusTmplImpl
extends AbstractTemplateImpl
implements MasterStatusTmpl.Intf {
    private final HMaster master;
    private final List<ServerName> servers;
    private final ServerName metaLocation;
    private final AssignmentManager assignmentManager;
    private final Map<String, Integer> frags;
    private final ServerManager serverManager;
    private final String filter;
    private final String format;
    private final Set<ServerName> deadServers;
    private final boolean catalogJanitorEnabled;

    public String formatZKString() {
        StringBuilder quorums = new StringBuilder();
        String zkQuorum = this.master.getZooKeeper().getQuorum();
        if (null == zkQuorum) {
            return quorums.toString();
        }
        String[] zks = zkQuorum.split(",");
        if (zks.length == 0) {
            return quorums.toString();
        }
        for (int i = 0; i < zks.length; ++i) {
            quorums.append(zks[i].trim());
            if (i == zks.length - 1) continue;
            quorums.append("<br/>");
        }
        return quorums.toString();
    }

    protected static MasterStatusTmpl.ImplData __jamon_setOptionalArguments(MasterStatusTmpl.ImplData p_implData) {
        if (!p_implData.getServers__IsNotDefault()) {
            p_implData.setServers(null);
        }
        if (!p_implData.getMetaLocation__IsNotDefault()) {
            p_implData.setMetaLocation(null);
        }
        if (!p_implData.getAssignmentManager__IsNotDefault()) {
            p_implData.setAssignmentManager(null);
        }
        if (!p_implData.getFrags__IsNotDefault()) {
            p_implData.setFrags(null);
        }
        if (!p_implData.getServerManager__IsNotDefault()) {
            p_implData.setServerManager(null);
        }
        if (!p_implData.getFilter__IsNotDefault()) {
            p_implData.setFilter("general");
        }
        if (!p_implData.getFormat__IsNotDefault()) {
            p_implData.setFormat("html");
        }
        if (!p_implData.getDeadServers__IsNotDefault()) {
            p_implData.setDeadServers(null);
        }
        if (!p_implData.getCatalogJanitorEnabled__IsNotDefault()) {
            p_implData.setCatalogJanitorEnabled(true);
        }
        return p_implData;
    }

    public MasterStatusTmplImpl(TemplateManager p_templateManager, MasterStatusTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)MasterStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.master = p_implData.getMaster();
        this.servers = p_implData.getServers();
        this.metaLocation = p_implData.getMetaLocation();
        this.assignmentManager = p_implData.getAssignmentManager();
        this.frags = p_implData.getFrags();
        this.serverManager = p_implData.getServerManager();
        this.filter = p_implData.getFilter();
        this.format = p_implData.getFormat();
        this.deadServers = p_implData.getDeadServers();
        this.catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        if (this.format.equals("json")) {
            jamonWriter.write("\n  ");
            TaskMonitorTmpl __jamon__var_6 = new TaskMonitorTmpl(this.getTemplateManager());
            __jamon__var_6.setFilter(this.filter);
            __jamon__var_6.setFormat("json");
            __jamon__var_6.renderNoFlush(jamonWriter);
            jamonWriter.write("\n  ");
            return;
        }
        jamonWriter.write("\n");
        ServerManager serverManager = this.master.getServerManager();
        AssignmentManager assignmentManager = this.master.getAssignmentManager();
        jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>Master: ");
        Escaping.NONE.write(StandardEmitter.valueOf((String)this.master.getServerName().getHostname()), jamonWriter);
        jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                ");
        if (HBaseConfiguration.isShowConfInServlet()) {
            jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
        }
        jamonWriter.write("\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container\">\n\t");
        if (this.master.isActiveMaster()) {
            jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
            Escaping.NONE.write(StandardEmitter.valueOf((String)this.master.getServerName().getHostname()), jamonWriter);
            jamonWriter.write(" </small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
            if (JvmVersion.isBadJvmVersion()) {
                jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
                Escaping.NONE.write(StandardEmitter.valueOf((String)System.getProperty("java.version")), jamonWriter);
                jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://wiki.apache.org/hadoop/Hbase/Troubleshooting#A18\">HBase wiki</a>\n          for details.\n          </div>\n        ");
            }
            jamonWriter.write("\n        ");
            if (this.master.isInitialized() && !this.catalogJanitorEnabled) {
                jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
            }
            jamonWriter.write("\n        ");
            if (!this.master.isBalancerOn()) {
                jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            The Load Balancer is not enabled which will eventually cause performance degradation\n            in HBase as Regions will not be distributed across all RegionServers. The balancer\n            is only expected to be disabled during rolling upgrade scenarios.\n          </div>\n        ");
            }
            jamonWriter.write("\n\n        <section>\n            <h2>Region Servers</h2>\n            ");
            RegionServerListTmpl __jamon__var_7 = new RegionServerListTmpl(this.getTemplateManager());
            __jamon__var_7.setServers(this.servers);
            __jamon__var_7.renderNoFlush(jamonWriter, this.master);
            jamonWriter.write("\n\n            ");
            if (this.deadServers != null) {
                jamonWriter.write("\n                ");
                this.__jamon_innerUnit__deadRegionServers(jamonWriter);
                jamonWriter.write("\n            ");
            }
            jamonWriter.write("\n        </section>\n        <section>\n            ");
            BackupMasterStatusTmpl __jamon__var_8 = new BackupMasterStatusTmpl(this.getTemplateManager());
            __jamon__var_8.renderNoFlush(jamonWriter, this.master);
            jamonWriter.write("\n        </section>\n        <section>\n            <h2>Tables</h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
            if (this.metaLocation != null) {
                jamonWriter.write("\n                            ");
                this.__jamon_innerUnit__userTables(jamonWriter);
                jamonWriter.write("\n                        ");
            }
            jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
            if (this.metaLocation != null) {
                jamonWriter.write("\n                            ");
                this.__jamon_innerUnit__catalogTables(jamonWriter);
                jamonWriter.write("\n                        ");
            }
            jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                        ");
            this.__jamon_innerUnit__userSnapshots(jamonWriter);
            jamonWriter.write("\n                    </div>\n                </div>\n            </div>\n        </section>\n        ");
            if (this.master.getAssignmentManager() != null) {
                jamonWriter.write("\n        ");
                AssignmentManagerStatusTmpl __jamon__var_9 = new AssignmentManagerStatusTmpl(this.getTemplateManager());
                __jamon__var_9.renderNoFlush(jamonWriter, this.master.getAssignmentManager());
                jamonWriter.write("\n        ");
            }
            jamonWriter.write("\n\t");
        } else {
            jamonWriter.write("\n        <section>\n            ");
            BackupMasterStatusTmpl __jamon__var_10 = new BackupMasterStatusTmpl(this.getTemplateManager());
            __jamon__var_10.renderNoFlush(jamonWriter, this.master);
            jamonWriter.write("\n        </section>\n\t");
        }
        jamonWriter.write("    \n\n\n        <section>\n            ");
        TaskMonitorTmpl __jamon__var_11 = new TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_11.setFilter(this.filter);
        __jamon__var_11.renderNoFlush(jamonWriter);
        jamonWriter.write("\n        </section>\n\n        <section>\n            <h2>Software Attributes</h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", revision=");
        Escaping.NONE.write(StandardEmitter.valueOf((String)VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.NONE.write(StandardEmitter.valueOf((String)VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>HBase Source Checksum</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)VersionInfo.getSrcChecksum()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>HBase source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", revision=");
        Escaping.NONE.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.NONE.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Source Checksum</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>Hadoop source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Version</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)Version.getVersion()), jamonWriter);
        jamonWriter.write(", revision=");
        Escaping.NONE.write(StandardEmitter.valueOf((int)Version.getRevision()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>ZooKeeper client version and revision</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Compiled</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)Version.getBuildDate()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>When ZooKeeper client version was compiled</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Quorum</td>\n                    <td> ");
        Escaping.NONE.write(StandardEmitter.valueOf((String)this.formatZKString()), jamonWriter);
        jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Base Path</td>\n                    <td> ");
        Escaping.NONE.write(StandardEmitter.valueOf((String)this.master.getZooKeeper().getBaseZNode()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((String)FSUtils.getRootDir(this.master.getConfiguration()).toString()), jamonWriter);
        jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
        Escaping.NONE.write(StandardEmitter.valueOf((Object)new Date(this.master.getMasterStartTime())), jamonWriter);
        jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
        if (this.master.isActiveMaster()) {
            jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
            Escaping.NONE.write(StandardEmitter.valueOf((Object)new Date(this.master.getMasterActiveTime())), jamonWriter);
            jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
            Escaping.NONE.write(StandardEmitter.valueOf((String)(this.master.getClusterId() != null ? this.master.getClusterId() : "Not set")), jamonWriter);
            jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
            Escaping.NONE.write(StandardEmitter.valueOf((String)(this.master.getServerManager() == null ? "0.00" : StringUtils.limitDecimalTo2((double)this.master.getServerManager().getAverageLoad()))), jamonWriter);
            jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
            if (this.frags != null) {
                jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
                Escaping.NONE.write(StandardEmitter.valueOf((String)(this.frags.get("-TOTAL-") != null ? this.frags.get("-TOTAL-") + "%" : "n/a")), jamonWriter);
                jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
            }
            jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
            Escaping.NONE.write(StandardEmitter.valueOf((String)(this.master.getMasterCoprocessorHost() == null ? "[]" : Arrays.toString(this.master.getMasterCoprocessors()))), jamonWriter);
            jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>LoadBalancer</td>\n\t                    <td>");
            Escaping.NONE.write(StandardEmitter.valueOf((String)this.master.getLoadBalancerClassName()), jamonWriter);
            jamonWriter.write("</td>\n\t                    <td>LoadBalancer to be used in the Master</td>\n\t                </tr>\n                ");
        }
        jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n  </body>\n</html>\n\n");
    }

    private void __jamon_innerUnit__userSnapshots(Writer jamonWriter) throws IOException {
        List snapshots = null;
        try (Admin admin = this.master.getConnection().getAdmin();){
            snapshots = this.master.isInitialized() ? admin.listSnapshots() : null;
        }
        if (snapshots != null && snapshots.size() > 0) {
            jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Snapshot Name</th>\n        <th>Table</th>\n        <th>Creation Time</th>\n    </tr>\n    ");
            for (HBaseProtos.SnapshotDescription snapshotDesc : snapshots) {
                jamonWriter.write("\n    ");
                TableName snapshotTable = TableName.valueOf((String)snapshotDesc.getTable());
                jamonWriter.write("<tr>\n        <td><a href=\"snapshot.jsp?name=");
                Escaping.NONE.write(StandardEmitter.valueOf((String)snapshotDesc.getName()), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)snapshotDesc.getName()), jamonWriter);
                jamonWriter.write("</a> </td>\n        <td><a href=\"table.jsp?name=");
                Escaping.NONE.write(StandardEmitter.valueOf((String)snapshotTable.getNameAsString()), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)snapshotTable.getNameAsString()), jamonWriter);
                jamonWriter.write("</a>\n        </td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf((Object)new Date(snapshotDesc.getCreationTime())), jamonWriter);
                jamonWriter.write("</td>\n    </tr>\n    ");
            }
            jamonWriter.write("\n    <p>");
            Escaping.NONE.write(StandardEmitter.valueOf((int)snapshots.size()), jamonWriter);
            jamonWriter.write(" snapshot(s) in set.</p>\n</table>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__catalogTables(Writer jamonWriter) throws IOException {
        HTableDescriptor[] sysTables = null;
        try (Admin admin = this.master.getConnection().getAdmin();){
            sysTables = this.master.isInitialized() ? admin.listTableDescriptorsByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) : null;
        }
        if (sysTables != null && sysTables.length > 0) {
            jamonWriter.write("\n<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
            if (this.frags != null) {
                jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
            }
            jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
            for (HTableDescriptor systemTable : sysTables) {
                jamonWriter.write("\n<tr>\n");
                TableName tableName = systemTable.getTableName();
                jamonWriter.write("<td><a href=\"table.jsp?name=");
                Escaping.NONE.write(StandardEmitter.valueOf((Object)tableName), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((Object)tableName), jamonWriter);
                jamonWriter.write("</a></td>\n    ");
                if (this.frags != null) {
                    jamonWriter.write("\n        <td align=\"center\">");
                    Escaping.NONE.write(StandardEmitter.valueOf((String)(this.frags.get(tableName.getNameAsString()) != null ? this.frags.get(tableName.getNameAsString()) + "%" : "n/a")), jamonWriter);
                    jamonWriter.write("</td>\n    ");
                }
                jamonWriter.write("\n    ");
                String description = null;
                if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
                    description = "The hbase:meta table holds references to all User Table regions";
                } else if (tableName.equals((Object)AccessControlLists.ACL_TABLE_NAME)) {
                    description = "The hbase:acl table holds information about acl";
                } else if (tableName.equals((Object)VisibilityConstants.LABELS_TABLE_NAME)) {
                    description = "The hbase:labels table holds information about visibility labels";
                } else if (tableName.equals((Object)TableName.NAMESPACE_TABLE_NAME)) {
                    description = "The hbase:namespace table holds information about namespaces.";
                } else if (tableName.equals((Object)QuotaUtil.QUOTA_TABLE_NAME)) {
                    description = "The hbase:quota table holds quota information about number or size of requests in a given time frame.";
                }
                jamonWriter.write("<td>");
                Escaping.NONE.write(StandardEmitter.valueOf((String)description), jamonWriter);
                jamonWriter.write("</td>\n</tr>\n");
            }
            jamonWriter.write("\n</table>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__userTables(Writer jamonWriter) throws IOException {
        HTableDescriptor[] tables = null;
        try (Admin admin = this.master.getConnection().getAdmin();){
            tables = this.master.isInitialized() ? admin.listTables() : null;
        }
        if (tables != null && tables.length > 0) {
            jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Namespace</th>\n        <th>Table Name</th>\n        ");
            if (this.frags != null) {
                jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
            }
            jamonWriter.write("\n        <th>Online Regions</th>\n        <th>Offline Regions</th>\n        <th>Failed Regions</th>\n        <th>Split Regions</th>\n        <th>Other Regions</th>\n        <th>Description</th>\n    </tr>\n    ");
            for (HTableDescriptor htDesc : tables) {
                jamonWriter.write("\n    ");
                Map<RegionState.State, List<HRegionInfo>> tableRegions = this.master.getAssignmentManager().getRegionStates().getRegionByStateOfTable(htDesc.getTableName());
                int openRegionsCount = tableRegions.get(RegionState.State.OPEN).size();
                int offlineRegionsCount = tableRegions.get(RegionState.State.OFFLINE).size();
                int splitRegionsCount = tableRegions.get(RegionState.State.SPLIT).size();
                int failedRegionsCount = tableRegions.get(RegionState.State.FAILED_OPEN).size() + tableRegions.get(RegionState.State.FAILED_CLOSE).size();
                int otherRegionsCount = 0;
                for (List<HRegionInfo> list : tableRegions.values()) {
                    otherRegionsCount += list.size();
                }
                otherRegionsCount = otherRegionsCount - openRegionsCount - failedRegionsCount - offlineRegionsCount - splitRegionsCount;
                jamonWriter.write("<tr>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf((String)htDesc.getTableName().getNamespaceAsString()), jamonWriter);
                jamonWriter.write("</td>\n        <td><a href=table.jsp?name=");
                Escaping.NONE.write(StandardEmitter.valueOf((String)htDesc.getTableName().getNameAsString()), jamonWriter);
                jamonWriter.write(">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)htDesc.getTableName().getQualifierAsString()), jamonWriter);
                jamonWriter.write("</a> </td>\n        ");
                if (this.frags != null) {
                    jamonWriter.write("\n            <td align=\"center\">");
                    Escaping.NONE.write(StandardEmitter.valueOf((String)(this.frags.get(htDesc.getTableName().getNameAsString()) != null ? this.frags.get(htDesc.getTableName().getQualifierAsString()) + "%" : "n/a")), jamonWriter);
                    jamonWriter.write("</td>\n        ");
                }
                jamonWriter.write("\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf((int)openRegionsCount), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf((int)offlineRegionsCount), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf((int)failedRegionsCount), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf((int)splitRegionsCount), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf((int)otherRegionsCount), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf((String)htDesc.toStringCustomizedValues()), jamonWriter);
                jamonWriter.write("</td>\n    </tr>\n    ");
            }
            jamonWriter.write("\n    <p>");
            Escaping.NONE.write(StandardEmitter.valueOf((int)tables.length), jamonWriter);
            jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</table>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__deadRegionServers(Writer jamonWriter) throws IOException {
        if (this.deadServers != null && this.deadServers.size() > 0) {
            jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
            DeadServer deadServerUtil = this.master.getServerManager().getDeadServers();
            Object[] deadServerNames = this.deadServers.toArray(new ServerName[this.deadServers.size()]);
            Arrays.sort(deadServerNames);
            for (Object deadServerName : deadServerNames) {
                jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf((Object)deadServerName), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.NONE.write(StandardEmitter.valueOf((Object)deadServerUtil.getTimeOfDeath((ServerName)deadServerName)), jamonWriter);
                jamonWriter.write("</td>\n    </tr>\n    ");
            }
            jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
            Escaping.NONE.write(StandardEmitter.valueOf((int)this.deadServers.size()), jamonWriter);
            jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
        }
        jamonWriter.write("\n");
    }
}

