/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class GroupingTableMap
extends MapReduceBase
implements TableMap<ImmutableBytesWritable, Result> {
    public static final String GROUP_COLUMNS = "hbase.mapred.groupingtablemap.columns";
    protected byte[][] columns;

    public static void initJob(String table, String columns, String groupColumns, Class<? extends TableMap> mapper, JobConf job) {
        TableMapReduceUtil.initTableMapJob(table, columns, mapper, ImmutableBytesWritable.class, Result.class, job);
        job.set(GROUP_COLUMNS, groupColumns);
    }

    public void configure(JobConf job) {
        super.configure(job);
        String[] cols = job.get(GROUP_COLUMNS, "").split(" ");
        this.columns = new byte[cols.length][];
        for (int i = 0; i < cols.length; ++i) {
            this.columns[i] = Bytes.toBytes((String)cols[i]);
        }
    }

    public void map(ImmutableBytesWritable key, Result value, OutputCollector<ImmutableBytesWritable, Result> output, Reporter reporter) throws IOException {
        byte[][] keyVals = this.extractKeyValues(value);
        if (keyVals != null) {
            ImmutableBytesWritable tKey = this.createGroupKey(keyVals);
            output.collect((Object)tKey, (Object)value);
        }
    }

    protected byte[][] extractKeyValues(Result r) {
        byte[][] keyVals = null;
        ArrayList<byte[]> foundList = new ArrayList<byte[]>();
        int numCols = this.columns.length;
        if (numCols > 0) {
            block0: for (Cell value : r.listCells()) {
                byte[] column = KeyValue.makeColumn((byte[])CellUtil.cloneFamily((Cell)value), (byte[])CellUtil.cloneQualifier((Cell)value));
                for (int i = 0; i < numCols; ++i) {
                    if (!Bytes.equals((byte[])column, (byte[])this.columns[i])) continue;
                    foundList.add(CellUtil.cloneValue((Cell)value));
                    continue block0;
                }
            }
            if (foundList.size() == numCols) {
                keyVals = (byte[][])foundList.toArray((T[])new byte[numCols][]);
            }
        }
        return keyVals;
    }

    protected ImmutableBytesWritable createGroupKey(byte[][] vals) {
        if (vals == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < vals.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(Bytes.toString((byte[])vals[i]));
        }
        return new ImmutableBytesWritable(Bytes.toBytes((String)sb.toString()));
    }
}

