/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WAL;

@InterfaceAudience.Private
public class WALUtil {
    static final Log LOG = LogFactory.getLog(WALUtil.class);

    public static void writeCompactionMarker(WAL log, HTableDescriptor htd, HRegionInfo info, WALProtos.CompactionDescriptor c, AtomicLong sequenceId) throws IOException {
        TableName tn = TableName.valueOf((byte[])c.getTableName().toByteArray());
        HLogKey key = new HLogKey(info.getEncodedNameAsBytes(), tn);
        log.append(htd, info, key, WALEdit.createCompaction(info, c), sequenceId, false, null);
        log.sync();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended compaction marker " + TextFormat.shortDebugString((MessageOrBuilder)c)));
        }
    }

    public static long writeFlushMarker(WAL log, HTableDescriptor htd, HRegionInfo info, WALProtos.FlushDescriptor f, AtomicLong sequenceId, boolean sync) throws IOException {
        TableName tn = TableName.valueOf((byte[])f.getTableName().toByteArray());
        HLogKey key = new HLogKey(info.getEncodedNameAsBytes(), tn);
        long trx = log.append(htd, info, key, WALEdit.createFlushWALEdit(info, f), sequenceId, false, null);
        if (sync) {
            log.sync(trx);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended flush marker " + TextFormat.shortDebugString((MessageOrBuilder)f)));
        }
        return trx;
    }

    public static long writeRegionEventMarker(WAL log, HTableDescriptor htd, HRegionInfo info, WALProtos.RegionEventDescriptor r, AtomicLong sequenceId) throws IOException {
        TableName tn = TableName.valueOf((byte[])r.getTableName().toByteArray());
        HLogKey key = new HLogKey(info.getEncodedNameAsBytes(), tn);
        long trx = log.append(htd, info, key, WALEdit.createRegionEventWALEdit(info, r), sequenceId, false, null);
        log.sync(trx);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended region event marker " + TextFormat.shortDebugString((MessageOrBuilder)r)));
        }
        return trx;
    }

    public static long writeBulkLoadMarkerAndSync(WAL wal, HTableDescriptor htd, HRegionInfo info, WALProtos.BulkLoadDescriptor descriptor, AtomicLong sequenceId) throws IOException {
        TableName tn = info.getTable();
        HLogKey key = new HLogKey(info.getEncodedNameAsBytes(), tn);
        long trx = wal.append(htd, info, key, WALEdit.createBulkLoadEvent(info, descriptor), sequenceId, false, new ArrayList<Cell>());
        wal.sync(trx);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Appended Bulk Load marker " + TextFormat.shortDebugString((MessageOrBuilder)descriptor)));
        }
        return trx;
    }
}

