// Autogenerated Jamon implementation
// /home/busbey/projects/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/common/TaskMonitorTmpl.jamon

package org.apache.hadoop.hbase.tmpl.common;

// 20, 1
import java.util.*;
// 21, 1
import org.apache.hadoop.hbase.monitoring.*;
// 22, 1
import org.apache.hadoop.util.StringUtils;
// 23, 1
import org.owasp.esapi.ESAPI;
// 24, 1
import org.owasp.esapi.errors.EncodingException;

public class TaskMonitorTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.Intf

{
  private final String format;
  private final String filter;
  private final TaskMonitor taskMonitor;
  // 31, 1
  
    public String encodeFilter() {
    try {
    return ESAPI.encoder().encodeForURL(filter);
    }catch(EncodingException e) {}
    return ESAPI.encoder().encodeForHTML(filter);
    }

  protected static org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData p_implData)
  {
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getTaskMonitor__IsNotDefault())
    {
      p_implData.setTaskMonitor(TaskMonitor.get());
    }
    return p_implData;
  }
  public TaskMonitorTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    format = p_implData.getFormat();
    filter = p_implData.getFilter();
    taskMonitor = p_implData.getTaskMonitor();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 39, 1
    
List<? extends MonitoredTask> tasks = taskMonitor.getTasks();
Iterator<? extends MonitoredTask> iter = tasks.iterator();
// apply requested filter
while (iter.hasNext()) {
  MonitoredTask t = iter.next();
  if (filter.equals("general")) {
    if (t instanceof MonitoredRPCHandler)
      iter.remove();
  } else if (filter.equals("handler")) {
    if (!(t instanceof MonitoredRPCHandler))
      iter.remove();
  } else if (filter.equals("rpc")) {
    if (!(t instanceof MonitoredRPCHandler) || 
        !((MonitoredRPCHandler) t).isRPCRunning())
      iter.remove();
  } else if (filter.equals("operation")) {
    if (!(t instanceof MonitoredRPCHandler) || 
        !((MonitoredRPCHandler) t).isOperationRunning())
      iter.remove();
  }
}
long now = System.currentTimeMillis();
Collections.reverse(tasks);
boolean first = true;

    // 65, 1
    if (format.equals("json"))
    {
      // 65, 29
      jamonWriter.write("\n[");
      // 66, 2
      for (MonitoredTask task : tasks)
      {
        // 66, 36
        if (first)
        {
          // 66, 48
          first = false;
        }
        // 66, 77
        else
        {
          // 66, 84
          jamonWriter.write(",");
        }
        // 66, 91
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.toJSON()), jamonWriter);
      }
      // 66, 117
      jamonWriter.write("]\n");
    }
    // 67, 1
    else
    {
      // 67, 8
      jamonWriter.write("\n<h2>Tasks</h2>\n  <ul class=\"nav nav-pills\">\n    <li ");
      // 70, 9
      if (filter.equals("all"))
      {
        // 70, 36
        jamonWriter.write("class=\"active\"");
      }
      // 70, 56
      jamonWriter.write("><a href=\"?filter=all\">Show All Monitored Tasks</a></li>\n    <li ");
      // 71, 9
      if (filter.equals("general"))
      {
        // 71, 40
        jamonWriter.write("class=\"active\"");
      }
      // 71, 60
      jamonWriter.write("><a href=\"?filter=general\">Show non-RPC Tasks</a></li>\n    <li ");
      // 72, 9
      if (filter.equals("handler"))
      {
        // 72, 40
        jamonWriter.write("class=\"active\"");
      }
      // 72, 60
      jamonWriter.write("><a href=\"?filter=handler\">Show All RPC Handler Tasks</a></li>\n    <li ");
      // 73, 9
      if (filter.equals("rpc"))
      {
        // 73, 36
        jamonWriter.write("class=\"active\"");
      }
      // 73, 56
      jamonWriter.write("><a href=\"?filter=rpc\">Show Active RPC Calls</a></li>\n    <li ");
      // 74, 9
      if (filter.equals("operation"))
      {
        // 74, 42
        jamonWriter.write("class=\"active\"");
      }
      // 74, 62
      jamonWriter.write("><a href=\"?filter=operation\">Show Client Operations</a></li>\n    <li><a href=\"?format=json&filter=");
      // 75, 38
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(encodeFilter()), jamonWriter);
      // 75, 58
      jamonWriter.write("\">View as JSON</a></li>\n  </ul>\n  ");
      // 77, 3
      if (tasks.isEmpty())
      {
        // 77, 25
        jamonWriter.write("\n    <p>No tasks currently running on this node.</p>\n  ");
      }
      // 79, 3
      else
      {
        // 79, 10
        jamonWriter.write("\n    <table class=\"table\">\n    <tr>\n      <th>Start Time</th>\n      <th>Description</th>\n      <th>State</th>\n      <th>Status</th>\n    </tr>\n    ");
        // 87, 5
        for (MonitoredTask task : tasks )
        {
          // 87, 40
          jamonWriter.write("\n    <tr class=\"");
          // 88, 16
          {
            // 88, 16
            __jamon_innerUnit__stateCss(jamonWriter, task.getState() );
          }
          // 88, 55
          jamonWriter.write("\">\n      <td>");
          // 89, 11
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(task.getStartTime())), jamonWriter);
          // 89, 46
          jamonWriter.write("</td>\n      <td>");
          // 90, 11
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getDescription()), jamonWriter);
          // 90, 38
          jamonWriter.write("</td>\n      <td>");
          // 91, 11
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getState()), jamonWriter);
          // 91, 32
          jamonWriter.write("\n          (since ");
          // 92, 18
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.formatTimeDiff(now, task.getStateTime())), jamonWriter);
          // 92, 76
          jamonWriter.write(" ago)\n      </td>\n      <td>");
          // 94, 11
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getStatus()), jamonWriter);
          // 94, 33
          jamonWriter.write("\n          (since ");
          // 95, 18
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.formatTimeDiff(now, task.getStatusTime())), jamonWriter);
          // 95, 77
          jamonWriter.write(" \n          ago)</td>\n    </tr>\n    ");
        }
        // 98, 12
        jamonWriter.write("\n    </table>\n\n  ");
      }
      // 101, 9
      jamonWriter.write("\n");
    }
    // 102, 7
    jamonWriter.write("\n\n\n");
  }
  
  
  // 105, 1
  private void __jamon_innerUnit__stateCss(final java.io.Writer jamonWriter, final MonitoredTask.State state)
    throws java.io.IOException
  {
    // 109, 1
           if (state == MonitoredTask.State.COMPLETE) { 
    // 109, 68
    jamonWriter.write("alert alert-success");
    // 109, 87
     } 
    // 110, 1
      else if (state == MonitoredTask.State.ABORTED)  { 
    // 110, 68
    jamonWriter.write("alert alert-error");
    // 110, 85
       } 
  }
  
  
}
