// Autogenerated Jamon implementation
// /home/busbey/projects/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/AssignmentManagerStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 20, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 21, 1
import org.apache.hadoop.hbase.master.AssignmentManager;
// 22, 1
import org.apache.hadoop.hbase.master.RegionState;
// 23, 1
import org.apache.hadoop.conf.Configuration;
// 24, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 25, 1
import org.apache.hadoop.hbase.HConstants;
// 26, 1
import java.util.Iterator;
// 27, 1
import java.util.Map;

public class AssignmentManagerStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.Intf

{
  private final AssignmentManager assignmentManager;
  private final int limit;
  protected static org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getLimit__IsNotDefault())
    {
      p_implData.setLimit(100);
    }
    return p_implData;
  }
  public AssignmentManagerStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    assignmentManager = p_implData.getAssignmentManager();
    limit = p_implData.getLimit();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 33, 1
    
Map<String, RegionState> rit = assignmentManager
  .getRegionStates().getRegionsInTransition();
// process the map to find region in transition details
Configuration conf = HBaseConfiguration.create();
int ritThreshold = conf.getInt(HConstants.METRICS_RIT_STUCK_WARNING_THRESHOLD, 60000);
int numOfRITOverThreshold = 0;
long maxRITTime = Long.MIN_VALUE;
long currentTime = System.currentTimeMillis();
String regionIDForOldestRIT = ""; // avoiding null
for (Map.Entry<String, RegionState> e : rit.entrySet()) {
  long ritTime = currentTime - e.getValue().getStamp();
  if(ritTime > ritThreshold) {
     numOfRITOverThreshold++;
   }
   if(maxRITTime < ritTime) {
     maxRITTime = ritTime;
     regionIDForOldestRIT = e.getKey();
   }
}

int totalRITs = rit.size();
int toRemove = rit.size() - limit;
int removed = 0;
if (toRemove > 0) {
  // getRegionsInTransition returned a copy, so we can mutate it
  for (Iterator<Map.Entry<String, RegionState>> it = rit.entrySet().iterator();
       it.hasNext() && toRemove > 0;
       ) {
    Map.Entry<String, RegionState> e = it.next();
    if (HRegionInfo.FIRST_META_REGIONINFO.getEncodedName().equals(
          e.getKey()) ||
         regionIDForOldestRIT.equals(e.getKey())) {
      // don't remove the meta & the oldest rit regions, they're too interesting!
      continue;
    } 
    it.remove();
    toRemove--;
    removed++;
  }
}


    // 78, 1
    if (!rit.isEmpty() )
    {
      // 78, 23
      jamonWriter.write("\n    <section>\n    <h2>Regions in Transition</h2>\n    <table class=\"table table-striped\">\n            <tr><th>Region</th><th>State</th><th>RIT time (ms)</th></tr>\n            ");
      // 83, 13
      for (Map.Entry<String, RegionState> entry : rit.entrySet() )
      {
        // 83, 75
        jamonWriter.write("\n            ");
        // 84, 13
        if (regionIDForOldestRIT.equals(entry.getKey()) )
        {
          // 84, 64
          jamonWriter.write("\n                    <tr BGCOLOR=\"#FE2E2E\" >\n            ");
        }
        // 86, 13
        else
        {
          // 86, 20
          jamonWriter.write("\n                    <tr>\n            ");
        }
        // 88, 19
        jamonWriter.write("\n            <td>");
        // 89, 17
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(entry.getKey()), jamonWriter);
        // 89, 37
        jamonWriter.write("</td><td>");
        // 89, 46
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(entry.getValue().toDescriptiveString()), jamonWriter);
        // 89, 90
        jamonWriter.write("</td>\n    <td>");
        // 90, 9
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf((currentTime - entry.getValue().getStamp())), jamonWriter);
        // 90, 58
        jamonWriter.write(" </td></tr>\n            ");
      }
      // 91, 20
      jamonWriter.write("\n            <tr BGCOLOR=\"#D7DF01\"> <td>Total number of Regions in Transition for more than ");
      // 92, 92
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(ritThreshold), jamonWriter);
      // 92, 110
      jamonWriter.write(" milliseconds</td><td> ");
      // 92, 133
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numOfRITOverThreshold), jamonWriter);
      // 92, 160
      jamonWriter.write("</td><td></td>\n            </tr>\n    <tr> <td> Total number of Regions in Transition</td><td>");
      // 94, 61
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRITs), jamonWriter);
      // 94, 76
      jamonWriter.write(" </td><td></td>\n    </table>\n    ");
      // 96, 5
      if (removed > 0 )
      {
        // 96, 24
        jamonWriter.write("\n    (");
        // 97, 6
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(removed), jamonWriter);
        // 97, 19
        jamonWriter.write(" more regions in transition not shown)\n    ");
      }
      // 98, 11
      jamonWriter.write("\n    </section>\n");
    }
    // 100, 7
    jamonWriter.write("\n\n");
  }
  
  
}
