/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestGlobalMemStoreSize {
    private static final Log LOG = LogFactory.getLog(TestGlobalMemStoreSize.class);
    private static int regionServerNum = 4;
    private static int regionNum = 16;
    private static int totalRegionNum = regionNum + 2;
    private HBaseTestingUtility TEST_UTIL;
    private MiniHBaseCluster cluster;

    @Test
    public void testGlobalMemStore() throws Exception {
        LOG.info((Object)"Starting cluster");
        Configuration conf = HBaseConfiguration.create();
        this.TEST_UTIL = new HBaseTestingUtility(conf);
        this.TEST_UTIL.startMiniCluster(1, regionServerNum);
        this.cluster = this.TEST_UTIL.getHBaseCluster();
        LOG.info((Object)"Waiting for active/ready master");
        this.cluster.waitForActiveAndReadyMaster();
        byte[] table = Bytes.toBytes((String)"TestGlobalMemStoreSize");
        byte[] family = Bytes.toBytes((String)"family");
        LOG.info((Object)("Creating table with " + regionNum + " regions"));
        HTable ht = this.TEST_UTIL.createMultiRegionTable(TableName.valueOf((byte[])table), family, regionNum);
        int numRegions = -1;
        try (RegionLocator r = ht.getRegionLocator();){
            numRegions = r.getStartKeys().length;
        }
        Assert.assertEquals((long)regionNum, (long)numRegions);
        this.waitForAllRegionsAssigned();
        for (HRegionServer server : this.getOnlineRegionServers()) {
            long globalMemStoreSize = 0L;
            for (HRegionInfo regionInfo : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices())) {
                globalMemStoreSize += server.getFromOnlineRegions(regionInfo.getEncodedName()).getMemstoreSize();
            }
            Assert.assertEquals((long)server.getRegionServerAccounting().getGlobalMemstoreSize(), (long)globalMemStoreSize);
        }
        int i = 0;
        for (HRegionServer server : this.getOnlineRegionServers()) {
            LOG.info((Object)("Starting flushes on " + server.getServerName() + ", size=" + server.getRegionServerAccounting().getGlobalMemstoreSize()));
            for (HRegionInfo regionInfo : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices())) {
                Region r = server.getFromOnlineRegions(regionInfo.getEncodedName());
                this.flush(r, server);
            }
            LOG.info((Object)("Post flush on " + server.getServerName()));
            long now = System.currentTimeMillis();
            long timeout = now + 1000L;
            while (server.getRegionServerAccounting().getGlobalMemstoreSize() != 0L && timeout < System.currentTimeMillis()) {
                Threads.sleep((long)10L);
            }
            long size = server.getRegionServerAccounting().getGlobalMemstoreSize();
            if (size > 0L) {
                for (HRegionInfo regionInfo : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server.getRSRpcServices())) {
                    Region r = server.getFromOnlineRegions(regionInfo.getEncodedName());
                    long l = r.getMemstoreSize();
                    if (l <= 0L) continue;
                    Assert.assertTrue((boolean)regionInfo.isMetaRegion());
                    LOG.info((Object)(r.toString() + " " + l + ", reflushing"));
                    r.flush(true);
                }
            }
            size = server.getRegionServerAccounting().getGlobalMemstoreSize();
            Assert.assertEquals((String)("Server=" + server.getServerName() + ", i=" + i++), (long)0L, (long)size);
        }
        ht.close();
        this.TEST_UTIL.shutdownMiniCluster();
    }

    private void flush(Region r, HRegionServer server) throws IOException {
        LOG.info((Object)("Flush " + r.toString() + " on " + server.getServerName() + ", " + r.flush(true) + ", size=" + server.getRegionServerAccounting().getGlobalMemstoreSize()));
    }

    private List<HRegionServer> getOnlineRegionServers() {
        ArrayList<HRegionServer> list = new ArrayList<HRegionServer>();
        for (JVMClusterUtil.RegionServerThread rst : this.cluster.getRegionServerThreads()) {
            if (!rst.getRegionServer().isOnline()) continue;
            list.add(rst.getRegionServer());
        }
        return list;
    }

    private void waitForAllRegionsAssigned() throws IOException {
        int regionCount;
        while ((regionCount = HBaseTestingUtility.getAllOnlineRegions(this.cluster).size()) < totalRegionNum) {
            LOG.debug((Object)("Waiting for there to be " + totalRegionNum + " regions, but there are " + regionCount + " right now."));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

