/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.LruCachedBlock;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ClassSize;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestLruBlockCache {
    @Test
    public void testBackgroundEvictionThread() throws Exception {
        long maxSize = 100000L;
        int numBlocks = 9;
        long blockSize = this.calculateBlockSizeDefault(maxSize, numBlocks);
        Assert.assertTrue((String)"calculateBlockSize appears broken.", (blockSize * (long)numBlocks <= maxSize ? 1 : 0) != 0);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize);
        LruBlockCache.EvictionThread evictionThread = cache.getEvictionThread();
        Assert.assertTrue((evictionThread != null ? 1 : 0) != 0);
        CachedItem[] blocks = this.generateFixedBlocks(numBlocks + 1, blockSize, "block");
        while (!evictionThread.isEnteringRun()) {
            Thread.sleep(1L);
        }
        for (CachedItem block : blocks) {
            cache.cacheBlock(block.cacheKey, (Cacheable)block);
        }
        int n = 0;
        while (cache.getStats().getEvictionCount() == 0L) {
            Thread.sleep(200L);
            Assert.assertTrue((String)"Eviction never happened.", (n++ < 20 ? 1 : 0) != 0);
        }
        n = 0;
        long prevCnt = 0L;
        long curCnt = cache.getBlockCount();
        while (prevCnt != curCnt) {
            Thread.sleep(200L);
            Assert.assertTrue((String)"Cache never stabilized.", (n++ < 20 ? 1 : 0) != 0);
            prevCnt = curCnt;
            curCnt = cache.getBlockCount();
        }
        long evictionCount = cache.getStats().getEvictionCount();
        Assert.assertTrue((evictionCount >= 1L ? 1 : 0) != 0);
        System.out.println("Background Evictions run: " + evictionCount);
    }

    @Test
    public void testCacheSimple() throws Exception {
        long maxSize = 1000000L;
        long blockSize = this.calculateBlockSizeDefault(maxSize, 101);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize);
        CachedItem[] blocks = this.generateRandomBlocks(100, blockSize);
        long expectedCacheSize = cache.heapSize();
        for (CachedItem block : blocks) {
            Assert.assertTrue((cache.getBlock(block.cacheKey, true, false, true) == null ? 1 : 0) != 0);
        }
        for (CachedItem block : blocks) {
            cache.cacheBlock(block.cacheKey, (Cacheable)block);
            expectedCacheSize += block.cacheBlockHeapSize();
        }
        Assert.assertEquals((long)expectedCacheSize, (long)cache.heapSize());
        for (CachedItem block : blocks) {
            Cacheable buf = cache.getBlock(block.cacheKey, true, false, true);
            Assert.assertTrue((buf != null ? 1 : 0) != 0);
            Assert.assertEquals((long)buf.heapSize(), (long)block.heapSize());
        }
        long expectedBlockCount = cache.getBlockCount();
        for (CachedItem block : blocks) {
            cache.cacheBlock(block.cacheKey, (Cacheable)block);
        }
        Assert.assertEquals((String)"Cache should ignore cache requests for blocks already in cache", (long)expectedBlockCount, (long)cache.getBlockCount());
        Assert.assertEquals((long)expectedCacheSize, (long)cache.heapSize());
        for (CachedItem block : blocks) {
            Cacheable buf = cache.getBlock(block.cacheKey, true, false, true);
            Assert.assertTrue((buf != null ? 1 : 0) != 0);
            Assert.assertEquals((long)buf.heapSize(), (long)block.heapSize());
        }
        Assert.assertEquals((long)0L, (long)cache.getStats().getEvictionCount());
        LruBlockCache.StatisticsThread t = new LruBlockCache.StatisticsThread(cache);
        t.start();
        t.join();
    }

    @Test
    public void testCacheEvictionSimple() throws Exception {
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSizeDefault(maxSize, 10);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize, false);
        CachedItem[] blocks = this.generateFixedBlocks(10, blockSize, "block");
        long expectedCacheSize = cache.heapSize();
        for (CachedItem block : blocks) {
            cache.cacheBlock(block.cacheKey, (Cacheable)block);
            expectedCacheSize += block.cacheBlockHeapSize();
        }
        Assert.assertEquals((long)1L, (long)cache.getStats().getEvictionCount());
        Assert.assertTrue(((float)expectedCacheSize > (float)maxSize * 0.99f ? 1 : 0) != 0);
        Assert.assertTrue((cache.heapSize() < maxSize ? 1 : 0) != 0);
        Assert.assertTrue(((float)cache.heapSize() < (float)maxSize * 0.99f ? 1 : 0) != 0);
        Assert.assertTrue((cache.getBlock(blocks[0].cacheKey, true, false, true) == null ? 1 : 0) != 0);
        for (int i = 1; i < blocks.length; ++i) {
            Assert.assertEquals((Object)cache.getBlock(blocks[i].cacheKey, true, false, true), (Object)blocks[i]);
        }
    }

    @Test
    public void testCacheEvictionTwoPriorities() throws Exception {
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSizeDefault(maxSize, 10);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize, false);
        CachedItem[] singleBlocks = this.generateFixedBlocks(5, 10000, "single");
        CachedItem[] multiBlocks = this.generateFixedBlocks(5, 10000, "multi");
        long expectedCacheSize = cache.heapSize();
        for (CachedItem block : multiBlocks) {
            cache.cacheBlock(block.cacheKey, (Cacheable)block);
            expectedCacheSize += block.cacheBlockHeapSize();
            Assert.assertEquals((Object)cache.getBlock(block.cacheKey, true, false, true), (Object)block);
        }
        for (CachedItem block : singleBlocks) {
            cache.cacheBlock(block.cacheKey, (Cacheable)block);
            expectedCacheSize += block.heapSize();
        }
        Assert.assertEquals((long)cache.getStats().getEvictionCount(), (long)1L);
        Assert.assertEquals((long)cache.getStats().getEvictedCount(), (long)2L);
        Assert.assertTrue(((float)expectedCacheSize > (float)maxSize * 0.99f ? 1 : 0) != 0);
        Assert.assertTrue((cache.heapSize() <= maxSize ? 1 : 0) != 0);
        Assert.assertTrue(((float)cache.heapSize() <= (float)maxSize * 0.99f ? 1 : 0) != 0);
        Assert.assertTrue((cache.getBlock(singleBlocks[0].cacheKey, true, false, true) == null ? 1 : 0) != 0);
        Assert.assertTrue((cache.getBlock(multiBlocks[0].cacheKey, true, false, true) == null ? 1 : 0) != 0);
        for (int i = 1; i < 4; ++i) {
            Assert.assertEquals((Object)cache.getBlock(singleBlocks[i].cacheKey, true, false, true), (Object)singleBlocks[i]);
            Assert.assertEquals((Object)cache.getBlock(multiBlocks[i].cacheKey, true, false, true), (Object)multiBlocks[i]);
        }
    }

    @Test
    public void testCacheEvictionThreePriorities() throws Exception {
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSize(maxSize, 10);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize, false, (int)Math.ceil(1.2 * (double)maxSize / (double)blockSize), 0.75f, 16, 0.98f, 0.99f, 0.33f, 0.33f, 0.34f, false, 0x1000000L);
        CachedItem[] singleBlocks = this.generateFixedBlocks(5, blockSize, "single");
        CachedItem[] multiBlocks = this.generateFixedBlocks(5, blockSize, "multi");
        CachedItem[] memoryBlocks = this.generateFixedBlocks(5, blockSize, "memory");
        long expectedCacheSize = cache.heapSize();
        for (int i = 0; i < 3; ++i) {
            cache.cacheBlock(singleBlocks[i].cacheKey, (Cacheable)singleBlocks[i]);
            expectedCacheSize += singleBlocks[i].cacheBlockHeapSize();
            cache.cacheBlock(multiBlocks[i].cacheKey, (Cacheable)multiBlocks[i]);
            expectedCacheSize += multiBlocks[i].cacheBlockHeapSize();
            cache.getBlock(multiBlocks[i].cacheKey, true, false, true);
            cache.cacheBlock(memoryBlocks[i].cacheKey, (Cacheable)memoryBlocks[i], true, false);
            expectedCacheSize += memoryBlocks[i].cacheBlockHeapSize();
        }
        Assert.assertEquals((long)0L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)expectedCacheSize, (long)cache.heapSize());
        cache.cacheBlock(singleBlocks[3].cacheKey, (Cacheable)singleBlocks[3]);
        Assert.assertEquals((long)1L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)1L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[0].cacheKey, true, false, true));
        cache.getBlock(singleBlocks[1].cacheKey, true, false, true);
        cache.cacheBlock(singleBlocks[4].cacheKey, (Cacheable)singleBlocks[4]);
        Assert.assertEquals((long)2L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)2L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(multiBlocks[0].cacheKey, true, false, true));
        cache.cacheBlock(memoryBlocks[3].cacheKey, (Cacheable)memoryBlocks[3], true, false);
        Assert.assertEquals((long)3L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)3L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(memoryBlocks[0].cacheKey, true, false, true));
        CachedItem[] bigBlocks = this.generateFixedBlocks(3, blockSize * 3L, "big");
        cache.cacheBlock(bigBlocks[0].cacheKey, (Cacheable)bigBlocks[0]);
        Assert.assertEquals((long)4L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)6L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[2].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[3].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[4].cacheKey, true, false, true));
        cache.getBlock(bigBlocks[0].cacheKey, true, false, true);
        cache.cacheBlock(bigBlocks[1].cacheKey, (Cacheable)bigBlocks[1]);
        Assert.assertEquals((long)5L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)9L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[1].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(multiBlocks[1].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(multiBlocks[2].cacheKey, true, false, true));
        cache.cacheBlock(bigBlocks[2].cacheKey, (Cacheable)bigBlocks[2], true, false);
        Assert.assertEquals((long)6L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)12L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(memoryBlocks[1].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(memoryBlocks[2].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(memoryBlocks[3].cacheKey, true, false, true));
    }

    @Test
    public void testCacheEvictionInMemoryForceMode() throws Exception {
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSize(maxSize, 10);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize, false, (int)Math.ceil(1.2 * (double)maxSize / (double)blockSize), 0.75f, 16, 0.98f, 0.99f, 0.2f, 0.3f, 0.5f, true, 0x1000000L);
        CachedItem[] singleBlocks = this.generateFixedBlocks(10, blockSize, "single");
        CachedItem[] multiBlocks = this.generateFixedBlocks(10, blockSize, "multi");
        CachedItem[] memoryBlocks = this.generateFixedBlocks(10, blockSize, "memory");
        long expectedCacheSize = cache.heapSize();
        for (int i = 0; i < 4; ++i) {
            cache.cacheBlock(singleBlocks[i].cacheKey, (Cacheable)singleBlocks[i]);
            expectedCacheSize += singleBlocks[i].cacheBlockHeapSize();
            cache.cacheBlock(multiBlocks[i].cacheKey, (Cacheable)multiBlocks[i]);
            expectedCacheSize += multiBlocks[i].cacheBlockHeapSize();
            cache.getBlock(multiBlocks[i].cacheKey, true, false, true);
        }
        cache.cacheBlock(singleBlocks[4].cacheKey, (Cacheable)singleBlocks[4]);
        Assert.assertEquals((long)0L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)(expectedCacheSize += singleBlocks[4].cacheBlockHeapSize()), (long)cache.heapSize());
        cache.cacheBlock(memoryBlocks[0].cacheKey, (Cacheable)memoryBlocks[0], true, false);
        Assert.assertEquals((long)1L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)1L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[0].cacheKey, true, false, true));
        cache.cacheBlock(memoryBlocks[1].cacheKey, (Cacheable)memoryBlocks[1], true, false);
        Assert.assertEquals((long)2L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)2L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[1].cacheKey, true, false, true));
        cache.cacheBlock(memoryBlocks[2].cacheKey, (Cacheable)memoryBlocks[2], true, false);
        cache.cacheBlock(memoryBlocks[3].cacheKey, (Cacheable)memoryBlocks[3], true, false);
        cache.cacheBlock(memoryBlocks[4].cacheKey, (Cacheable)memoryBlocks[4], true, false);
        cache.cacheBlock(memoryBlocks[5].cacheKey, (Cacheable)memoryBlocks[5], true, false);
        Assert.assertEquals((long)6L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)6L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[2].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[3].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(multiBlocks[0].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(multiBlocks[1].cacheKey, true, false, true));
        cache.cacheBlock(memoryBlocks[6].cacheKey, (Cacheable)memoryBlocks[6], true, false);
        cache.cacheBlock(memoryBlocks[7].cacheKey, (Cacheable)memoryBlocks[7], true, false);
        cache.cacheBlock(memoryBlocks[8].cacheKey, (Cacheable)memoryBlocks[8], true, false);
        Assert.assertEquals((long)9L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)9L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[4].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(multiBlocks[2].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(multiBlocks[3].cacheKey, true, false, true));
        cache.cacheBlock(memoryBlocks[9].cacheKey, (Cacheable)memoryBlocks[9], true, false);
        Assert.assertEquals((long)10L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)10L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(memoryBlocks[0].cacheKey, true, false, true));
        cache.cacheBlock(singleBlocks[9].cacheKey, (Cacheable)singleBlocks[9]);
        Assert.assertEquals((long)11L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)11L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[9].cacheKey, true, false, true));
    }

    @Test
    public void testScanResistance() throws Exception {
        int i;
        CachedItem[] multiBlocks;
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSize(maxSize, 10);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize, false, (int)Math.ceil(1.2 * (double)maxSize / (double)blockSize), 0.75f, 16, 0.66f, 0.99f, 0.33f, 0.33f, 0.34f, false, 0x1000000L);
        CachedItem[] singleBlocks = this.generateFixedBlocks(20, blockSize, "single");
        for (CachedItem block : multiBlocks = this.generateFixedBlocks(5, blockSize, "multi")) {
            cache.cacheBlock(block.cacheKey, (Cacheable)block);
            cache.getBlock(block.cacheKey, true, false, true);
        }
        for (i = 0; i < 5; ++i) {
            cache.cacheBlock(singleBlocks[i].cacheKey, (Cacheable)singleBlocks[i]);
        }
        Assert.assertEquals((long)1L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)4L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[0].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[1].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(multiBlocks[0].cacheKey, true, false, true));
        Assert.assertEquals(null, (Object)cache.getBlock(multiBlocks[1].cacheKey, true, false, true));
        for (i = 5; i < 18; ++i) {
            cache.cacheBlock(singleBlocks[i].cacheKey, (Cacheable)singleBlocks[i]);
        }
        Assert.assertEquals((long)4L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)16L, (long)cache.getStats().getEvictedCount());
        Assert.assertEquals((long)7L, (long)cache.getBlockCount());
    }

    @Test
    public void testMaxBlockSize() throws Exception {
        long maxSize = 100000L;
        long blockSize = this.calculateBlockSize(maxSize, 10);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize, false, (int)Math.ceil(1.2 * (double)maxSize / (double)blockSize), 0.75f, 16, 0.66f, 0.99f, 0.33f, 0.33f, 0.34f, false, 1024L);
        CachedItem[] tooLong = this.generateFixedBlocks(10, 1029, "long");
        CachedItem[] small = this.generateFixedBlocks(15, 600, "small");
        for (CachedItem i : tooLong) {
            cache.cacheBlock(i.cacheKey, (Cacheable)i);
        }
        for (CachedItem i : small) {
            cache.cacheBlock(i.cacheKey, (Cacheable)i);
        }
        Assert.assertEquals((long)15L, (long)cache.getBlockCount());
        for (CachedItem i : small) {
            Assert.assertNotNull((Object)cache.getBlock(i.cacheKey, true, false, false));
        }
        for (CachedItem i : tooLong) {
            Assert.assertNull((Object)cache.getBlock(i.cacheKey, true, false, false));
        }
        Assert.assertEquals((long)10L, (long)cache.getStats().getFailedInserts());
    }

    @Test
    public void testResizeBlockCache() throws Exception {
        int i;
        long maxSize = 300000L;
        long blockSize = this.calculateBlockSize(maxSize, 31);
        LruBlockCache cache = new LruBlockCache(maxSize, blockSize, false, (int)Math.ceil(1.2 * (double)maxSize / (double)blockSize), 0.75f, 16, 0.98f, 0.99f, 0.33f, 0.33f, 0.34f, false, 0x1000000L);
        CachedItem[] singleBlocks = this.generateFixedBlocks(10, blockSize, "single");
        CachedItem[] multiBlocks = this.generateFixedBlocks(10, blockSize, "multi");
        CachedItem[] memoryBlocks = this.generateFixedBlocks(10, blockSize, "memory");
        for (i = 0; i < 10; ++i) {
            cache.cacheBlock(singleBlocks[i].cacheKey, (Cacheable)singleBlocks[i]);
            cache.cacheBlock(multiBlocks[i].cacheKey, (Cacheable)multiBlocks[i]);
            cache.getBlock(multiBlocks[i].cacheKey, true, false, true);
            cache.cacheBlock(memoryBlocks[i].cacheKey, (Cacheable)memoryBlocks[i], true, false);
        }
        Assert.assertEquals((long)0L, (long)cache.getStats().getEvictionCount());
        cache.setMaxSize((long)((float)maxSize * 0.5f));
        Assert.assertEquals((long)1L, (long)cache.getStats().getEvictionCount());
        Assert.assertEquals((long)15L, (long)cache.getStats().getEvictedCount());
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals(null, (Object)cache.getBlock(singleBlocks[i].cacheKey, true, false, true));
            Assert.assertEquals(null, (Object)cache.getBlock(multiBlocks[i].cacheKey, true, false, true));
            Assert.assertEquals(null, (Object)cache.getBlock(memoryBlocks[i].cacheKey, true, false, true));
        }
        for (i = 5; i < 10; ++i) {
            Assert.assertEquals((Object)singleBlocks[i], (Object)cache.getBlock(singleBlocks[i].cacheKey, true, false, true));
            Assert.assertEquals((Object)multiBlocks[i], (Object)cache.getBlock(multiBlocks[i].cacheKey, true, false, true));
            Assert.assertEquals((Object)memoryBlocks[i], (Object)cache.getBlock(memoryBlocks[i].cacheKey, true, false, true));
        }
    }

    @Test
    public void testPastNPeriodsMetrics() throws Exception {
        double delta = 0.01;
        CacheStats stats = new CacheStats("test", 3);
        stats.rollMetricsPeriod();
        Assert.assertEquals((double)0.0, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.0, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
        stats.hit(false);
        stats.hit(true);
        stats.miss(false, false);
        stats.miss(false, false);
        stats.rollMetricsPeriod();
        Assert.assertEquals((double)0.5, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)1.0, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
        stats.miss(true, false);
        stats.miss(false, false);
        stats.miss(false, false);
        stats.miss(false, false);
        stats.rollMetricsPeriod();
        Assert.assertEquals((double)0.25, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.5, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
        stats.hit(false);
        stats.hit(true);
        stats.hit(false);
        stats.hit(true);
        stats.rollMetricsPeriod();
        Assert.assertEquals((double)0.5, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.75, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
        stats.miss(true, false);
        stats.miss(true, false);
        stats.rollMetricsPeriod();
        Assert.assertEquals((double)0.4, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.4, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
        stats.miss(true, false);
        stats.miss(true, false);
        stats.hit(false);
        stats.hit(false);
        stats.rollMetricsPeriod();
        Assert.assertEquals((double)0.6, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.3333333333333333, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
        stats.rollMetricsPeriod();
        Assert.assertEquals((double)0.3333333333333333, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.0, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
        stats.rollMetricsPeriod();
        Assert.assertEquals((double)0.5, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.0, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
        stats.rollMetricsPeriod();
        Assert.assertEquals((double)0.0, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.0, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
        stats.miss(true, false);
        stats.miss(false, false);
        stats.hit(true);
        stats.hit(false);
        stats.rollMetricsPeriod();
        Assert.assertEquals((double)0.5, (double)stats.getHitRatioPastNPeriods(), (double)delta);
        Assert.assertEquals((double)0.5, (double)stats.getHitCachingRatioPastNPeriods(), (double)delta);
    }

    private CachedItem[] generateFixedBlocks(int numBlocks, int size, String pfx) {
        CachedItem[] blocks = new CachedItem[numBlocks];
        for (int i = 0; i < numBlocks; ++i) {
            blocks[i] = new CachedItem(pfx + i, size);
        }
        return blocks;
    }

    private CachedItem[] generateFixedBlocks(int numBlocks, long size, String pfx) {
        return this.generateFixedBlocks(numBlocks, (int)size, pfx);
    }

    private CachedItem[] generateRandomBlocks(int numBlocks, long maxSize) {
        CachedItem[] blocks = new CachedItem[numBlocks];
        Random r = new Random();
        for (int i = 0; i < numBlocks; ++i) {
            blocks[i] = new CachedItem("block" + i, r.nextInt((int)maxSize) + 1);
        }
        return blocks;
    }

    private long calculateBlockSize(long maxSize, int numBlocks) {
        long roughBlockSize = maxSize / (long)numBlocks;
        int numEntries = (int)Math.ceil(1.2 * (double)maxSize / (double)roughBlockSize);
        long totalOverhead = LruBlockCache.CACHE_FIXED_OVERHEAD + (long)ClassSize.CONCURRENT_HASHMAP + (long)(numEntries * ClassSize.CONCURRENT_HASHMAP_ENTRY) + (long)(16 * ClassSize.CONCURRENT_HASHMAP_SEGMENT);
        long negateBlockSize = totalOverhead / (long)numEntries;
        return ClassSize.align((long)((long)Math.floor((float)(roughBlockSize - (negateBlockSize += LruCachedBlock.PER_BLOCK_OVERHEAD)) * 0.99f)));
    }

    private long calculateBlockSizeDefault(long maxSize, int numBlocks) {
        long roughBlockSize = maxSize / (long)numBlocks;
        int numEntries = (int)Math.ceil(1.2 * (double)maxSize / (double)roughBlockSize);
        long totalOverhead = LruBlockCache.CACHE_FIXED_OVERHEAD + (long)ClassSize.CONCURRENT_HASHMAP + (long)(numEntries * ClassSize.CONCURRENT_HASHMAP_ENTRY) + (long)(16 * ClassSize.CONCURRENT_HASHMAP_SEGMENT);
        long negateBlockSize = totalOverhead / (long)numEntries;
        return ClassSize.align((long)((long)Math.floor((float)(roughBlockSize - (negateBlockSize += LruCachedBlock.PER_BLOCK_OVERHEAD)) * 0.99f)));
    }

    private static class CachedItem
    implements Cacheable {
        BlockCacheKey cacheKey;
        int size;

        CachedItem(String blockName, int size) {
            this.cacheKey = new BlockCacheKey(blockName, 0L);
            this.size = size;
        }

        public long heapSize() {
            return ClassSize.align((int)this.size);
        }

        public long cacheBlockHeapSize() {
            return LruCachedBlock.PER_BLOCK_OVERHEAD + ClassSize.align((long)this.cacheKey.heapSize()) + (long)ClassSize.align((int)this.size);
        }

        public int getSerializedLength() {
            return 0;
        }

        public CacheableDeserializer<Cacheable> getDeserializer() {
            return null;
        }

        public void serialize(ByteBuffer destination) {
        }

        public BlockType getBlockType() {
            return BlockType.DATA;
        }
    }
}

