/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.HBaseFsckRepair;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.zookeeper.LoadBalancerTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={LargeTests.class})
public class TestMetaWithReplicas {
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static final Log LOG = LogFactory.getLog(TestMetaWithReplicas.class);
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @Before
    public void setup() throws Exception {
        this.TEST_UTIL.getConfiguration().setInt("zookeeper.session.timeout", 30000);
        this.TEST_UTIL.getConfiguration().setInt("hbase.meta.replica.count", 3);
        this.TEST_UTIL.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 1000);
        this.TEST_UTIL.startMiniCluster(3);
        LoadBalancerTracker l = new LoadBalancerTracker(this.TEST_UTIL.getZooKeeperWatcher(), new Abortable(){
            boolean aborted = false;

            public boolean isAborted() {
                return this.aborted;
            }

            public void abort(String why, Throwable e) {
                this.aborted = true;
            }
        });
        l.setBalancerOn(false);
        for (int replicaId = 1; replicaId < 3; ++replicaId) {
            HRegionInfo h = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (int)replicaId);
            this.TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(h);
        }
        LOG.debug((Object)"All meta replicas assigned");
    }

    @After
    public void tearDown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMetaHTDReplicaCount() throws Exception {
        Assert.assertTrue((this.TEST_UTIL.getHBaseAdmin().getTableDescriptor(TableName.META_TABLE_NAME).getRegionReplication() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testZookeeperNodesForReplicas() throws Exception {
        ZooKeeperWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();
        Configuration conf = this.TEST_UTIL.getConfiguration();
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZKUtil.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        byte[] data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)primaryMetaZnode);
        ServerName.parseFrom((byte[])data);
        for (int i = 1; i < 3; ++i) {
            String secZnode = ZKUtil.joinZNode((String)baseZNode, (String)(conf.get("zookeeper.znode.metaserver", "meta-region-server") + "-" + i));
            String str = zkw.getZNodeForReplica(i);
            Assert.assertTrue((boolean)str.equals(secZnode));
            data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)secZnode);
            ServerName.parseFrom((byte[])data);
        }
    }

    @Test
    public void testShutdownHandling() throws Exception {
        TestMetaWithReplicas.shutdownMetaAndDoValidations(this.TEST_UTIL);
    }

    public static void shutdownMetaAndDoValidations(HBaseTestingUtility util) throws Exception {
        ZooKeeperWatcher zkw = util.getZooKeeperWatcher();
        Configuration conf = util.getConfiguration();
        conf.setBoolean("hbase.meta.replicas.use", true);
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZKUtil.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        byte[] data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)primaryMetaZnode);
        ServerName primary = ServerName.parseFrom((byte[])data);
        byte[] TABLE = Bytes.toBytes((String)"testShutdownHandling");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"foo")};
        if (util.getHBaseAdmin().tableExists(TABLE)) {
            util.getHBaseAdmin().disableTable(TABLE);
            util.getHBaseAdmin().deleteTable(TABLE);
        }
        ServerName master = null;
        try (Connection c = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
            try (HTable htable = util.createTable(TABLE, (byte[][])FAMILIES, conf);){
                util.getHBaseAdmin().flush(TableName.META_TABLE_NAME);
                Thread.sleep(conf.getInt("hbase.regionserver.storefile.refresh.period", 30000) * 6);
                List regions = MetaTableAccessor.getTableRegions((ZooKeeperWatcher)zkw, (Connection)c, (TableName)TableName.valueOf((byte[])TABLE));
                HRegionLocation hrl = MetaTableAccessor.getRegionLocation((Connection)c, (HRegionInfo)((HRegionInfo)regions.get(0)));
                if (hrl.getServerName().equals((Object)primary)) {
                    util.getHBaseAdmin().move(hrl.getRegionInfo().getEncodedNameAsBytes(), null);
                    do {
                        Thread.sleep(10L);
                    } while (primary.equals((Object)(hrl = MetaTableAccessor.getRegionLocation((Connection)c, (HRegionInfo)((HRegionInfo)regions.get(0)))).getServerName()));
                    util.getHBaseAdmin().flush(TableName.META_TABLE_NAME);
                    Thread.sleep(conf.getInt("hbase.regionserver.storefile.refresh.period", 30000) * 3);
                }
                master = util.getHBaseClusterInterface().getClusterStatus().getMaster();
                util.getHBaseClusterInterface().stopMaster(master);
                util.getHBaseClusterInterface().waitForMasterToStop(master, 60000L);
                if (!master.equals((Object)primary)) {
                    util.getHBaseClusterInterface().killRegionServer(primary);
                    util.getHBaseClusterInterface().waitForRegionServerToStop(primary, 60000L);
                }
                ((ClusterConnection)c).clearRegionCache();
            }
            Get get = null;
            Result r = null;
            byte[] row = "test".getBytes();
            try (Table htable = c.getTable(TableName.valueOf((byte[])TABLE));){
                Put put = new Put(row);
                put.add("foo".getBytes(), row, row);
                BufferedMutator m = c.getBufferedMutator(TableName.valueOf((byte[])TABLE));
                m.mutate((Mutation)put);
                m.flush();
                get = new Get(row);
                r = htable.get(get);
                Assert.assertTrue((boolean)Arrays.equals(r.getRow(), row));
                util.getHBaseClusterInterface().startMaster(master.getHostname(), 0);
                util.getHBaseClusterInterface().startRegionServer(primary.getHostname(), 0);
                util.getHBaseClusterInterface().waitForActiveAndReadyMaster();
                ((ClusterConnection)c).clearRegionCache();
            }
            conf.setBoolean("hbase.meta.replicas.use", false);
            htable = c.getTable(TableName.valueOf((byte[])TABLE));
            var16_21 = null;
            try {
                r = htable.get(get);
                Assert.assertTrue((boolean)Arrays.equals(r.getRow(), row));
            }
            catch (Throwable throwable) {
                var16_21 = throwable;
                throw throwable;
            }
            finally {
                if (htable != null) {
                    if (var16_21 != null) {
                        try {
                            htable.close();
                        }
                        catch (Throwable x2) {
                            var16_21.addSuppressed(x2);
                        }
                    } else {
                        htable.close();
                    }
                }
            }
        }
    }

    @Test
    public void testMetaLookupThreadPoolCreated() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testMetaLookupThreadPoolCreated");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"foo")};
        if (this.TEST_UTIL.getHBaseAdmin().tableExists(TABLE)) {
            this.TEST_UTIL.getHBaseAdmin().disableTable(TABLE);
            this.TEST_UTIL.getHBaseAdmin().deleteTable(TABLE);
        }
        try (HTable htable = this.TEST_UTIL.createTable(TABLE, (byte[][])FAMILIES, this.TEST_UTIL.getConfiguration());){
            byte[] row = "test".getBytes();
            ConnectionManager.HConnectionImplementation c = (ConnectionManager.HConnectionImplementation)htable.connection;
            c.relocateRegion(TABLE, row);
            ExecutorService ex = c.getCurrentMetaLookupPool();
            assert (ex != null);
        }
    }

    @Test
    public void testChangingReplicaCount() throws Exception {
        this.stopMasterAndValidateReplicaCount(3, 2);
        this.stopMasterAndValidateReplicaCount(2, 3);
    }

    private void stopMasterAndValidateReplicaCount(int originalReplicaCount, int newReplicaCount) throws Exception {
        ServerName sn = this.TEST_UTIL.getHBaseClusterInterface().getClusterStatus().getMaster();
        this.TEST_UTIL.getHBaseClusterInterface().stopMaster(sn);
        this.TEST_UTIL.getHBaseClusterInterface().waitForMasterToStop(sn, 60000L);
        List metaZnodes = this.TEST_UTIL.getZooKeeperWatcher().getMetaReplicaNodes();
        assert (metaZnodes.size() == originalReplicaCount);
        this.TEST_UTIL.getHBaseClusterInterface().getConf().setInt("hbase.meta.replica.count", newReplicaCount);
        this.TEST_UTIL.getHBaseClusterInterface().startMaster(sn.getHostname(), 0);
        this.TEST_UTIL.getHBaseClusterInterface().waitForActiveAndReadyMaster();
        int count = 0;
        do {
            metaZnodes = this.TEST_UTIL.getZooKeeperWatcher().getMetaReplicaNodes();
            Thread.sleep(10L);
        } while (metaZnodes.size() == originalReplicaCount && ++count < 1000);
        assert (metaZnodes.size() == newReplicaCount);
        this.TEST_UTIL.getConfiguration().setInt("hbase.meta.replica.count", newReplicaCount);
        HBaseFsck hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertNoErrors(hbck);
    }

    @Test
    public void testHBaseFsckWithMetaReplicas() throws Exception {
        HBaseFsck hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertNoErrors(hbck);
    }

    @Test
    public void testHBaseFsckWithFewerMetaReplicas() throws Exception {
        ClusterConnection c = (ClusterConnection)ConnectionFactory.createConnection((Configuration)this.TEST_UTIL.getConfiguration());
        RegionLocations rl = c.locateRegion(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW, false, false);
        HBaseFsckRepair.closeRegionSilentlyAndWait((HConnection)c, (ServerName)rl.getRegionLocation(1).getServerName(), (HRegionInfo)rl.getRegionLocation(1).getRegionInfo());
        HBaseFsck hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.UNKNOWN, HBaseFsck.ErrorReporter.ERROR_CODE.NO_META_REGION});
        hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), true);
        hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
    }

    @Test
    public void testHBaseFsckWithFewerMetaReplicaZnodes() throws Exception {
        ClusterConnection c = (ClusterConnection)ConnectionFactory.createConnection((Configuration)this.TEST_UTIL.getConfiguration());
        RegionLocations rl = c.locateRegion(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW, false, false);
        HBaseFsckRepair.closeRegionSilentlyAndWait((HConnection)c, (ServerName)rl.getRegionLocation(2).getServerName(), (HRegionInfo)rl.getRegionLocation(2).getRegionInfo());
        ZooKeeperWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();
        ZKUtil.deleteNode((ZooKeeperWatcher)zkw, (String)zkw.getZNodeForReplica(2));
        HBaseFsck hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.UNKNOWN, HBaseFsck.ErrorReporter.ERROR_CODE.NO_META_REGION});
        hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), true);
        hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
    }

    @Test
    public void testAccessingUnknownTables() throws Exception {
        Configuration conf = new Configuration(this.TEST_UTIL.getConfiguration());
        conf.setBoolean("hbase.meta.replicas.use", true);
        Table table = this.TEST_UTIL.getConnection().getTable(TableName.valueOf((String)"RandomTable"));
        Get get = new Get(Bytes.toBytes((String)"foo"));
        try {
            table.get(get);
        }
        catch (TableNotFoundException t) {
            return;
        }
        Assert.fail((String)"Expected TableNotFoundException");
    }

    @Test
    public void testMetaAddressChange() throws Exception {
        Configuration conf = this.TEST_UTIL.getConfiguration();
        ZooKeeperWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZKUtil.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        byte[] data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)primaryMetaZnode);
        ServerName currentServer = ServerName.parseFrom((byte[])data);
        Collection liveServers = this.TEST_UTIL.getHBaseAdmin().getClusterStatus().getServers();
        ServerName moveToServer = null;
        for (ServerName s : liveServers) {
            if (currentServer.equals((Object)s)) continue;
            moveToServer = s;
        }
        assert (moveToServer != null);
        String tableName = "randomTable5678";
        this.TEST_UTIL.createTable(TableName.valueOf((String)tableName), "f");
        Assert.assertTrue((boolean)this.TEST_UTIL.getHBaseAdmin().tableExists(tableName));
        this.TEST_UTIL.getHBaseAdmin().move(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), Bytes.toBytes((String)moveToServer.getServerName()));
        int i = 0;
        do {
            Thread.sleep(10L);
        } while (!moveToServer.equals((Object)(currentServer = ServerName.parseFrom((byte[])(data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)primaryMetaZnode))))) && ++i < 1000);
        assert (i != 1000);
        this.TEST_UTIL.getHBaseAdmin().disableTable("randomTable5678");
        Assert.assertTrue((boolean)this.TEST_UTIL.getHBaseAdmin().isTableDisabled("randomTable5678"));
    }

    @Test
    public void testShutdownOfReplicaHolder() throws Exception {
        RegionLocations rl = ConnectionManager.getConnectionInternal((Configuration)this.TEST_UTIL.getConfiguration()).locateRegion(TableName.META_TABLE_NAME, Bytes.toBytes((String)""), false, true);
        HRegionLocation hrl = rl.getRegionLocation(1);
        ServerName oldServer = hrl.getServerName();
        this.TEST_UTIL.getHBaseClusterInterface().killRegionServer(oldServer);
        int i = 0;
        do {
            LOG.debug((Object)("Waiting for the replica " + hrl.getRegionInfo() + " to come up"));
            Thread.sleep(30000L);
        } while (((hrl = (rl = ConnectionManager.getConnectionInternal((Configuration)this.TEST_UTIL.getConfiguration()).locateRegion(TableName.META_TABLE_NAME, Bytes.toBytes((String)""), false, true)).getRegionLocation(1)) == null || hrl.getServerName().equals((Object)oldServer)) && ++i < 3);
        Assert.assertTrue((i != 3 ? 1 : 0) != 0);
    }

    @Test
    public void testHBaseFsckWithExcessMetaReplicas() throws Exception {
        HRegionInfo h = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (int)3);
        this.TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().createRegionState(h);
        this.TEST_UTIL.getMiniHBaseCluster().getMaster().assignRegion(h);
        HBaseFsckRepair.waitUntilAssigned((Admin)this.TEST_UTIL.getHBaseAdmin(), (HRegionInfo)h);
        HBaseFsck hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.UNKNOWN, HBaseFsck.ErrorReporter.ERROR_CODE.SHOULD_NOT_BE_DEPLOYED});
        hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), true);
        hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
    }
}

