/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerCoprocessorExceptionWithRemove {
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.coprocessor.region.classes", BuggyRegionObserver.class.getName());
        TEST_UTIL.getConfiguration().setBoolean("hbase.coprocessor.abortonerror", false);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testExceptionFromCoprocessorDuringPut() throws IOException, InterruptedException {
        TableName TEST_TABLE = TableName.valueOf((String)"observed_table");
        byte[] TEST_FAMILY = Bytes.toBytes((String)"aaa");
        HTable table = TEST_UTIL.createMultiRegionTable(TEST_TABLE, TEST_FAMILY);
        TEST_UTIL.waitUntilAllRegionsAssigned(TEST_TABLE);
        HRegionServer regionServer = TEST_UTIL.getRSForFirstRegionInTable(TEST_TABLE);
        boolean threwIOE = false;
        try {
            byte[] ROW = Bytes.toBytes((String)"aaa");
            Put put = new Put(ROW);
            put.add(TEST_FAMILY, ROW, ROW);
            table.put(put);
            table.flushCommits();
            table.put(put);
            table.flushCommits();
        }
        catch (IOException e) {
            threwIOE = true;
        }
        finally {
            Assert.assertTrue((String)"The regionserver should have thrown an exception", (boolean)threwIOE);
        }
        for (int i = 0; i < 10; ++i) {
            Assert.assertFalse((boolean)regionServer.isAborted());
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Assert.fail((String)"InterruptedException while waiting for regionserver zk node to be deleted.");
            }
        }
        table.close();
    }

    public static class BuggyRegionObserver
    extends SimpleRegionObserver {
        @Override
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) {
            String tableName = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString();
            if (tableName.equals("observed_table")) {
                Integer i = null;
                i = i + 1;
            }
        }
    }
}

