/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.ChecksumUtil;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.TestHFileBlock;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestChecksum {
    private static final Log LOG = LogFactory.getLog(TestHFileBlock.class);
    static final Compression.Algorithm[] COMPRESSION_ALGORITHMS = new Compression.Algorithm[]{Compression.Algorithm.NONE, Compression.Algorithm.GZ};
    static final int[] BYTES_PER_CHECKSUM = new int[]{50, 500, 688, 16384, 17364, 65536};
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private FileSystem fs;
    private HFileSystem hfs;

    @Before
    public void setUp() throws Exception {
        this.fs = HFileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        this.hfs = (HFileSystem)this.fs;
    }

    @Test
    public void testNewBlocksHaveDefaultChecksum() throws IOException {
        Path path = new Path(TEST_UTIL.getDataTestDir(), "default_checksum");
        FSDataOutputStream os = this.fs.create(path);
        HFileContext meta = new HFileContextBuilder().build();
        HFileBlock.Writer hbw = new HFileBlock.Writer(null, meta);
        DataOutputStream dos = hbw.startWriting(BlockType.DATA);
        for (int i = 0; i < 1000; ++i) {
            dos.writeInt(i);
        }
        hbw.writeHeaderAndData(os);
        int totalSize = hbw.getOnDiskSizeWithHeader();
        os.close();
        Assert.assertEquals((Object)true, (Object)this.hfs.useHBaseChecksum());
        FSDataInputStreamWrapper is = new FSDataInputStreamWrapper(this.fs, path);
        meta = new HFileContextBuilder().withHBaseCheckSum(true).build();
        HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(is, (long)totalSize, (HFileSystem)this.fs, path, meta);
        HFileBlock b = hbr.readBlockData(0L, -1L, -1, false);
        Assert.assertEquals((long)b.getChecksumType(), (long)ChecksumType.getDefaultChecksumType().getCode());
    }

    @Test
    public void testAllChecksumTypes() throws IOException {
        ArrayList<ChecksumType> cktypes = new ArrayList<ChecksumType>(Arrays.asList(ChecksumType.values()));
        for (ChecksumType cktype : cktypes) {
            Path path = new Path(TEST_UTIL.getDataTestDir(), "checksum" + cktype.getName());
            FSDataOutputStream os = this.fs.create(path);
            HFileContext meta = new HFileContextBuilder().withChecksumType(cktype).build();
            HFileBlock.Writer hbw = new HFileBlock.Writer(null, meta);
            DataOutputStream dos = hbw.startWriting(BlockType.DATA);
            for (int i = 0; i < 1000; ++i) {
                dos.writeInt(i);
            }
            hbw.writeHeaderAndData(os);
            int totalSize = hbw.getOnDiskSizeWithHeader();
            os.close();
            Assert.assertEquals((Object)true, (Object)this.hfs.useHBaseChecksum());
            FSDataInputStreamWrapper is = new FSDataInputStreamWrapper(this.fs, path);
            meta = new HFileContextBuilder().withHBaseCheckSum(true).build();
            HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(is, (long)totalSize, (HFileSystem)this.fs, path, meta);
            HFileBlock b = hbr.readBlockData(0L, -1L, -1, false);
            ByteBuffer data = b.getBufferWithoutHeader();
            for (int i = 0; i < 1000; ++i) {
                Assert.assertEquals((long)i, (long)data.getInt());
            }
            boolean exception_thrown = false;
            try {
                data.getInt();
            }
            catch (BufferUnderflowException e) {
                exception_thrown = true;
            }
            Assert.assertTrue((boolean)exception_thrown);
            Assert.assertEquals((long)0L, (long)HFile.getChecksumFailuresCount());
        }
    }

    @Test
    public void testChecksumCorruption() throws IOException {
        this.testChecksumCorruptionInternals(false);
        this.testChecksumCorruptionInternals(true);
    }

    protected void testChecksumCorruptionInternals(boolean useTags) throws IOException {
        for (Compression.Algorithm algo : COMPRESSION_ALGORITHMS) {
            for (boolean pread : new boolean[]{false, true}) {
                LOG.info((Object)("testChecksumCorruption: Compression algorithm: " + algo + ", pread=" + pread));
                Path path = new Path(TEST_UTIL.getDataTestDir(), "blocks_v2_" + algo);
                FSDataOutputStream os = this.fs.create(path);
                HFileContext meta = new HFileContextBuilder().withCompression(algo).withIncludesMvcc(true).withIncludesTags(useTags).withBytesPerCheckSum(16384).build();
                HFileBlock.Writer hbw = new HFileBlock.Writer(null, meta);
                long totalSize = 0L;
                for (int blockId = 0; blockId < 2; ++blockId) {
                    DataOutputStream dos = hbw.startWriting(BlockType.DATA);
                    for (int i = 0; i < 1234; ++i) {
                        dos.writeInt(i);
                    }
                    hbw.writeHeaderAndData(os);
                    totalSize += (long)hbw.getOnDiskSizeWithHeader();
                }
                os.close();
                Assert.assertEquals((Object)true, (Object)this.hfs.useHBaseChecksum());
                FSDataInputStreamWrapper is = new FSDataInputStreamWrapper(this.fs, path);
                meta = new HFileContextBuilder().withCompression(algo).withIncludesMvcc(true).withIncludesTags(useTags).withHBaseCheckSum(true).build();
                FSReaderImplTest hbr = new FSReaderImplTest(is, totalSize, this.fs, path, meta);
                HFileBlock b = hbr.readBlockData(0L, -1L, -1, pread);
                b.sanityCheck();
                Assert.assertEquals((long)4936L, (long)b.getUncompressedSizeWithoutHeader());
                Assert.assertEquals((long)(algo == Compression.Algorithm.GZ ? 2173L : 4936L), (long)(b.getOnDiskSizeWithoutHeader() - b.totalChecksumBytes()));
                ByteBuffer bb = b.unpack(meta, (HFileBlock.FSReader)hbr).getBufferWithoutHeader();
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(bb.array(), bb.arrayOffset(), bb.limit()));
                Assert.assertEquals((long)1L, (long)HFile.getChecksumFailuresCount());
                this.validateData(in);
                for (int i = 0; i < 4; ++i) {
                    b = hbr.readBlockData(0L, -1L, -1, pread);
                    Assert.assertEquals((long)0L, (long)HFile.getChecksumFailuresCount());
                }
                b = hbr.readBlockData(0L, -1L, -1, pread);
                Assert.assertEquals((long)1L, (long)HFile.getChecksumFailuresCount());
                b = hbr.readBlockData(0L, -1L, -1, pread);
                Assert.assertEquals((long)0L, (long)HFile.getChecksumFailuresCount());
                is.close();
                HFileSystem newfs = new HFileSystem(TEST_UTIL.getConfiguration(), false);
                Assert.assertEquals((Object)false, (Object)newfs.useHBaseChecksum());
                is = new FSDataInputStreamWrapper((FileSystem)newfs, path);
                hbr = new FSReaderImplTest(is, totalSize, (FileSystem)newfs, path, meta);
                b = hbr.readBlockData(0L, -1L, -1, pread);
                is.close();
                b.sanityCheck();
                b = b.unpack(meta, (HFileBlock.FSReader)hbr);
                Assert.assertEquals((long)4936L, (long)b.getUncompressedSizeWithoutHeader());
                Assert.assertEquals((long)(algo == Compression.Algorithm.GZ ? 2173L : 4936L), (long)(b.getOnDiskSizeWithoutHeader() - b.totalChecksumBytes()));
                bb = b.getBufferWithoutHeader();
                in = new DataInputStream(new ByteArrayInputStream(bb.array(), bb.arrayOffset(), bb.limit()));
                Assert.assertEquals((long)0L, (long)HFile.getChecksumFailuresCount());
                this.validateData(in);
            }
        }
    }

    @Test
    public void testChecksumChunks() throws IOException {
        this.testChecksumInternals(false);
        this.testChecksumInternals(true);
    }

    protected void testChecksumInternals(boolean useTags) throws IOException {
        Compression.Algorithm algo = Compression.Algorithm.NONE;
        for (boolean pread : new boolean[]{false, true}) {
            for (int bytesPerChecksum : BYTES_PER_CHECKSUM) {
                Path path = new Path(TEST_UTIL.getDataTestDir(), "checksumChunk_" + algo + bytesPerChecksum);
                FSDataOutputStream os = this.fs.create(path);
                HFileContext meta = new HFileContextBuilder().withCompression(algo).withIncludesMvcc(true).withIncludesTags(useTags).withHBaseCheckSum(true).withBytesPerCheckSum(bytesPerChecksum).build();
                HFileBlock.Writer hbw = new HFileBlock.Writer(null, meta);
                long dataSize = 0L;
                DataOutputStream dos = hbw.startWriting(BlockType.DATA);
                while (dataSize < (long)(6 * bytesPerChecksum)) {
                    for (int i = 0; i < 1234; ++i) {
                        dos.writeInt(i);
                        dataSize += 4L;
                    }
                }
                hbw.writeHeaderAndData(os);
                long totalSize = hbw.getOnDiskSizeWithHeader();
                os.close();
                long expectedChunks = ChecksumUtil.numChunks((long)(dataSize + 33L), (int)bytesPerChecksum);
                LOG.info((Object)("testChecksumChunks: pread=" + pread + ", bytesPerChecksum=" + bytesPerChecksum + ", fileSize=" + totalSize + ", dataSize=" + dataSize + ", expectedChunks=" + expectedChunks));
                Assert.assertEquals((Object)true, (Object)this.hfs.useHBaseChecksum());
                FSDataInputStream is = this.fs.open(path);
                FSDataInputStream nochecksum = this.hfs.getNoChecksumFs().open(path);
                meta = new HFileContextBuilder().withCompression(algo).withIncludesMvcc(true).withIncludesTags(useTags).withHBaseCheckSum(true).withBytesPerCheckSum(bytesPerChecksum).build();
                HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(new FSDataInputStreamWrapper(is, nochecksum), totalSize, this.hfs, path, meta);
                HFileBlock b = hbr.readBlockData(0L, -1L, -1, pread);
                is.close();
                b.sanityCheck();
                Assert.assertEquals((long)dataSize, (long)b.getUncompressedSizeWithoutHeader());
                Assert.assertEquals((long)totalSize, (long)(33L + dataSize + expectedChunks * 4L));
                Assert.assertEquals((long)0L, (long)HFile.getChecksumFailuresCount());
            }
        }
    }

    private void validateData(DataInputStream in) throws IOException {
        for (int i = 0; i < 1234; ++i) {
            int val = in.readInt();
            Assert.assertEquals((String)("testChecksumCorruption: data mismatch at index " + i), (long)i, (long)val);
        }
    }

    private static class FSReaderImplTest
    extends HFileBlock.FSReaderImpl {
        public FSReaderImplTest(FSDataInputStreamWrapper istream, long fileSize, FileSystem fs, Path path, HFileContext meta) throws IOException {
            super(istream, fileSize, (HFileSystem)fs, path, meta);
        }

        protected boolean validateBlockChecksum(HFileBlock block, long offset, byte[] data, int hdrSize) throws IOException {
            return false;
        }
    }
}

