/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.MultiTableInputFormatTestBase;
import org.apache.hadoop.hbase.mapreduce.MultiTableSnapshotInputFormat;
import org.apache.hadoop.hbase.mapreduce.MultiTableSnapshotInputFormatImpl;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.mapreduce.Job;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMultiTableSnapshotInputFormat
extends MultiTableInputFormatTestBase {
    protected Path restoreDir;

    @BeforeClass
    public static void setUpSnapshots() throws Exception {
        TEST_UTIL.enableDebug(MultiTableSnapshotInputFormat.class);
        TEST_UTIL.enableDebug(MultiTableSnapshotInputFormatImpl.class);
        for (String tableName : TABLES) {
            SnapshotTestingUtils.createSnapshotAndValidate((Admin)TEST_UTIL.getHBaseAdmin(), TableName.valueOf((String)tableName), (List<byte[]>)ImmutableList.of((Object)MultiTableInputFormatTestBase.INPUT_FAMILY), null, TestMultiTableSnapshotInputFormat.snapshotNameForTable(tableName), FSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration()), TEST_UTIL.getTestFileSystem(), true);
        }
    }

    @Before
    public void setUp() throws Exception {
        this.restoreDir = new Path("/tmp");
    }

    @Override
    protected void initJob(List<Scan> scans, Job job) throws IOException {
        TableMapReduceUtil.initMultiTableSnapshotMapperJob(this.getSnapshotScanMapping(scans), MultiTableInputFormatTestBase.ScanMapper.class, ImmutableBytesWritable.class, ImmutableBytesWritable.class, (Job)job, (boolean)true, (Path)this.restoreDir);
    }

    protected Map<String, Collection<Scan>> getSnapshotScanMapping(List<Scan> scans) {
        return Multimaps.index(scans, (Function)new Function<Scan, String>(){

            @Nullable
            public String apply(Scan input) {
                return TestMultiTableSnapshotInputFormat.snapshotNameForTable(Bytes.toStringBinary((byte[])input.getAttribute("scan.attributes.table.name")));
            }
        }).asMap();
    }

    public static String snapshotNameForTable(String tableName) {
        return tableName + "_snapshot";
    }
}

