/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.util.Progressable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionFavoredNodes {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static HTable table;
    private static final TableName TABLE_NAME;
    private static final byte[] COLUMN_FAMILY;
    private static final int FAVORED_NODES_NUM = 3;
    private static final int REGION_SERVERS = 6;
    private static final int FLUSHES = 3;
    private static Method createWithFavoredNode;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        try {
            createWithFavoredNode = DistributedFileSystem.class.getDeclaredMethod("create", Path.class, FsPermission.class, Boolean.TYPE, Integer.TYPE, Short.TYPE, Long.TYPE, Progressable.class, InetSocketAddress[].class);
        }
        catch (NoSuchMethodException nm) {
            return;
        }
        TEST_UTIL.startMiniCluster(6);
        table = TEST_UTIL.createMultiRegionTable(TABLE_NAME, COLUMN_FAMILY);
        TEST_UTIL.waitUntilAllRegionsAssigned(TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (table != null) {
            table.close();
        }
        if (createWithFavoredNode == null) {
            return;
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFavoredNodes() throws Exception {
        List regions;
        HRegionServer server;
        int i;
        Method selfAddress;
        Assume.assumeTrue((createWithFavoredNode != null ? 1 : 0) != 0);
        InetSocketAddress[] nodes = new InetSocketAddress[6];
        ArrayList datanodes = TEST_UTIL.getDFSCluster().getDataNodes();
        try {
            selfAddress = DataNode.class.getMethod("getSelfAddr", new Class[0]);
        }
        catch (NoSuchMethodException ne) {
            selfAddress = DataNode.class.getMethod("getXferAddress", new Class[0]);
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            nodes[i2] = (InetSocketAddress)selfAddress.invoke(datanodes.get(i2), new Object[0]);
        }
        String[] nodeNames = new String[6];
        for (i = 0; i < 6; ++i) {
            nodeNames[i] = nodes[i].getAddress().getHostAddress() + ":" + nodes[i].getPort();
        }
        for (i = 0; i < 6; ++i) {
            server = TEST_UTIL.getHBaseCluster().getRegionServer(i);
            regions = server.getOnlineRegions(TABLE_NAME);
            for (Region region : regions) {
                ArrayList<HBaseProtos.ServerName> favoredNodes = new ArrayList<HBaseProtos.ServerName>(3);
                String encodedRegionName = region.getRegionInfo().getEncodedName();
                for (int j = 0; j < 3; ++j) {
                    HBaseProtos.ServerName.Builder b = HBaseProtos.ServerName.newBuilder();
                    b.setHostName(nodes[(i + j) % 6].getAddress().getHostAddress());
                    b.setPort(nodes[(i + j) % 6].getPort());
                    b.setStartCode(-1L);
                    favoredNodes.add(b.build());
                }
                server.updateRegionFavoredNodesMapping(encodedRegionName, favoredNodes);
            }
        }
        for (i = 0; i < 3; ++i) {
            TEST_UTIL.loadTable((Table)table, COLUMN_FAMILY, false);
            TEST_UTIL.flush();
        }
        for (i = 0; i < 6; ++i) {
            server = TEST_UTIL.getHBaseCluster().getRegionServer(i);
            regions = server.getOnlineRegions(TABLE_NAME);
            for (Region region : regions) {
                List files = region.getStoreFileList((byte[][])new byte[][]{COLUMN_FAMILY});
                for (String file : files) {
                    BlockLocation[] lbks;
                    FileStatus status = TEST_UTIL.getDFSCluster().getFileSystem().getFileStatus(new Path(new URI(file).getPath()));
                    for (BlockLocation lbk : lbks = TEST_UTIL.getDFSCluster().getFileSystem().getFileBlockLocations(status, 0L, Long.MAX_VALUE)) {
                        block12: for (String info : lbk.getNames()) {
                            for (int j = 0; j < 3; ++j) {
                                if (info.equals(nodeNames[(i + j) % 6])) continue block12;
                            }
                            Assert.fail((String)("Block location " + info + " not a favored node"));
                        }
                    }
                }
            }
        }
    }

    static {
        TABLE_NAME = TableName.valueOf((String)"table");
        COLUMN_FAMILY = Bytes.toBytes((String)"family");
        createWithFavoredNode = null;
    }
}

