/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestWideScanner
extends HBaseTestCase {
    private static final Log LOG = LogFactory.getLog(TestWideScanner.class);
    static final byte[] A = Bytes.toBytes((String)"A");
    static final byte[] B = Bytes.toBytes((String)"B");
    static final byte[] C = Bytes.toBytes((String)"C");
    static byte[][] COLUMNS = new byte[][]{A, B, C};
    static final Random rng = new Random();
    static final HTableDescriptor TESTTABLEDESC = new HTableDescriptor(TableName.valueOf((String)"testwidescan"));
    HRegion r;

    private int addWideContent(HRegion region) throws IOException {
        int count = 0;
        for (char c = 'a'; c <= 'c'; c = (char)(c + '\u0001')) {
            byte[] row = Bytes.toBytes((String)("ab" + c));
            long ts = System.currentTimeMillis();
            for (int i = 0; i < 100; ++i) {
                byte[] b = Bytes.toBytes((String)String.format("%10d", i));
                for (int j = 0; j < 100; ++j) {
                    Put put = new Put(row);
                    put.setDurability(Durability.SKIP_WAL);
                    put.add(COLUMNS[rng.nextInt(COLUMNS.length)], b, ++ts, b);
                    region.put(put);
                    ++count;
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWideScanBatching() throws IOException {
        int batch = 256;
        try {
            boolean more;
            this.r = this.createNewHRegion(TESTTABLEDESC, null, null);
            int inserted = this.addWideContent(this.r);
            ArrayList results = new ArrayList();
            Scan scan = new Scan();
            scan.addFamily(A);
            scan.addFamily(B);
            scan.addFamily(C);
            scan.setMaxVersions(100);
            scan.setBatch(256);
            RegionScanner s = this.r.getScanner(scan);
            int total = 0;
            int i = 0;
            do {
                more = s.next(results);
                LOG.info((Object)("iteration #" + ++i + ", results.size=" + results.size()));
                TestWideScanner.assertTrue((results.size() <= 256 ? 1 : 0) != 0);
                total += results.size();
                if (results.size() > 0) {
                    byte[] row = CellUtil.cloneRow((Cell)((Cell)results.get(0)));
                    for (Cell kv : results) {
                        TestWideScanner.assertTrue((boolean)Bytes.equals((byte[])row, (byte[])CellUtil.cloneRow((Cell)kv)));
                    }
                }
                results.clear();
                for (StoreScanner ss : ((HRegion.RegionScannerImpl)s).storeHeap.getHeap()) {
                    ss.updateReaders();
                }
            } while (more);
            LOG.info((Object)("inserted " + inserted + ", scanned " + total));
            TestWideScanner.assertEquals((int)total, (int)inserted);
            s.close();
        }
        finally {
            HRegion.closeHRegion((HRegion)this.r);
        }
    }

    static {
        for (byte[] cfName : new byte[][]{A, B, C}) {
            TESTTABLEDESC.addFamily(new HColumnDescriptor(cfName).setMaxVersions(100).setBlocksize(8192));
        }
    }
}

