/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.FIFOCompactionPolicy;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.TimeOffsetEnvironmentEdge;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFIFOCompactionPolicy {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());
    private final byte[] family = Bytes.toBytes((String)"f");
    private final byte[] qualifier = Bytes.toBytes((String)"q");

    private Store getStoreWithName(TableName tableName) {
        MiniHBaseCluster cluster = TEST_UTIL.getMiniHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> rsts = cluster.getRegionServerThreads();
        for (int i = 0; i < cluster.getRegionServerThreads().size(); ++i) {
            HRegionServer hrs = rsts.get(i).getRegionServer();
            Iterator i$ = hrs.getOnlineRegions(tableName).iterator();
            if (!i$.hasNext()) continue;
            Region region = (Region)i$.next();
            return (Store)region.getStores().iterator().next();
        }
        return null;
    }

    private Store prepareData() throws IOException {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(this.tableName)) {
            admin.disableTable(this.tableName);
            admin.deleteTable(this.tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(this.tableName);
        desc.setConfiguration("hbase.hstore.defaultengine.compactionpolicy.class", FIFOCompactionPolicy.class.getName());
        desc.setConfiguration("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName());
        HColumnDescriptor colDesc = new HColumnDescriptor(this.family);
        colDesc.setTimeToLive(1);
        desc.addFamily(colDesc);
        admin.createTable(desc);
        Table table = TEST_UTIL.getConnection().getTable(this.tableName);
        Random rand = new Random();
        TimeOffsetEnvironmentEdge edge = (TimeOffsetEnvironmentEdge)EnvironmentEdgeManager.getDelegate();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                byte[] value = new byte[131072];
                rand.nextBytes(value);
                table.put(new Put(Bytes.toBytes((int)(i * 10 + j))).addColumn(this.family, this.qualifier, value));
            }
            admin.flush(this.tableName);
            edge.increment(1001L);
        }
        return this.getStoreWithName(this.tableName);
    }

    @BeforeClass
    public static void setEnvironmentEdge() {
        TimeOffsetEnvironmentEdge ee = new TimeOffsetEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)ee);
    }

    @AfterClass
    public static void resetEnvironmentEdge() {
        EnvironmentEdgeManager.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurgeExpiredFiles() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.hstore.blockingStoreFiles", 10000);
        TEST_UTIL.startMiniCluster(1);
        try {
            Store store = this.prepareData();
            Assert.assertEquals((long)10L, (long)store.getStorefilesCount());
            TEST_UTIL.getHBaseAdmin().majorCompact(this.tableName);
            while (store.getStorefilesCount() > 1) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((store.getStorefilesCount() == 1 ? 1 : 0) != 0);
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSanityCheckTTL() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.hstore.blockingStoreFiles", 10000);
        TEST_UTIL.startMiniCluster(1);
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        String tableName = this.tableName.getNameAsString() + "-TTL";
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.setConfiguration("hbase.hstore.defaultengine.compactionpolicy.class", FIFOCompactionPolicy.class.getName());
        desc.setConfiguration("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName());
        HColumnDescriptor colDesc = new HColumnDescriptor(this.family);
        desc.addFamily(colDesc);
        try {
            admin.createTable(desc);
            Assert.fail();
        }
        catch (Exception exception) {
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSanityCheckMinVersion() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.hstore.blockingStoreFiles", 10000);
        TEST_UTIL.startMiniCluster(1);
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        String tableName = this.tableName.getNameAsString() + "-MinVersion";
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.setConfiguration("hbase.hstore.defaultengine.compactionpolicy.class", FIFOCompactionPolicy.class.getName());
        desc.setConfiguration("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName());
        HColumnDescriptor colDesc = new HColumnDescriptor(this.family);
        colDesc.setTimeToLive(1);
        colDesc.setMinVersions(1);
        desc.addFamily(colDesc);
        try {
            admin.createTable(desc);
            Assert.fail();
        }
        catch (Exception exception) {
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSanityCheckBlockingStoreFiles() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.hstore.blockingStoreFiles", 10);
        TEST_UTIL.startMiniCluster(1);
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        String tableName = this.tableName.getNameAsString() + "-MinVersion";
        if (admin.tableExists(tableName)) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.setConfiguration("hbase.hstore.defaultengine.compactionpolicy.class", FIFOCompactionPolicy.class.getName());
        desc.setConfiguration("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName());
        HColumnDescriptor colDesc = new HColumnDescriptor(this.family);
        colDesc.setTimeToLive(1);
        desc.addFamily(colDesc);
        try {
            admin.createTable(desc);
            Assert.fail();
        }
        catch (Exception exception) {
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
    }
}

