/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSourceImpl;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestMetricsWAL {
    @Test
    public void testLogRollRequested() throws Exception {
        MetricsWALSource source = (MetricsWALSource)Mockito.mock(MetricsWALSourceImpl.class);
        MetricsWAL metricsWAL = new MetricsWAL(source);
        metricsWAL.logRollRequested(false);
        metricsWAL.logRollRequested(true);
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)2))).incrementLogRollRequested();
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementLowReplicationLogRoll();
    }

    @Test
    public void testPostSync() throws Exception {
        long nanos = TimeUnit.MILLISECONDS.toNanos(145L);
        MetricsWALSource source = (MetricsWALSource)Mockito.mock(MetricsWALSourceImpl.class);
        MetricsWAL metricsWAL = new MetricsWAL(source);
        metricsWAL.postSync(nanos, 1);
        ((MetricsWALSource)Mockito.verify((Object)source, (VerificationMode)Mockito.times((int)1))).incrementSyncTime(145L);
    }
}

