/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.master.cleaner.CleanerChore;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;

@InterfaceAudience.Private
public class HFileCleaner
extends CleanerChore<BaseHFileCleanerDelegate> {
    public static final String MASTER_HFILE_CLEANER_PLUGINS = "hbase.master.hfilecleaner.plugins";

    public HFileCleaner(int period, Stoppable stopper, Configuration conf, FileSystem fs, Path directory) {
        this(period, stopper, conf, fs, directory, null);
    }

    public HFileCleaner(int period, Stoppable stopper, Configuration conf, FileSystem fs, Path directory, Map<String, Object> params) {
        super("HFileCleaner", period, stopper, conf, fs, directory, MASTER_HFILE_CLEANER_PLUGINS, params);
    }

    @Override
    protected boolean validate(Path file) {
        if (HFileLink.isBackReferencesDir(file) || HFileLink.isBackReferencesDir(file.getParent())) {
            return true;
        }
        return StoreFileInfo.validateStoreFileName(file.getName());
    }

    public List<BaseHFileCleanerDelegate> getDelegatesForTesting() {
        return this.cleanersChain;
    }
}

