/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;

@InterfaceAudience.Private
public class ScopeWALEntryFilter
implements WALEntryFilter {
    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        NavigableMap<byte[], Integer> scopes = entry.getKey().getScopes();
        if (scopes == null || scopes.isEmpty()) {
            return null;
        }
        ArrayList<Cell> cells = entry.getEdit().getCells();
        int size = cells.size();
        for (int i = size - 1; i >= 0; --i) {
            Cell cell = cells.get(i);
            if (scopes.containsKey(cell.getFamily()) && (Integer)scopes.get(cell.getFamily()) != 0) continue;
            cells.remove(i);
        }
        if (cells.size() < size / 2) {
            cells.trimToSize();
        }
        return entry;
    }
}

