/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public final class ProcessUtils {
    private static Log LOG = LogFactory.getLog(ProcessUtils.class);

    private ProcessUtils() {
    }

    public static Integer getPid() {
        int idx;
        String name;
        String pidStr = System.getenv("JVM_PID");
        if ((pidStr == null || pidStr.trim().isEmpty()) && (name = ManagementFactory.getRuntimeMXBean().getName()) != null && (idx = name.indexOf("@")) != -1) {
            pidStr = name.substring(0, name.indexOf("@"));
        }
        try {
            if (pidStr != null) {
                return Integer.valueOf(pidStr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Process runCmdAsync(List<String> cmd) {
        try {
            LOG.info((Object)("Running command async: " + cmd));
            return new ProcessBuilder(cmd).inheritIO().start();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

