/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.base.Objects;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.stats.Sample;
import com.yammer.metrics.stats.Snapshot;
import com.yammer.metrics.stats.UniformSample;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterAllFilter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.RandomDistribution;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.trace.HBaseHTraceConfiguration;
import org.apache.hadoop.hbase.trace.SpanReceiverHost;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Hash;
import org.apache.hadoop.hbase.util.MurmurHash;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.YammerHistogramUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.NLineInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.reduce.LongSumReducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.Sampler;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.htrace.impl.ProbabilitySampler;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class PerformanceEvaluation
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog((String)PerformanceEvaluation.class.getName());
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String TABLE_NAME = "TestTable";
    public static final byte[] FAMILY_NAME;
    public static final byte[] COLUMN_ZERO;
    public static final byte[] QUALIFIER_NAME;
    public static final int DEFAULT_VALUE_LENGTH = 1000;
    public static final int ROW_LENGTH = 26;
    private static final int ONE_GB = 1048576000;
    private static final int DEFAULT_ROWS_PER_GB = 0x100000;
    private static final int TAG_LENGTH = 256;
    private static final DecimalFormat FMT;
    private static final MathContext CXT;
    private static final BigDecimal MS_PER_SEC;
    private static final BigDecimal BYTES_PER_MB;
    private static final TestOptions DEFAULT_OPTS;
    private static Map<String, CmdDescriptor> COMMANDS;
    private static final Path PERF_EVAL_DIR;

    public PerformanceEvaluation(Configuration conf) {
        super(conf);
    }

    protected static void addCommandDescriptor(Class<? extends Test> cmdClass, String name, String description) {
        CmdDescriptor cmdDescriptor = new CmdDescriptor(cmdClass, name, description);
        COMMANDS.put(name, cmdDescriptor);
    }

    static boolean checkTable(Admin admin, TestOptions opts) throws IOException {
        boolean isReadCmd;
        TableName tableName = TableName.valueOf((String)opts.tableName);
        boolean needsDelete = false;
        boolean exists = admin.tableExists(tableName);
        boolean bl = isReadCmd = opts.cmdName.toLowerCase().contains("read") || opts.cmdName.toLowerCase().contains("scan");
        if (!exists && isReadCmd) {
            throw new IllegalStateException("Must specify an existing table for read commands. Run a write command first.");
        }
        HTableDescriptor desc = exists ? admin.getTableDescriptor(TableName.valueOf((String)opts.tableName)) : null;
        byte[][] splits = PerformanceEvaluation.getSplits(opts);
        if (exists && opts.presplitRegions != PerformanceEvaluation.DEFAULT_OPTS.presplitRegions || !isReadCmd && desc != null && desc.getRegionSplitPolicyClassName() != opts.splitPolicy || !isReadCmd && desc != null && desc.getRegionReplication() != opts.replicas) {
            needsDelete = true;
            LOG.debug((Object)Objects.toStringHelper((String)"needsDelete").add("needsDelete", needsDelete).add("isReadCmd", isReadCmd).add("exists", exists).add("desc", (Object)desc).add("presplit", opts.presplitRegions).add("splitPolicy", (Object)opts.splitPolicy).add("replicas", opts.replicas));
        }
        if (needsDelete) {
            if (admin.isTableEnabled(tableName)) {
                admin.disableTable(tableName);
            }
            admin.deleteTable(tableName);
        }
        if (!exists || needsDelete) {
            desc = PerformanceEvaluation.getTableDescriptor(opts);
            if (splits != null && LOG.isDebugEnabled()) {
                for (int i = 0; i < splits.length; ++i) {
                    LOG.debug((Object)(" split " + i + ": " + Bytes.toStringBinary((byte[])splits[i])));
                }
            }
            admin.createTable(desc, splits);
            LOG.info((Object)("Table " + desc + " created"));
        }
        return admin.tableExists(tableName);
    }

    protected static HTableDescriptor getTableDescriptor(TestOptions opts) {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)opts.tableName));
        HColumnDescriptor family = new HColumnDescriptor(FAMILY_NAME);
        family.setDataBlockEncoding(opts.blockEncoding);
        family.setCompressionType(opts.compression);
        family.setBloomFilterType(opts.bloomType);
        if (opts.inMemoryCF) {
            family.setInMemory(true);
        }
        desc.addFamily(family);
        if (opts.replicas != PerformanceEvaluation.DEFAULT_OPTS.replicas) {
            desc.setRegionReplication(opts.replicas);
        }
        if (opts.splitPolicy != PerformanceEvaluation.DEFAULT_OPTS.splitPolicy) {
            desc.setRegionSplitPolicyClassName(opts.splitPolicy);
        }
        return desc;
    }

    protected static byte[][] getSplits(TestOptions opts) {
        if (opts.presplitRegions == PerformanceEvaluation.DEFAULT_OPTS.presplitRegions) {
            return null;
        }
        int numSplitPoints = opts.presplitRegions - 1;
        byte[][] splits = new byte[numSplitPoints][];
        int jump = opts.totalRows / opts.presplitRegions;
        for (int i = 0; i < numSplitPoints; ++i) {
            int rowkey = jump * (1 + i);
            splits[i] = PerformanceEvaluation.format(rowkey);
        }
        return splits;
    }

    static RunResult[] doLocalClients(final TestOptions opts, final Configuration conf) throws IOException, InterruptedException {
        int i;
        final Class<? extends Test> cmd = PerformanceEvaluation.determineCommandClass(opts.cmdName);
        assert (cmd != null);
        Future[] threads = new Future[opts.numClientThreads];
        Object[] results = new RunResult[opts.numClientThreads];
        ExecutorService pool = Executors.newFixedThreadPool(opts.numClientThreads, new ThreadFactoryBuilder().setNameFormat("TestClient-%s").build());
        final Connection con = ConnectionFactory.createConnection((Configuration)conf);
        for (i = 0; i < threads.length; ++i) {
            final int index = i;
            threads[i] = pool.submit(new Callable<RunResult>(){

                @Override
                public RunResult call() throws Exception {
                    TestOptions threadOpts = new TestOptions(opts);
                    if (threadOpts.startRow == 0) {
                        threadOpts.startRow = index * threadOpts.perClientRunRows;
                    }
                    RunResult run = PerformanceEvaluation.runOneClient(cmd, conf, con, threadOpts, new Status(){

                        @Override
                        public void setStatus(String msg) throws IOException {
                            LOG.info((Object)msg);
                        }
                    });
                    LOG.info((Object)("Finished " + Thread.currentThread().getName() + " in " + run.duration + "ms over " + threadOpts.perClientRunRows + " rows"));
                    return run;
                }
            });
        }
        pool.shutdown();
        for (i = 0; i < threads.length; ++i) {
            try {
                results[i] = (RunResult)threads[i].get();
                continue;
            }
            catch (ExecutionException e) {
                throw new IOException(e.getCause());
            }
        }
        String test = cmd.getSimpleName();
        LOG.info((Object)("[" + test + "] Summary of timings (ms): " + Arrays.toString(results)));
        Arrays.sort(results);
        long total = 0L;
        for (Object result : results) {
            total += ((RunResult)result).duration;
        }
        LOG.info((Object)("[" + test + "]" + "\tMin: " + results[0] + "ms" + "\tMax: " + results[results.length - 1] + "ms" + "\tAvg: " + total / (long)results.length + "ms"));
        con.close();
        return results;
    }

    static Job doMapReduce(TestOptions opts, Configuration conf) throws IOException, InterruptedException, ClassNotFoundException {
        Class<? extends Test> cmd = PerformanceEvaluation.determineCommandClass(opts.cmdName);
        assert (cmd != null);
        Path inputDir = PerformanceEvaluation.writeInputFile(conf, opts);
        conf.set("EvaluationMapTask.command", cmd.getName());
        conf.set("EvaluationMapTask.performanceEvalImpl", PerformanceEvaluation.class.getName());
        Job job = Job.getInstance((Configuration)conf);
        job.setJarByClass(PerformanceEvaluation.class);
        job.setJobName("HBase Performance Evaluation - " + opts.cmdName);
        job.setInputFormatClass(NLineInputFormat.class);
        NLineInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        NLineInputFormat.setNumLinesPerSplit((Job)job, (int)1);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(EvaluationMapTask.class);
        job.setReducerClass(LongSumReducer.class);
        job.setNumReduceTasks(1);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(inputDir.getParent(), "outputs"));
        TableMapReduceUtil.addDependencyJars((Job)job);
        TableMapReduceUtil.addDependencyJars((Configuration)job.getConfiguration(), (Class[])new Class[]{Histogram.class, ObjectMapper.class});
        TableMapReduceUtil.initCredentials((Job)job);
        job.waitForCompletion(true);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path writeInputFile(Configuration c, TestOptions opts) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Path jobdir = new Path(PERF_EVAL_DIR, formatter.format(new Date()));
        Path inputDir = new Path(jobdir, "inputs");
        FileSystem fs = FileSystem.get((Configuration)c);
        fs.mkdirs(inputDir);
        Path inputFile = new Path(inputDir, "input.txt");
        PrintStream out = new PrintStream((OutputStream)fs.create(inputFile));
        TreeMap<Integer, String> m = new TreeMap<Integer, String>();
        Hash h = MurmurHash.getInstance();
        int perClientRows = opts.totalRows / opts.numClientThreads;
        try {
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < opts.numClientThreads; ++j) {
                    TestOptions next = new TestOptions(opts);
                    next.startRow = j * perClientRows + i * (perClientRows / 10);
                    next.perClientRunRows = perClientRows / 10;
                    String s = MAPPER.writeValueAsString((Object)next);
                    LOG.info((Object)("maptask input=" + s));
                    int hash = h.hash(Bytes.toBytes((String)s));
                    m.put(hash, s);
                }
            }
            for (Map.Entry e : m.entrySet()) {
                out.println((String)e.getValue());
            }
        }
        finally {
            out.close();
        }
        return inputDir;
    }

    private static String calculateMbps(int rows, long timeMs, int valueSize, int columns) {
        BigDecimal rowSize = BigDecimal.valueOf(26 + (valueSize + FAMILY_NAME.length + COLUMN_ZERO.length) * columns);
        BigDecimal mbps = BigDecimal.valueOf(rows).multiply(rowSize, CXT).divide(BigDecimal.valueOf(timeMs), CXT).multiply(MS_PER_SEC, CXT).divide(BYTES_PER_MB, CXT);
        return FMT.format(mbps) + " MB/s";
    }

    public static byte[] format(int number) {
        byte[] b = new byte[26];
        int d = Math.abs(number);
        for (int i = b.length - 1; i >= 0; --i) {
            b[i] = (byte)(d % 10 + 48);
            d /= 10;
        }
        return b;
    }

    public static byte[] generateData(Random r, int length) {
        int i;
        byte[] b = new byte[length];
        for (i = 0; i < length - 8; i += 8) {
            b[i] = (byte)(65 + r.nextInt(26));
            b[i + 1] = b[i];
            b[i + 2] = b[i];
            b[i + 3] = b[i];
            b[i + 4] = b[i];
            b[i + 5] = b[i];
            b[i + 6] = b[i];
            b[i + 7] = b[i];
        }
        byte a = (byte)(65 + r.nextInt(26));
        while (i < length) {
            b[i] = a;
            ++i;
        }
        return b;
    }

    @Deprecated
    public static byte[] generateValue(Random r) {
        return PerformanceEvaluation.generateData(r, 1000);
    }

    static byte[] getRandomRow(Random random, int totalRows) {
        return PerformanceEvaluation.format(random.nextInt(Integer.MAX_VALUE) % totalRows);
    }

    static RunResult runOneClient(Class<? extends Test> cmd, Configuration conf, Connection con, TestOptions opts, Status status) throws IOException, InterruptedException {
        Test t;
        status.setStatus("Start " + cmd + " at offset " + opts.startRow + " for " + opts.perClientRunRows + " rows");
        try {
            Constructor<? extends Test> constructor = cmd.getDeclaredConstructor(Connection.class, TestOptions.class, Status.class);
            t = constructor.newInstance(con, opts, status);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Invalid command class: " + cmd.getName() + ".  It does not provide a constructor as described by " + "the javadoc comment.  Available constructors are: " + Arrays.toString(cmd.getConstructors()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to construct command class", e);
        }
        long totalElapsedTime = t.test();
        status.setStatus("Finished " + cmd + " in " + totalElapsedTime + "ms at offset " + opts.startRow + " for " + opts.perClientRunRows + " rows" + " (" + PerformanceEvaluation.calculateMbps((int)((float)opts.perClientRunRows * opts.sampleRate), totalElapsedTime, PerformanceEvaluation.getAverageValueLength(opts), opts.columns) + ")");
        return new RunResult(totalElapsedTime, t.getLatency());
    }

    private static int getAverageValueLength(TestOptions opts) {
        return opts.valueRandom ? opts.valueSize / 2 : opts.valueSize;
    }

    private void runTest(Class<? extends Test> cmd, TestOptions opts) throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)(cmd.getSimpleName() + " test run options=" + MAPPER.writeValueAsString((Object)opts)));
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.getConf());
             Admin admin = conn.getAdmin();){
            PerformanceEvaluation.checkTable(admin, opts);
        }
        if (opts.nomapred) {
            PerformanceEvaluation.doLocalClients(opts, this.getConf());
        } else {
            PerformanceEvaluation.doMapReduce(opts, this.getConf());
        }
    }

    protected void printUsage() {
        PerformanceEvaluation.printUsage(((Object)((Object)this)).getClass().getName(), null);
    }

    protected static void printUsage(String message) {
        PerformanceEvaluation.printUsage(PerformanceEvaluation.class.getName(), message);
    }

    protected static void printUsageAndExit(String message, int exitCode) {
        PerformanceEvaluation.printUsage(message);
        System.exit(exitCode);
    }

    protected static void printUsage(String className, String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.println("Usage: java " + className + " \\");
        System.err.println("  <OPTIONS> [-D<property=value>]* <command> <nclients>");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" nomapred        Run multiple clients using threads (rather than use mapreduce)");
        System.err.println(" rows            Rows each client runs. Default: One million");
        System.err.println(" size            Total size in GiB. Mutually exclusive with --rows. Default: 1.0.");
        System.err.println(" sampleRate      Execute test on a sample of total rows. Only supported by randomRead. Default: 1.0");
        System.err.println(" traceRate       Enable HTrace spans. Initiate tracing every N rows. Default: 0");
        System.err.println(" table           Alternate table name. Default: 'TestTable'");
        System.err.println(" multiGet        If >0, when doing RandomRead, perform multiple gets instead of single gets. Default: 0");
        System.err.println(" compress        Compression type to use (GZ, LZO, ...). Default: 'NONE'");
        System.err.println(" flushCommits    Used to determine if the test should flush the table. Default: false");
        System.err.println(" writeToWAL      Set writeToWAL on puts. Default: True");
        System.err.println(" autoFlush       Set autoFlush on htable. Default: False");
        System.err.println(" oneCon          all the threads share the same connection. Default: False");
        System.err.println(" presplit        Create presplit table. Recommended for accurate perf analysis (see guide).  Default: disabled");
        System.err.println(" inmemory        Tries to keep the HFiles of the CF inmemory as far as possible. Not guaranteed that reads are always served from memory.  Default: false");
        System.err.println(" usetags         Writes tags along with KVs. Use with HFile V3. Default: false");
        System.err.println(" numoftags       Specify the no of tags that would be needed. This works only if usetags is true.");
        System.err.println(" filterAll       Helps to filter out all the rows on the server side there by not returning any thing back to the client.  Helps to check the server side performance.  Uses FilterAllFilter internally. ");
        System.err.println(" latency         Set to report operation latencies. Default: False");
        System.err.println(" bloomFilter      Bloom filter type, one of " + Arrays.toString(BloomType.values()));
        System.err.println(" valueSize       Pass value size to use: Default: 1024");
        System.err.println(" valueRandom     Set if we should vary value size between 0 and 'valueSize'; set on read for stats on size: Default: Not set.");
        System.err.println(" valueZipf       Set if we should vary value size between 0 and 'valueSize' in zipf form: Default: Not set.");
        System.err.println(" period          Report every 'period' rows: Default: opts.perClientRunRows / 10");
        System.err.println(" multiGet        Batch gets together into groups of N. Only supported by randomRead. Default: disabled");
        System.err.println(" addColumns      Adds columns to scans/gets explicitly. Default: true");
        System.err.println(" replicas        Enable region replica testing. Defaults: 1.");
        System.err.println(" splitPolicy     Specify a custom RegionSplitPolicy for the table.");
        System.err.println(" randomSleep     Do a random sleep before each get between 0 and entered value. Defaults: 0");
        System.err.println(" columns         Columns to write per row. Default: 1");
        System.err.println(" caching         Scan caching to use. Default: 30");
        System.err.println();
        System.err.println(" Note: -D properties will be applied to the conf used. ");
        System.err.println("  For example: ");
        System.err.println("   -Dmapreduce.output.fileoutputformat.compress=true");
        System.err.println("   -Dmapreduce.task.timeout=60000");
        System.err.println();
        System.err.println("Command:");
        for (CmdDescriptor command : COMMANDS.values()) {
            System.err.println(String.format(" %-15s %s", command.getName(), command.getDescription()));
        }
        System.err.println();
        System.err.println("Args:");
        System.err.println(" nclients        Integer. Required. Total number of clients (and HRegionServers)");
        System.err.println("                 running: 1 <= value <= 500");
        System.err.println("Examples:");
        System.err.println(" To run a single client doing the default 1M sequentialWrites:");
        System.err.println(" $ bin/hbase " + className + " sequentialWrite 1");
        System.err.println(" To run 10 clients doing increments over ten rows:");
        System.err.println(" $ bin/hbase " + className + " --rows=10 --nomapred increment 10");
    }

    static TestOptions parseOpts(Queue<String> args) {
        TestOptions opts = new TestOptions();
        String cmd = null;
        while ((cmd = args.poll()) != null) {
            if (cmd.equals("-h") || cmd.startsWith("--h")) {
                args.add(cmd);
                break;
            }
            String nmr = "--nomapred";
            if (cmd.startsWith("--nomapred")) {
                opts.nomapred = true;
                continue;
            }
            String rows = "--rows=";
            if (cmd.startsWith("--rows=")) {
                opts.perClientRunRows = Integer.parseInt(cmd.substring("--rows=".length()));
                continue;
            }
            String sampleRate = "--sampleRate=";
            if (cmd.startsWith("--sampleRate=")) {
                opts.sampleRate = Float.parseFloat(cmd.substring("--sampleRate=".length()));
                continue;
            }
            String table = "--table=";
            if (cmd.startsWith("--table=")) {
                opts.tableName = cmd.substring("--table=".length());
                continue;
            }
            String startRow = "--startRow=";
            if (cmd.startsWith("--startRow=")) {
                opts.startRow = Integer.parseInt(cmd.substring("--startRow=".length()));
                continue;
            }
            String compress = "--compress=";
            if (cmd.startsWith("--compress=")) {
                opts.compression = Compression.Algorithm.valueOf((String)cmd.substring("--compress=".length()));
                continue;
            }
            String traceRate = "--traceRate=";
            if (cmd.startsWith("--traceRate=")) {
                opts.traceRate = Double.parseDouble(cmd.substring("--traceRate=".length()));
                continue;
            }
            String blockEncoding = "--blockEncoding=";
            if (cmd.startsWith("--blockEncoding=")) {
                opts.blockEncoding = DataBlockEncoding.valueOf((String)cmd.substring("--blockEncoding=".length()));
                continue;
            }
            String flushCommits = "--flushCommits=";
            if (cmd.startsWith("--flushCommits=")) {
                opts.flushCommits = Boolean.parseBoolean(cmd.substring("--flushCommits=".length()));
                continue;
            }
            String writeToWAL = "--writeToWAL=";
            if (cmd.startsWith("--writeToWAL=")) {
                opts.writeToWAL = Boolean.parseBoolean(cmd.substring("--writeToWAL=".length()));
                continue;
            }
            String presplit = "--presplit=";
            if (cmd.startsWith("--presplit=")) {
                opts.presplitRegions = Integer.parseInt(cmd.substring("--presplit=".length()));
                continue;
            }
            String inMemory = "--inmemory=";
            if (cmd.startsWith("--inmemory=")) {
                opts.inMemoryCF = Boolean.parseBoolean(cmd.substring("--inmemory=".length()));
                continue;
            }
            String autoFlush = "--autoFlush=";
            if (cmd.startsWith("--autoFlush=")) {
                opts.autoFlush = Boolean.parseBoolean(cmd.substring("--autoFlush=".length()));
                continue;
            }
            String onceCon = "--oneCon=";
            if (cmd.startsWith("--oneCon=")) {
                opts.oneCon = Boolean.parseBoolean(cmd.substring("--oneCon=".length()));
                continue;
            }
            String latency = "--latency";
            if (cmd.startsWith("--latency")) {
                opts.reportLatency = true;
                continue;
            }
            String multiGet = "--multiGet=";
            if (cmd.startsWith("--multiGet=")) {
                opts.multiGet = Integer.parseInt(cmd.substring("--multiGet=".length()));
                continue;
            }
            String useTags = "--usetags=";
            if (cmd.startsWith("--usetags=")) {
                opts.useTags = Boolean.parseBoolean(cmd.substring("--usetags=".length()));
                continue;
            }
            String noOfTags = "--numoftags=";
            if (cmd.startsWith("--numoftags=")) {
                opts.noOfTags = Integer.parseInt(cmd.substring("--numoftags=".length()));
                continue;
            }
            String replicas = "--replicas=";
            if (cmd.startsWith("--replicas=")) {
                opts.replicas = Integer.parseInt(cmd.substring("--replicas=".length()));
                continue;
            }
            String filterOutAll = "--filterAll";
            if (cmd.startsWith("--filterAll")) {
                opts.filterAll = true;
                continue;
            }
            String size = "--size=";
            if (cmd.startsWith("--size=")) {
                opts.size = Float.parseFloat(cmd.substring("--size=".length()));
                continue;
            }
            String splitPolicy = "--splitPolicy=";
            if (cmd.startsWith("--splitPolicy=")) {
                opts.splitPolicy = cmd.substring("--splitPolicy=".length());
                continue;
            }
            String randomSleep = "--randomSleep=";
            if (cmd.startsWith("--randomSleep=")) {
                opts.randomSleep = Integer.parseInt(cmd.substring("--randomSleep=".length()));
                continue;
            }
            String bloomFilter = "--bloomFilter=";
            if (cmd.startsWith("--bloomFilter=")) {
                opts.bloomType = BloomType.valueOf((String)cmd.substring("--bloomFilter=".length()));
                continue;
            }
            String valueSize = "--valueSize=";
            if (cmd.startsWith("--valueSize=")) {
                opts.valueSize = Integer.parseInt(cmd.substring("--valueSize=".length()));
                continue;
            }
            String valueRandom = "--valueRandom";
            if (cmd.startsWith("--valueRandom")) {
                opts.valueRandom = true;
                if (!opts.valueZipf) continue;
                throw new IllegalStateException("Either valueZipf or valueRandom but not both");
            }
            String valueZipf = "--valueZipf";
            if (cmd.startsWith("--valueZipf")) {
                opts.valueZipf = true;
                if (!opts.valueRandom) continue;
                throw new IllegalStateException("Either valueZipf or valueRandom but not both");
            }
            String period = "--period=";
            if (cmd.startsWith("--period=")) {
                opts.period = Integer.parseInt(cmd.substring("--period=".length()));
                continue;
            }
            String addColumns = "--addColumns=";
            if (cmd.startsWith("--addColumns=")) {
                opts.addColumns = Boolean.parseBoolean(cmd.substring("--addColumns=".length()));
                continue;
            }
            String columns = "--columns=";
            if (cmd.startsWith("--columns=")) {
                opts.columns = Integer.parseInt(cmd.substring("--columns=".length()));
                continue;
            }
            String caching = "--caching=";
            if (cmd.startsWith("--caching=")) {
                opts.caching = Integer.parseInt(cmd.substring("--caching=".length()));
                continue;
            }
            if (PerformanceEvaluation.isCommandClass(cmd)) {
                opts.cmdName = cmd;
                opts.numClientThreads = Integer.parseInt(args.remove());
                int rowsPerGB = PerformanceEvaluation.getRowsPerGB(opts);
                if (opts.size != PerformanceEvaluation.DEFAULT_OPTS.size && opts.perClientRunRows != PerformanceEvaluation.DEFAULT_OPTS.perClientRunRows) {
                    throw new IllegalArgumentException("--rows= and --size= are mutually exclusive arguments.");
                }
                if (opts.size != PerformanceEvaluation.DEFAULT_OPTS.size) {
                    opts.totalRows = (int)opts.size * rowsPerGB;
                    opts.perClientRunRows = opts.totalRows / opts.numClientThreads;
                    break;
                }
                opts.totalRows = opts.perClientRunRows * opts.numClientThreads;
                opts.size = opts.totalRows / rowsPerGB;
                break;
            }
            PerformanceEvaluation.printUsageAndExit("ERROR: Unrecognized option/command: " + cmd, -1);
            System.err.println("Error: Wrong option or command: " + cmd);
            args.add(cmd);
            break;
        }
        return opts;
    }

    static int getRowsPerGB(TestOptions opts) {
        return 1048576000 / ((opts.valueRandom ? opts.valueSize / 2 : opts.valueSize) * opts.getColumns());
    }

    public int run(String[] args) throws Exception {
        int errCode = -1;
        if (args.length < 1) {
            this.printUsage();
            return errCode;
        }
        try {
            LinkedList<String> argv = new LinkedList<String>();
            argv.addAll(Arrays.asList(args));
            TestOptions opts = PerformanceEvaluation.parseOpts(argv);
            if (!argv.isEmpty()) {
                errCode = 0;
                this.printUsage();
                return errCode;
            }
            if (opts.numClientThreads <= 0) {
                throw new IllegalArgumentException("Number of clients must be > 0");
            }
            Class<? extends Test> cmdClass = PerformanceEvaluation.determineCommandClass(opts.cmdName);
            if (cmdClass != null) {
                this.runTest(cmdClass, opts);
                errCode = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errCode;
    }

    private static boolean isCommandClass(String cmd) {
        return COMMANDS.containsKey(cmd);
    }

    private static Class<? extends Test> determineCommandClass(String cmd) {
        CmdDescriptor descriptor = COMMANDS.get(cmd);
        return descriptor != null ? descriptor.getCmdClass() : null;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new PerformanceEvaluation(HBaseConfiguration.create()), (String[])args);
        System.exit(res);
    }

    static {
        MAPPER.configure(SerializationConfig.Feature.SORT_PROPERTIES_ALPHABETICALLY, true);
        FAMILY_NAME = Bytes.toBytes((String)"info");
        COLUMN_ZERO = Bytes.toBytes((String)"0");
        QUALIFIER_NAME = COLUMN_ZERO;
        FMT = new DecimalFormat("0.##");
        CXT = MathContext.DECIMAL64;
        MS_PER_SEC = BigDecimal.valueOf(1000L);
        BYTES_PER_MB = BigDecimal.valueOf(0x100000L);
        DEFAULT_OPTS = new TestOptions();
        COMMANDS = new TreeMap<String, CmdDescriptor>();
        PERF_EVAL_DIR = new Path("performance_evaluation");
        PerformanceEvaluation.addCommandDescriptor(RandomReadTest.class, "randomRead", "Run random read test");
        PerformanceEvaluation.addCommandDescriptor(RandomSeekScanTest.class, "randomSeekScan", "Run random seek and scan 100 test");
        PerformanceEvaluation.addCommandDescriptor(RandomScanWithRange10Test.class, "scanRange10", "Run random seek scan with both start and stop row (max 10 rows)");
        PerformanceEvaluation.addCommandDescriptor(RandomScanWithRange100Test.class, "scanRange100", "Run random seek scan with both start and stop row (max 100 rows)");
        PerformanceEvaluation.addCommandDescriptor(RandomScanWithRange1000Test.class, "scanRange1000", "Run random seek scan with both start and stop row (max 1000 rows)");
        PerformanceEvaluation.addCommandDescriptor(RandomScanWithRange10000Test.class, "scanRange10000", "Run random seek scan with both start and stop row (max 10000 rows)");
        PerformanceEvaluation.addCommandDescriptor(RandomWriteTest.class, "randomWrite", "Run random write test");
        PerformanceEvaluation.addCommandDescriptor(SequentialReadTest.class, "sequentialRead", "Run sequential read test");
        PerformanceEvaluation.addCommandDescriptor(SequentialWriteTest.class, "sequentialWrite", "Run sequential write test");
        PerformanceEvaluation.addCommandDescriptor(ScanTest.class, "scan", "Run scan test (read every row)");
        PerformanceEvaluation.addCommandDescriptor(FilteredScanTest.class, "filterScan", "Run scan test using a filter to find a specific row based on it's value (make sure to use --rows=20)");
        PerformanceEvaluation.addCommandDescriptor(IncrementTest.class, "increment", "Increment on each row; clients overlap on keyspace so some concurrent operations");
        PerformanceEvaluation.addCommandDescriptor(AppendTest.class, "append", "Append on each row; clients overlap on keyspace so some concurrent operations");
        PerformanceEvaluation.addCommandDescriptor(CheckAndMutateTest.class, "checkAndMutate", "CheckAndMutate on each row; clients overlap on keyspace so some concurrent operations");
        PerformanceEvaluation.addCommandDescriptor(CheckAndPutTest.class, "checkAndPut", "CheckAndPut on each row; clients overlap on keyspace so some concurrent operations");
        PerformanceEvaluation.addCommandDescriptor(CheckAndDeleteTest.class, "checkAndDelete", "CheckAndDelete on each row; clients overlap on keyspace so some concurrent operations");
    }

    static class FilteredScanTest
    extends TableTest {
        protected static final Log LOG = LogFactory.getLog((String)FilteredScanTest.class.getName());

        FilteredScanTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void testRow(int i) throws IOException {
            byte[] value = PerformanceEvaluation.generateData(this.rand, this.getValueLength(this.rand));
            Scan scan = this.constructScan(value);
            try (ResultScanner scanner = null;){
                scanner = this.table.getScanner(scan);
                Result r = null;
                while ((r = scanner.next()) != null) {
                    this.updateValueSize(r);
                }
            }
        }

        protected Scan constructScan(byte[] valuePrefix) throws IOException {
            FilterList list = new FilterList(new Filter[0]);
            SingleColumnValueFilter filter = new SingleColumnValueFilter(FAMILY_NAME, COLUMN_ZERO, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(valuePrefix));
            list.addFilter((Filter)filter);
            if (this.opts.filterAll) {
                list.addFilter((Filter)new FilterAllFilter());
            }
            Scan scan = new Scan();
            scan.setCaching(this.opts.caching);
            if (this.opts.addColumns) {
                scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            } else {
                scan.addFamily(FAMILY_NAME);
            }
            scan.setFilter((Filter)list);
            return scan;
        }
    }

    static class SequentialWriteTest
    extends BufferedMutatorTest {
        SequentialWriteTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            byte[] row = PerformanceEvaluation.format(i);
            Put put = new Put(row);
            for (int column = 0; column < this.opts.columns; ++column) {
                byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                byte[] value = PerformanceEvaluation.generateData(this.rand, this.getValueLength(this.rand));
                if (this.opts.useTags) {
                    byte[] tag = PerformanceEvaluation.generateData(this.rand, 256);
                    Tag[] tags = new Tag[this.opts.noOfTags];
                    for (int n = 0; n < this.opts.noOfTags; ++n) {
                        Tag t;
                        tags[n] = t = new Tag((byte)n, tag);
                    }
                    KeyValue kv = new KeyValue(row, FAMILY_NAME, qualifier, Long.MAX_VALUE, value, tags);
                    put.add((Cell)kv);
                    this.updateValueSize(kv.getValueLength());
                    continue;
                }
                put.add(FAMILY_NAME, qualifier, value);
                this.updateValueSize(value.length);
            }
            put.setDurability(this.opts.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
            this.mutator.mutate((Mutation)put);
        }
    }

    static class SequentialReadTest
    extends TableTest {
        SequentialReadTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Get get = new Get(PerformanceEvaluation.format(i));
            if (this.opts.addColumns) {
                get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            }
            if (this.opts.filterAll) {
                get.setFilter((Filter)new FilterAllFilter());
            }
            this.updateValueSize(this.table.get(get));
        }
    }

    static class CheckAndDeleteTest
    extends CASTableTest {
        CheckAndDeleteTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            byte[] bytes = PerformanceEvaluation.format(i);
            Put put = new Put(bytes);
            put.addColumn(FAMILY_NAME, this.getQualifier(), bytes);
            this.table.put(put);
            Delete delete = new Delete(put.getRow());
            delete.addColumn(FAMILY_NAME, this.getQualifier());
            this.table.checkAndDelete(bytes, FAMILY_NAME, this.getQualifier(), CompareFilter.CompareOp.EQUAL, bytes, delete);
        }
    }

    static class CheckAndPutTest
    extends CASTableTest {
        CheckAndPutTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            byte[] bytes = PerformanceEvaluation.format(i);
            Put put = new Put(bytes);
            put.addColumn(FAMILY_NAME, this.getQualifier(), bytes);
            this.table.put(put);
            this.table.checkAndPut(bytes, FAMILY_NAME, this.getQualifier(), CompareFilter.CompareOp.EQUAL, bytes, put);
        }
    }

    static class CheckAndMutateTest
    extends CASTableTest {
        CheckAndMutateTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            byte[] bytes = PerformanceEvaluation.format(i);
            Put put = new Put(bytes);
            put.addColumn(FAMILY_NAME, this.getQualifier(), bytes);
            this.table.put(put);
            RowMutations mutations = new RowMutations(bytes);
            mutations.add(put);
            this.table.checkAndMutate(bytes, FAMILY_NAME, this.getQualifier(), CompareFilter.CompareOp.EQUAL, bytes, mutations);
        }
    }

    static class AppendTest
    extends CASTableTest {
        AppendTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            byte[] bytes = PerformanceEvaluation.format(i);
            Append append = new Append(bytes);
            append.add(FAMILY_NAME, this.getQualifier(), bytes);
            this.updateValueSize(this.table.append(append));
        }
    }

    static class IncrementTest
    extends CASTableTest {
        IncrementTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Increment increment = new Increment(PerformanceEvaluation.format(i));
            increment.addColumn(FAMILY_NAME, this.getQualifier(), 1L);
            this.updateValueSize(this.table.increment(increment));
        }
    }

    static abstract class CASTableTest
    extends TableTest {
        private final byte[] qualifier = Bytes.toBytes((String)this.getClass().getSimpleName());

        CASTableTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        byte[] getQualifier() {
            return this.qualifier;
        }

        @Override
        int getStartRow() {
            return 0;
        }

        @Override
        int getLastRow() {
            return this.opts.perClientRunRows;
        }
    }

    static class ScanTest
    extends TableTest {
        private ResultScanner testScanner;

        ScanTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void testTakedown() throws IOException {
            if (this.testScanner != null) {
                this.testScanner.close();
            }
            super.testTakedown();
        }

        @Override
        void testRow(int i) throws IOException {
            if (this.testScanner == null) {
                Scan scan = new Scan(PerformanceEvaluation.format(this.opts.startRow));
                scan.setCaching(this.opts.caching);
                if (this.opts.addColumns) {
                    scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
                } else {
                    scan.addFamily(FAMILY_NAME);
                }
                if (this.opts.filterAll) {
                    scan.setFilter((Filter)new FilterAllFilter());
                }
                this.testScanner = this.table.getScanner(scan);
            }
            Result r = this.testScanner.next();
            this.updateValueSize(r);
        }
    }

    static class RandomWriteTest
    extends BufferedMutatorTest {
        RandomWriteTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            byte[] row = PerformanceEvaluation.getRandomRow(this.rand, this.opts.totalRows);
            Put put = new Put(row);
            for (int column = 0; column < this.opts.columns; ++column) {
                byte[] qualifier = column == 0 ? COLUMN_ZERO : Bytes.toBytes((String)("" + column));
                byte[] value = PerformanceEvaluation.generateData(this.rand, this.getValueLength(this.rand));
                if (this.opts.useTags) {
                    byte[] tag = PerformanceEvaluation.generateData(this.rand, 256);
                    Tag[] tags = new Tag[this.opts.noOfTags];
                    for (int n = 0; n < this.opts.noOfTags; ++n) {
                        Tag t;
                        tags[n] = t = new Tag((byte)n, tag);
                    }
                    KeyValue kv = new KeyValue(row, FAMILY_NAME, qualifier, Long.MAX_VALUE, value, tags);
                    put.add((Cell)kv);
                    this.updateValueSize(kv.getValueLength());
                    continue;
                }
                put.add(FAMILY_NAME, qualifier, value);
                this.updateValueSize(value.length);
            }
            put.setDurability(this.opts.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
            this.mutator.mutate((Mutation)put);
        }
    }

    static class RandomReadTest
    extends TableTest {
        private final Consistency consistency;
        private ArrayList<Get> gets;
        private Random rd = new Random();

        RandomReadTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
            Consistency consistency = this.consistency = options.replicas == DEFAULT_OPTS.replicas ? null : Consistency.TIMELINE;
            if (this.opts.multiGet > 0) {
                LOG.info((Object)("MultiGet enabled. Sending GETs in batches of " + this.opts.multiGet + "."));
                this.gets = new ArrayList(this.opts.multiGet);
            }
        }

        @Override
        void testRow(int i) throws IOException, InterruptedException {
            if (this.opts.randomSleep > 0) {
                Thread.sleep(this.rd.nextInt(this.opts.randomSleep));
            }
            Get get = new Get(PerformanceEvaluation.getRandomRow(this.rand, this.opts.totalRows));
            if (this.opts.addColumns) {
                get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            } else {
                get.addFamily(FAMILY_NAME);
            }
            if (this.opts.filterAll) {
                get.setFilter((Filter)new FilterAllFilter());
            }
            get.setConsistency(this.consistency);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)get.toString());
            }
            if (this.opts.multiGet > 0) {
                this.gets.add(get);
                if (this.gets.size() == this.opts.multiGet) {
                    Result[] rs = this.table.get(this.gets);
                    this.updateValueSize(rs);
                    this.gets.clear();
                }
            } else {
                this.updateValueSize(this.table.get(get));
            }
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.opts.perClientRunRows / 10;
            return period == 0 ? this.opts.perClientRunRows : period;
        }

        @Override
        protected void testTakedown() throws IOException {
            if (this.gets != null && this.gets.size() > 0) {
                this.table.get(this.gets);
                this.gets.clear();
            }
            super.testTakedown();
        }
    }

    static class RandomScanWithRange10000Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange10000Test(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(10000);
        }
    }

    static class RandomScanWithRange1000Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange1000Test(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(1000);
        }
    }

    static class RandomScanWithRange100Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange100Test(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(100);
        }
    }

    static class RandomScanWithRange10Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange10Test(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(10);
        }
    }

    static abstract class RandomScanWithRangeTest
    extends TableTest {
        RandomScanWithRangeTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Pair<byte[], byte[]> startAndStopRow = this.getStartAndStopRow();
            Scan scan = new Scan((byte[])startAndStopRow.getFirst(), (byte[])startAndStopRow.getSecond());
            scan.setCaching(this.opts.caching);
            if (this.opts.filterAll) {
                scan.setFilter((Filter)new FilterAllFilter());
            }
            if (this.opts.addColumns) {
                scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            } else {
                scan.addFamily(FAMILY_NAME);
            }
            Result r = null;
            int count = 0;
            ResultScanner s = this.table.getScanner(scan);
            while ((r = s.next()) != null) {
                this.updateValueSize(r);
                ++count;
            }
            if (i % 100 == 0) {
                LOG.info((Object)String.format("Scan for key range %s - %s returned %s rows", Bytes.toString((byte[])((byte[])startAndStopRow.getFirst())), Bytes.toString((byte[])((byte[])startAndStopRow.getSecond())), count));
            }
            s.close();
        }

        protected abstract Pair<byte[], byte[]> getStartAndStopRow();

        protected Pair<byte[], byte[]> generateStartAndStopRows(int maxRange) {
            int start = this.rand.nextInt(Integer.MAX_VALUE) % this.opts.totalRows;
            int stop = start + maxRange;
            return new Pair((Object)PerformanceEvaluation.format(start), (Object)PerformanceEvaluation.format(stop));
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.opts.perClientRunRows / 100;
            return period == 0 ? this.opts.perClientRunRows : period;
        }
    }

    static class RandomSeekScanTest
    extends TableTest {
        RandomSeekScanTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Result rr;
            Scan scan = new Scan(PerformanceEvaluation.getRandomRow(this.rand, this.opts.totalRows));
            scan.setCaching(this.opts.caching);
            FilterList list = new FilterList(new Filter[0]);
            if (this.opts.addColumns) {
                scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            } else {
                scan.addFamily(FAMILY_NAME);
            }
            if (this.opts.filterAll) {
                list.addFilter((Filter)new FilterAllFilter());
            }
            list.addFilter((Filter)new WhileMatchFilter((Filter)new PageFilter(120L)));
            scan.setFilter((Filter)list);
            ResultScanner s = this.table.getScanner(scan);
            while ((rr = s.next()) != null) {
                this.updateValueSize(rr);
            }
            s.close();
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.opts.perClientRunRows / 100;
            return period == 0 ? this.opts.perClientRunRows : period;
        }
    }

    static abstract class BufferedMutatorTest
    extends Test {
        protected BufferedMutator mutator;

        BufferedMutatorTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void onStartup() throws IOException {
            this.mutator = this.connection.getBufferedMutator(TableName.valueOf((String)this.opts.tableName));
        }

        @Override
        void onTakedown() throws IOException {
            this.mutator.close();
        }
    }

    static abstract class TableTest
    extends Test {
        protected Table table;

        TableTest(Connection con, TestOptions options, Status status) {
            super(con, options, status);
        }

        @Override
        void onStartup() throws IOException {
            this.table = this.connection.getTable(TableName.valueOf((String)this.opts.tableName));
        }

        @Override
        void onTakedown() throws IOException {
            this.table.close();
        }
    }

    static abstract class Test {
        private static final Random randomSeed = new Random(System.currentTimeMillis());
        private final int everyN;
        protected final Random rand = new Random(Test.nextRandomSeed());
        protected final Configuration conf;
        protected final TestOptions opts;
        private final Status status;
        private final Sampler<?> traceSampler;
        private final SpanReceiverHost receiverHost;
        protected Connection connection;
        private String testName;
        private Histogram latency;
        private Histogram valueSize;
        private RandomDistribution.Zipf zipf;

        private static long nextRandomSeed() {
            return randomSeed.nextLong();
        }

        Test(Connection con, TestOptions options, Status status) {
            this.connection = con;
            this.conf = con == null ? HBaseConfiguration.create() : this.connection.getConfiguration();
            this.opts = options;
            this.status = status;
            this.testName = this.getClass().getSimpleName();
            this.receiverHost = SpanReceiverHost.getInstance((Configuration)this.conf);
            if (options.traceRate >= 1.0) {
                this.traceSampler = Sampler.ALWAYS;
            } else if (options.traceRate > 0.0) {
                this.conf.setDouble("hbase.sampler.fraction", options.traceRate);
                this.traceSampler = new ProbabilitySampler((HTraceConfiguration)new HBaseHTraceConfiguration(this.conf));
            } else {
                this.traceSampler = Sampler.NEVER;
            }
            this.everyN = (int)((float)this.opts.totalRows / ((float)this.opts.totalRows * this.opts.sampleRate));
            if (options.isValueZipf()) {
                this.zipf = new RandomDistribution.Zipf(this.rand, 1, options.getValueSize(), 1.1);
            }
            LOG.info((Object)("Sampling 1 every " + this.everyN + " out of " + this.opts.perClientRunRows + " total rows."));
        }

        int getValueLength(Random r) {
            if (this.opts.isValueRandom()) {
                return Math.abs(r.nextInt() % this.opts.valueSize);
            }
            if (this.opts.isValueZipf()) {
                return Math.abs(this.zipf.nextInt());
            }
            return this.opts.valueSize;
        }

        void updateValueSize(Result[] rs) throws IOException {
            if (rs == null || !this.isRandomValueSize()) {
                return;
            }
            for (Result r : rs) {
                this.updateValueSize(r);
            }
        }

        void updateValueSize(Result r) throws IOException {
            if (r == null || !this.isRandomValueSize()) {
                return;
            }
            int size = 0;
            CellScanner scanner = r.cellScanner();
            while (scanner.advance()) {
                size += scanner.current().getValueLength();
            }
            this.updateValueSize(size);
        }

        void updateValueSize(int valueSize) {
            if (!this.isRandomValueSize()) {
                return;
            }
            this.valueSize.update(valueSize);
        }

        String generateStatus(int sr, int i, int lr) {
            return sr + "/" + i + "/" + lr + ", latency " + this.getShortLatencyReport() + (!this.isRandomValueSize() ? "" : ", value size " + this.getShortValueSizeReport());
        }

        boolean isRandomValueSize() {
            return this.opts.valueRandom;
        }

        protected int getReportingPeriod() {
            return this.opts.period;
        }

        public Histogram getLatency() {
            return this.latency;
        }

        void testSetup() throws IOException {
            if (!this.opts.oneCon) {
                this.connection = ConnectionFactory.createConnection((Configuration)this.conf);
            }
            this.onStartup();
            this.latency = YammerHistogramUtils.newHistogram((Sample)new UniformSample(512000));
            this.valueSize = YammerHistogramUtils.newHistogram((Sample)new UniformSample(512000));
        }

        abstract void onStartup() throws IOException;

        void testTakedown() throws IOException {
            this.reportLatency();
            this.reportValueSize();
            this.onTakedown();
            if (!this.opts.oneCon) {
                this.connection.close();
            }
            this.receiverHost.closeReceivers();
        }

        abstract void onTakedown() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long test() throws IOException, InterruptedException {
            this.testSetup();
            LOG.info((Object)("Timed test starting in thread " + Thread.currentThread().getName()));
            long startTime = System.nanoTime();
            try {
                this.testTimed();
            }
            finally {
                this.testTakedown();
            }
            return (System.nanoTime() - startTime) / 1000000L;
        }

        int getStartRow() {
            return this.opts.startRow;
        }

        int getLastRow() {
            return this.getStartRow() + this.opts.perClientRunRows;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void testTimed() throws IOException, InterruptedException {
            int startRow = this.getStartRow();
            int lastRow = this.getLastRow();
            for (int i = startRow; i < lastRow; ++i) {
                if (i % this.everyN != 0) continue;
                long startTime = System.nanoTime();
                try (TraceScope scope = Trace.startSpan((String)"test row", this.traceSampler);){
                    this.testRow(i);
                }
                this.latency.update((System.nanoTime() - startTime) / 1000L);
                if (this.status == null || i <= 0 || i % this.getReportingPeriod() != 0) continue;
                this.status.setStatus(this.generateStatus(startRow, i, lastRow));
            }
        }

        private void reportLatency() throws IOException {
            this.status.setStatus(this.testName + " latency log (microseconds), on " + this.latency.count() + " measures");
            this.reportHistogram(this.latency);
        }

        private void reportValueSize() throws IOException {
            this.status.setStatus(this.testName + " valueSize after " + this.valueSize.count() + " measures");
            this.reportHistogram(this.valueSize);
        }

        private void reportHistogram(Histogram h) throws IOException {
            Snapshot sn = h.getSnapshot();
            this.status.setStatus(this.testName + " Min      = " + h.min());
            this.status.setStatus(this.testName + " Avg      = " + h.mean());
            this.status.setStatus(this.testName + " StdDev   = " + h.stdDev());
            this.status.setStatus(this.testName + " 50th     = " + sn.getMedian());
            this.status.setStatus(this.testName + " 75th     = " + sn.get75thPercentile());
            this.status.setStatus(this.testName + " 95th     = " + sn.get95thPercentile());
            this.status.setStatus(this.testName + " 99th     = " + sn.get99thPercentile());
            this.status.setStatus(this.testName + " 99.9th   = " + sn.get999thPercentile());
            this.status.setStatus(this.testName + " 99.99th  = " + sn.getValue(0.9999));
            this.status.setStatus(this.testName + " 99.999th = " + sn.getValue(0.99999));
            this.status.setStatus(this.testName + " Max      = " + h.max());
        }

        public String getShortLatencyReport() {
            return YammerHistogramUtils.getShortHistogramReport((Histogram)this.latency);
        }

        public String getShortValueSizeReport() {
            return YammerHistogramUtils.getShortHistogramReport((Histogram)this.valueSize);
        }

        abstract void testRow(int var1) throws IOException, InterruptedException;
    }

    static class TestOptions {
        String cmdName = null;
        boolean nomapred = false;
        boolean filterAll = false;
        int startRow = 0;
        float size = 1.0f;
        int perClientRunRows = 0x100000;
        int numClientThreads = 1;
        int totalRows = 0x100000;
        float sampleRate = 1.0f;
        double traceRate = 0.0;
        String tableName = "TestTable";
        boolean flushCommits = true;
        boolean writeToWAL = true;
        boolean autoFlush = false;
        boolean oneCon = false;
        boolean useTags = false;
        int noOfTags = 1;
        boolean reportLatency = false;
        int multiGet = 0;
        int randomSleep = 0;
        boolean inMemoryCF = false;
        int presplitRegions = 0;
        int replicas = 1;
        String splitPolicy = null;
        Compression.Algorithm compression = Compression.Algorithm.NONE;
        BloomType bloomType = BloomType.ROW;
        DataBlockEncoding blockEncoding = DataBlockEncoding.NONE;
        boolean valueRandom = false;
        boolean valueZipf = false;
        int valueSize = 1000;
        int period = this.perClientRunRows / 10 == 0 ? this.perClientRunRows : this.perClientRunRows / 10;
        int columns = 1;
        int caching = 30;
        boolean addColumns = true;

        public TestOptions() {
        }

        public TestOptions(TestOptions that) {
            this.cmdName = that.cmdName;
            this.nomapred = that.nomapred;
            this.startRow = that.startRow;
            this.size = that.size;
            this.perClientRunRows = that.perClientRunRows;
            this.numClientThreads = that.numClientThreads;
            this.totalRows = that.totalRows;
            this.sampleRate = that.sampleRate;
            this.traceRate = that.traceRate;
            this.tableName = that.tableName;
            this.flushCommits = that.flushCommits;
            this.writeToWAL = that.writeToWAL;
            this.autoFlush = that.autoFlush;
            this.oneCon = that.oneCon;
            this.useTags = that.useTags;
            this.noOfTags = that.noOfTags;
            this.reportLatency = that.reportLatency;
            this.multiGet = that.multiGet;
            this.inMemoryCF = that.inMemoryCF;
            this.presplitRegions = that.presplitRegions;
            this.replicas = that.replicas;
            this.splitPolicy = that.splitPolicy;
            this.compression = that.compression;
            this.blockEncoding = that.blockEncoding;
            this.filterAll = that.filterAll;
            this.bloomType = that.bloomType;
            this.valueRandom = that.valueRandom;
            this.valueZipf = that.valueZipf;
            this.valueSize = that.valueSize;
            this.period = that.period;
            this.randomSleep = that.randomSleep;
            this.addColumns = that.addColumns;
            this.columns = that.columns;
            this.caching = that.caching;
        }

        public int getCaching() {
            return this.caching;
        }

        public void setCaching(int caching) {
            this.caching = caching;
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public boolean isValueZipf() {
            return this.valueZipf;
        }

        public void setValueZipf(boolean valueZipf) {
            this.valueZipf = valueZipf;
        }

        public String getCmdName() {
            return this.cmdName;
        }

        public void setCmdName(String cmdName) {
            this.cmdName = cmdName;
        }

        public int getRandomSleep() {
            return this.randomSleep;
        }

        public void setRandomSleep(int randomSleep) {
            this.randomSleep = randomSleep;
        }

        public int getReplicas() {
            return this.replicas;
        }

        public void setReplicas(int replicas) {
            this.replicas = replicas;
        }

        public String getSplitPolicy() {
            return this.splitPolicy;
        }

        public void setSplitPolicy(String splitPolicy) {
            this.splitPolicy = splitPolicy;
        }

        public void setNomapred(boolean nomapred) {
            this.nomapred = nomapred;
        }

        public void setFilterAll(boolean filterAll) {
            this.filterAll = filterAll;
        }

        public void setStartRow(int startRow) {
            this.startRow = startRow;
        }

        public void setSize(float size) {
            this.size = size;
        }

        public void setPerClientRunRows(int perClientRunRows) {
            this.perClientRunRows = perClientRunRows;
        }

        public void setNumClientThreads(int numClientThreads) {
            this.numClientThreads = numClientThreads;
        }

        public void setTotalRows(int totalRows) {
            this.totalRows = totalRows;
        }

        public void setSampleRate(float sampleRate) {
            this.sampleRate = sampleRate;
        }

        public void setTraceRate(double traceRate) {
            this.traceRate = traceRate;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setFlushCommits(boolean flushCommits) {
            this.flushCommits = flushCommits;
        }

        public void setWriteToWAL(boolean writeToWAL) {
            this.writeToWAL = writeToWAL;
        }

        public void setAutoFlush(boolean autoFlush) {
            this.autoFlush = autoFlush;
        }

        public void setOneCon(boolean oneCon) {
            this.oneCon = oneCon;
        }

        public void setUseTags(boolean useTags) {
            this.useTags = useTags;
        }

        public void setNoOfTags(int noOfTags) {
            this.noOfTags = noOfTags;
        }

        public void setReportLatency(boolean reportLatency) {
            this.reportLatency = reportLatency;
        }

        public void setMultiGet(int multiGet) {
            this.multiGet = multiGet;
        }

        public void setInMemoryCF(boolean inMemoryCF) {
            this.inMemoryCF = inMemoryCF;
        }

        public void setPresplitRegions(int presplitRegions) {
            this.presplitRegions = presplitRegions;
        }

        public void setCompression(Compression.Algorithm compression) {
            this.compression = compression;
        }

        public void setBloomType(BloomType bloomType) {
            this.bloomType = bloomType;
        }

        public void setBlockEncoding(DataBlockEncoding blockEncoding) {
            this.blockEncoding = blockEncoding;
        }

        public void setValueRandom(boolean valueRandom) {
            this.valueRandom = valueRandom;
        }

        public void setValueSize(int valueSize) {
            this.valueSize = valueSize;
        }

        public void setPeriod(int period) {
            this.period = period;
        }

        public boolean isNomapred() {
            return this.nomapred;
        }

        public boolean isFilterAll() {
            return this.filterAll;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public float getSize() {
            return this.size;
        }

        public int getPerClientRunRows() {
            return this.perClientRunRows;
        }

        public int getNumClientThreads() {
            return this.numClientThreads;
        }

        public int getTotalRows() {
            return this.totalRows;
        }

        public float getSampleRate() {
            return this.sampleRate;
        }

        public double getTraceRate() {
            return this.traceRate;
        }

        public String getTableName() {
            return this.tableName;
        }

        public boolean isFlushCommits() {
            return this.flushCommits;
        }

        public boolean isWriteToWAL() {
            return this.writeToWAL;
        }

        public boolean isAutoFlush() {
            return this.autoFlush;
        }

        public boolean isUseTags() {
            return this.useTags;
        }

        public int getNoOfTags() {
            return this.noOfTags;
        }

        public boolean isReportLatency() {
            return this.reportLatency;
        }

        public int getMultiGet() {
            return this.multiGet;
        }

        public boolean isInMemoryCF() {
            return this.inMemoryCF;
        }

        public int getPresplitRegions() {
            return this.presplitRegions;
        }

        public Compression.Algorithm getCompression() {
            return this.compression;
        }

        public DataBlockEncoding getBlockEncoding() {
            return this.blockEncoding;
        }

        public boolean isValueRandom() {
            return this.valueRandom;
        }

        public int getValueSize() {
            return this.valueSize;
        }

        public int getPeriod() {
            return this.period;
        }

        public BloomType getBloomType() {
            return this.bloomType;
        }

        public boolean isOneCon() {
            return this.oneCon;
        }

        public boolean getAddColumns() {
            return this.addColumns;
        }

        public void setAddColumns(boolean addColumns) {
            this.addColumns = addColumns;
        }
    }

    static class CmdDescriptor {
        private Class<? extends Test> cmdClass;
        private String name;
        private String description;

        CmdDescriptor(Class<? extends Test> cmdClass, String name, String description) {
            this.cmdClass = cmdClass;
            this.name = name;
            this.description = description;
        }

        public Class<? extends Test> getCmdClass() {
            return this.cmdClass;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class EvaluationMapTask
    extends Mapper<LongWritable, Text, LongWritable, LongWritable> {
        public static final String CMD_KEY = "EvaluationMapTask.command";
        public static final String PE_KEY = "EvaluationMapTask.performanceEvalImpl";
        private Class<? extends Test> cmd;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.cmd = this.forName(context.getConfiguration().get(CMD_KEY), Test.class);
            Class<PerformanceEvaluation> peClass = this.forName(context.getConfiguration().get(PE_KEY), PerformanceEvaluation.class);
            try {
                peClass.getConstructor(Configuration.class).newInstance(context.getConfiguration());
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate PE instance", e);
            }
        }

        private <Type> Class<? extends Type> forName(String className, Class<Type> type) {
            try {
                return Class.forName(className).asSubclass(type);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find class for name: " + className, e);
            }
        }

        protected void map(LongWritable key, Text value, final Mapper.Context context) throws IOException, InterruptedException {
            Status status = new Status(){

                @Override
                public void setStatus(String msg) {
                    context.setStatus(msg);
                }
            };
            ObjectMapper mapper = new ObjectMapper();
            TestOptions opts = (TestOptions)mapper.readValue(value.toString(), TestOptions.class);
            Configuration conf = HBaseConfiguration.create((Configuration)context.getConfiguration());
            Connection con = ConnectionFactory.createConnection((Configuration)conf);
            RunResult result = PerformanceEvaluation.runOneClient(this.cmd, conf, con, opts, status);
            context.getCounter((Enum)Counter.ELAPSED_TIME).increment(result.duration);
            context.getCounter((Enum)Counter.ROWS).increment((long)opts.perClientRunRows);
            context.write((Object)new LongWritable((long)opts.startRow), (Object)new LongWritable(result.duration));
            context.progress();
        }
    }

    static interface Status {
        public void setStatus(String var1) throws IOException;
    }

    protected static class RunResult
    implements Comparable<RunResult> {
        public final long duration;
        public final Histogram hist;

        public RunResult(long duration, Histogram hist) {
            this.duration = duration;
            this.hist = hist;
        }

        public String toString() {
            return Long.toString(this.duration);
        }

        @Override
        public int compareTo(RunResult o) {
            return Long.compare(this.duration, o.duration);
        }
    }

    protected static enum Counter {
        ELAPSED_TIME,
        ROWS;

    }
}

