/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.WALEntryStream;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReplicationSourceWALReaderThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(ReplicationSourceWALReaderThread.class);
    private PriorityBlockingQueue<Path> logQueue;
    private FileSystem fs;
    private Configuration conf;
    private BlockingQueue<WALEntryBatch> entryBatchQueue;
    private long replicationBatchSizeCapacity;
    private int replicationBatchCountCapacity;
    private long lastReadPosition;
    private Path lastReadPath;
    private WALEntryFilter filter;
    private long sleepForRetries;
    private boolean isReaderRunning = true;
    private ReplicationQueueInfo replicationQueueInfo;
    private int maxRetriesMultiplier;
    private MetricsSource metrics;

    public ReplicationSourceWALReaderThread(ReplicationSourceManager manager, ReplicationQueueInfo replicationQueueInfo, PriorityBlockingQueue<Path> logQueue, long startPosition, FileSystem fs, Configuration conf, WALEntryFilter filter, MetricsSource metrics) {
        this.replicationQueueInfo = replicationQueueInfo;
        this.logQueue = logQueue;
        this.lastReadPath = logQueue.peek();
        this.lastReadPosition = startPosition;
        this.fs = fs;
        this.conf = conf;
        this.filter = filter;
        this.replicationBatchSizeCapacity = this.conf.getLong("replication.source.size.capacity", 0x4000000L);
        this.replicationBatchCountCapacity = this.conf.getInt("replication.source.nb.capacity", 25000);
        int batchCount = conf.getInt("replication.source.nb.batches", 1);
        this.sleepForRetries = this.conf.getLong("replication.source.sleepforretries", 1000L);
        this.maxRetriesMultiplier = this.conf.getInt("replication.source.maxretriesmultiplier", 300);
        this.metrics = metrics;
        this.entryBatchQueue = new LinkedBlockingQueue<WALEntryBatch>(batchCount);
        LOG.info((Object)("peerClusterZnode=" + replicationQueueInfo.getPeerClusterZnode() + ", ReplicationSourceWALReaderThread : " + replicationQueueInfo.getPeerId() + " inited, replicationBatchSizeCapacity=" + this.replicationBatchSizeCapacity + ", replicationBatchCountCapacity=" + this.replicationBatchCountCapacity + ", replicationBatchQueueCapacity=" + batchCount));
    }

    @Override
    public void run() {
        int sleepMultiplier = 1;
        while (this.isReaderRunning()) {
            try {
                WALEntryStream entryStream = new WALEntryStream(this.logQueue, this.fs, this.conf, this.lastReadPosition, this.metrics);
                Throwable throwable = null;
                try {
                    while (this.isReaderRunning()) {
                        boolean hasNext;
                        WALEntryBatch batch = new WALEntryBatch(this.replicationBatchCountCapacity);
                        while (hasNext = entryStream.hasNext()) {
                            WALEdit edit;
                            WAL.Entry entry = entryStream.next();
                            if ((entry = this.filterEntry(entry)) == null || (edit = entry.getEdit()) == null || edit.isEmpty()) continue;
                            long entrySize = this.getEntrySize(entry);
                            batch.addEntry(entry);
                            this.updateBatchStats(batch, entry, entryStream.getPosition(), entrySize);
                            if (batch.getHeapSize() < this.replicationBatchSizeCapacity && batch.getNbEntries() < this.replicationBatchCountCapacity) continue;
                            break;
                        }
                        this.updateBatch(entryStream, batch, hasNext);
                        if (this.isShippable(batch)) {
                            sleepMultiplier = 1;
                            this.entryBatchQueue.put(batch);
                            if (!batch.hasMoreEntries()) {
                                this.setReaderRunning(false);
                            }
                        } else {
                            Thread.sleep(this.sleepForRetries);
                        }
                        this.resetStream(entryStream);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entryStream == null) continue;
                    if (throwable != null) {
                        try {
                            entryStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    entryStream.close();
                }
            }
            catch (IOException | WALEntryStream.WALEntryStreamRuntimeException e) {
                if (sleepMultiplier < this.maxRetriesMultiplier) {
                    LOG.debug((Object)("Failed to read stream of replication entries: " + e));
                    ++sleepMultiplier;
                } else {
                    LOG.error((Object)"Failed to read stream of replication entries", (Throwable)e);
                    this.handleEofException(e);
                }
                Threads.sleep((long)(this.sleepForRetries * (long)sleepMultiplier));
            }
            catch (InterruptedException e) {
                LOG.trace((Object)"Interrupted while sleeping between WAL reads");
                Thread.currentThread().interrupt();
            }
        }
    }

    private void updateBatch(WALEntryStream entryStream, WALEntryBatch batch, boolean moreData) {
        this.logMessage(batch);
        batch.updatePosition(entryStream);
        batch.setMoreEntries(!this.replicationQueueInfo.isQueueRecovered() || moreData);
    }

    private void logMessage(WALEntryBatch batch) {
        if (LOG.isTraceEnabled()) {
            if (batch.isEmpty()) {
                LOG.trace((Object)"Didn't read any new entries from WAL");
            } else {
                LOG.trace((Object)String.format("Read %s WAL entries eligible for replication", batch.getNbEntries()));
            }
        }
    }

    private boolean isShippable(WALEntryBatch batch) {
        return !batch.isEmpty() || this.checkIfWALRolled(batch) || !batch.hasMoreEntries();
    }

    private boolean checkIfWALRolled(WALEntryBatch batch) {
        return this.lastReadPath == null && batch.lastWalPath != null || this.lastReadPath != null && !this.lastReadPath.equals((Object)batch.lastWalPath);
    }

    private void resetStream(WALEntryStream stream) throws IOException {
        this.lastReadPosition = stream.getPosition();
        this.lastReadPath = stream.getCurrentPath();
        stream.reset();
    }

    private void handleEofException(Exception e) {
        if (e.getCause() instanceof EOFException && this.logQueue.size() > 1 && this.conf.getBoolean("replication.source.eof.autorecovery", false)) {
            try {
                if (this.fs.getFileStatus(this.logQueue.peek()).getLen() == 0L) {
                    LOG.warn((Object)("Forcing removal of 0 length log in queue: " + this.logQueue.peek()));
                    this.lastReadPath = (Path)this.logQueue.remove();
                    this.lastReadPosition = 0L;
                }
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Couldn't get file length information about log " + this.logQueue.peek()));
            }
        }
    }

    public Path getCurrentPath() {
        return this.logQueue.peek();
    }

    private WAL.Entry filterEntry(WAL.Entry entry) {
        WAL.Entry filtered = this.filter.filter(entry);
        if (entry != null && filtered == null) {
            this.metrics.incrLogEditsFiltered();
        }
        return filtered;
    }

    public WALEntryBatch take() throws InterruptedException {
        return this.entryBatchQueue.take();
    }

    public WALEntryBatch poll(long timeout) throws InterruptedException {
        return this.entryBatchQueue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    private long getEntrySize(WAL.Entry entry) {
        WALEdit edit = entry.getEdit();
        return edit.heapSize() + (long)this.calculateTotalSizeOfStoreFiles(edit);
    }

    private void updateBatchStats(WALEntryBatch batch, WAL.Entry entry, long entryPosition, long entrySize) {
        WALEdit edit = entry.getEdit();
        if (edit != null && !edit.isEmpty()) {
            batch.incrementHeapSize(entrySize);
            Pair<Integer, Integer> nbRowsAndHFiles = this.countDistinctRowKeysAndHFiles(edit);
            batch.incrementNbRowKeys((Integer)nbRowsAndHFiles.getFirst());
            batch.incrementNbHFiles((Integer)nbRowsAndHFiles.getSecond());
        }
        batch.lastWalPosition = entryPosition;
    }

    private Pair<Integer, Integer> countDistinctRowKeysAndHFiles(WALEdit edit) {
        ArrayList<Cell> cells = edit.getCells();
        int distinctRowKeys = 1;
        int totalHFileEntries = 0;
        Cell lastCell = (Cell)cells.get(0);
        int totalCells = edit.size();
        for (int i = 0; i < totalCells; ++i) {
            if (CellUtil.matchingQualifier((Cell)((Cell)cells.get(i)), (byte[])WALEdit.BULK_LOAD)) {
                try {
                    WALProtos.BulkLoadDescriptor bld = WALEdit.getBulkLoadDescriptor((Cell)cells.get(i));
                    List stores = bld.getStoresList();
                    int totalStores = stores.size();
                    for (int j = 0; j < totalStores; ++j) {
                        totalHFileEntries += ((WALProtos.StoreDescriptor)stores.get(j)).getStoreFileList().size();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed to deserialize bulk load entry from wal edit. Then its hfiles count will not be added into metric.");
                }
            }
            if (!CellUtil.matchingRow((Cell)((Cell)cells.get(i)), (Cell)lastCell)) {
                ++distinctRowKeys;
            }
            lastCell = (Cell)cells.get(i);
        }
        Pair result = new Pair((Object)distinctRowKeys, (Object)totalHFileEntries);
        return result;
    }

    private int calculateTotalSizeOfStoreFiles(WALEdit edit) {
        ArrayList<Cell> cells = edit.getCells();
        int totalStoreFilesSize = 0;
        int totalCells = edit.size();
        for (int i = 0; i < totalCells; ++i) {
            if (!CellUtil.matchingQualifier((Cell)((Cell)cells.get(i)), (byte[])WALEdit.BULK_LOAD)) continue;
            try {
                WALProtos.BulkLoadDescriptor bld = WALEdit.getBulkLoadDescriptor((Cell)cells.get(i));
                List stores = bld.getStoresList();
                int totalStores = stores.size();
                for (int j = 0; j < totalStores; ++j) {
                    totalStoreFilesSize = (int)((long)totalStoreFilesSize + ((WALProtos.StoreDescriptor)stores.get(j)).getStoreFileSizeBytes());
                }
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to deserialize bulk load entry from wal edit. Size of HFiles part of cell will not be considered in replication request size calculation.", (Throwable)e);
            }
        }
        return totalStoreFilesSize;
    }

    public boolean isReaderRunning() {
        return this.isReaderRunning && !this.isInterrupted();
    }

    public void setReaderRunning(boolean readerRunning) {
        this.isReaderRunning = readerRunning;
    }

    public long getLastReadPosition() {
        return this.lastReadPosition;
    }

    static class WALEntryBatch {
        private List<WAL.Entry> walEntries;
        private Path lastWalPath;
        private long lastWalPosition = 0L;
        private int nbRowKeys = 0;
        private int nbHFiles = 0;
        private long heapSize = 0L;
        private boolean moreEntries = true;

        private WALEntryBatch(int maxNbEntries) {
            this.walEntries = new ArrayList<WAL.Entry>(maxNbEntries);
        }

        public void addEntry(WAL.Entry entry) {
            this.walEntries.add(entry);
        }

        public List<WAL.Entry> getWalEntries() {
            return this.walEntries;
        }

        public Path getLastWalPath() {
            return this.lastWalPath;
        }

        public long getLastWalPosition() {
            return this.lastWalPosition;
        }

        public int getNbEntries() {
            return this.walEntries.size();
        }

        public int getNbRowKeys() {
            return this.nbRowKeys;
        }

        public int getNbHFiles() {
            return this.nbHFiles;
        }

        public int getNbOperations() {
            return this.getNbRowKeys() + this.getNbHFiles();
        }

        public long getHeapSize() {
            return this.heapSize;
        }

        private void incrementNbRowKeys(int increment) {
            this.nbRowKeys += increment;
        }

        private void incrementNbHFiles(int increment) {
            this.nbHFiles += increment;
        }

        private void incrementHeapSize(long increment) {
            this.heapSize += increment;
        }

        public boolean isEmpty() {
            return this.walEntries.isEmpty();
        }

        public void updatePosition(WALEntryStream entryStream) {
            this.lastWalPath = entryStream.getCurrentPath();
            this.lastWalPosition = entryStream.getPosition();
        }

        public boolean hasMoreEntries() {
            return this.moreEntries;
        }

        public void setMoreEntries(boolean moreEntries) {
            this.moreEntries = moreEntries;
        }
    }
}

