/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class LossyCounting {
    private long bucketSize;
    private int currentTerm;
    private Map<String, Integer> data;
    private long totalDataCount;
    private LossyCountingListener listener;

    LossyCounting(double errorRate) {
        this(errorRate, null);
    }

    public LossyCounting(double errorRate, LossyCountingListener listener) {
        if (errorRate < 0.0 || errorRate > 1.0) {
            throw new IllegalArgumentException(" Lossy Counting error rate should be within range [0,1]");
        }
        this.bucketSize = (long)Math.ceil(1.0 / errorRate);
        this.currentTerm = 1;
        this.totalDataCount = 0L;
        this.data = new ConcurrentHashMap<String, Integer>();
        this.listener = listener;
        this.calculateCurrentTerm();
    }

    LossyCounting(Configuration conf) {
        this(conf, null);
    }

    public LossyCounting(Configuration conf, LossyCountingListener listener) {
        this(conf.getDouble("hbase.util.default.lossycounting.errorrate", 0.02), listener);
    }

    private void addByOne(String key) {
        Integer i = this.data.get(key);
        if (i == null) {
            i = this.currentTerm != 0 ? this.currentTerm - 1 : 0;
        }
        this.data.put(key, i + 1);
        ++this.totalDataCount;
        this.calculateCurrentTerm();
    }

    public void add(String key) {
        this.addByOne(key);
        if (this.totalDataCount % this.bucketSize == 0L) {
            this.sweep();
        }
    }

    private void sweep() {
        for (Map.Entry<String, Integer> entry : this.data.entrySet()) {
            if (entry.getValue() >= this.currentTerm) continue;
            String metric = entry.getKey();
            this.data.remove(metric);
            if (this.listener == null) continue;
            this.listener.sweep(metric);
        }
    }

    private void calculateCurrentTerm() {
        this.currentTerm = (int)Math.ceil(1.0 * (double)this.totalDataCount / (double)this.bucketSize);
    }

    public long getBucketSize() {
        return this.bucketSize;
    }

    public long getDataSize() {
        return this.data.size();
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    public Set<String> getElements() {
        return this.data.keySet();
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }

    public static interface LossyCountingListener {
        public void sweep(String var1);
    }
}

