/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.master;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class AssignmentManagerStatusTmplImpl
extends AbstractTemplateImpl
implements AssignmentManagerStatusTmpl.Intf {
    private final AssignmentManager assignmentManager;
    private final int limit;

    protected static AssignmentManagerStatusTmpl.ImplData __jamon_setOptionalArguments(AssignmentManagerStatusTmpl.ImplData p_implData) {
        if (!p_implData.getLimit__IsNotDefault()) {
            p_implData.setLimit(Integer.MAX_VALUE);
        }
        return p_implData;
    }

    public AssignmentManagerStatusTmplImpl(TemplateManager p_templateManager, AssignmentManagerStatusTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)AssignmentManagerStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.assignmentManager = p_implData.getAssignmentManager();
        this.limit = p_implData.getLimit();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        SortedSet<RegionState> rit = this.assignmentManager.getRegionStates().getRegionsInTransitionOrderedByTimestamp();
        Map<String, AtomicInteger> failedRegionTracker = this.assignmentManager.getFailedOpenTracker();
        if (!rit.isEmpty()) {
            jamonWriter.write("\n");
            HashSet<String> ritsOverThreshold = new HashSet<String>();
            HashSet<String> ritsTwiceThreshold = new HashSet<String>();
            Configuration conf = HBaseConfiguration.create();
            int ritThreshold = conf.getInt("hbase.metrics.rit.stuck.warning.threshold", 60000);
            int numOfRITOverThreshold = 0;
            long currentTime = System.currentTimeMillis();
            ArrayList<RegionState> ritToDisplay = new ArrayList<RegionState>();
            int count = 0;
            for (RegionState rs : rit) {
                long ritTime = currentTime - rs.getStamp();
                if (ritTime > (long)(ritThreshold * 2)) {
                    ++numOfRITOverThreshold;
                    ritsTwiceThreshold.add(rs.getRegion().getEncodedName());
                } else if (ritTime > (long)ritThreshold) {
                    ++numOfRITOverThreshold;
                    ritsOverThreshold.add(rs.getRegion().getEncodedName());
                }
                if (count++ >= this.limit) continue;
                ritToDisplay.add(rs);
            }
            int numOfRITs = rit.size();
            int ritsPerPage = Math.min(5, numOfRITs);
            int numOfPages = (int)Math.ceil((double)numOfRITs * 1.0 / (double)ritsPerPage);
            jamonWriter.write("<section>\n    <h2>Regions in Transition</h2>\n     <p>");
            Escaping.HTML.write(StandardEmitter.valueOf((int)numOfRITs), jamonWriter);
            jamonWriter.write(" region(s) in transition.\n     ");
            if (!ritsTwiceThreshold.isEmpty()) {
                jamonWriter.write("\n         <span class=\"label label-danger\" style=\"font-size:100%;font-weight:normal\">\n     ");
            } else if (!ritsOverThreshold.isEmpty()) {
                jamonWriter.write("\n         <span class=\"label label-warning\" style=\"font-size:100%;font-weight:normal\">\n     ");
            } else {
                jamonWriter.write("\n         <span>\n     ");
            }
            jamonWriter.write("\n         ");
            Escaping.HTML.write(StandardEmitter.valueOf((int)numOfRITOverThreshold), jamonWriter);
            jamonWriter.write(" region(s) in transition for\n             more than ");
            Escaping.HTML.write(StandardEmitter.valueOf((int)ritThreshold), jamonWriter);
            jamonWriter.write(" milliseconds.\n         </span>\n     </p>\n     <div class=\"tabbable\">\n         <div class=\"tab-content\">\n         ");
            int recordItr = 0;
            for (RegionState rs : ritToDisplay) {
                jamonWriter.write("\n              ");
                if (recordItr % ritsPerPage == 0) {
                    jamonWriter.write("\n                  ");
                    if (recordItr == 0) {
                        jamonWriter.write("\n              <div class=\"tab-pane active\" id=\"tab_rits");
                        Escaping.HTML.write(StandardEmitter.valueOf((int)(recordItr / ritsPerPage + 1)), jamonWriter);
                        jamonWriter.write("\">\n                  ");
                    } else {
                        jamonWriter.write("\n              <div class=\"tab-pane\" id=\"tab_rits");
                        Escaping.HTML.write(StandardEmitter.valueOf((int)(recordItr / ritsPerPage + 1)), jamonWriter);
                        jamonWriter.write("\">\n                  ");
                    }
                    jamonWriter.write("\n                  <table class=\"table table-striped\" style=\"margin-bottom:0px;\"><tr><th>Region</th>\n                      <th>State</th><th>RIT time (ms)</th><th>Retries </th></tr>\n              ");
                }
                jamonWriter.write("\n\n              ");
                if (ritsOverThreshold.contains(rs.getRegion().getEncodedName())) {
                    jamonWriter.write("\n                      <tr class=\"alert alert-warning\" role=\"alert\">\n              ");
                } else if (ritsTwiceThreshold.contains(rs.getRegion().getEncodedName())) {
                    jamonWriter.write("\n                      <tr class=\"alert alert-danger\" role=\"alert\">\n              ");
                } else {
                    jamonWriter.write("\n                      <tr>\n              ");
                }
                jamonWriter.write("\n               ");
                String retryStatus = "0";
                AtomicInteger numOpenRetries = failedRegionTracker.get(rs.getRegion().getEncodedName());
                if (numOpenRetries != null) {
                    retryStatus = Integer.toString(numOpenRetries.get());
                } else if (rs.getState() == RegionState.State.FAILED_OPEN) {
                    retryStatus = "Failed";
                }
                jamonWriter.write("<td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)rs.getRegion().getEncodedName()), jamonWriter);
                jamonWriter.write("</td><td>\n              ");
                Escaping.HTML.write(StandardEmitter.valueOf((String)rs.toDescriptiveString()), jamonWriter);
                jamonWriter.write("</td>\n              <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((long)(currentTime - rs.getStamp())), jamonWriter);
                jamonWriter.write(" </td>\n              <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)retryStatus), jamonWriter);
                jamonWriter.write(" </td>\n              ");
                if (++recordItr % ritsPerPage == 0) {
                    jamonWriter.write("\n                 </table>\n              </div>\n              ");
                }
                jamonWriter.write("\n            ");
            }
            jamonWriter.write("\n         ");
            if (recordItr % ritsPerPage != 0) {
                jamonWriter.write("\n             ");
                while (recordItr % ritsPerPage != 0) {
                    jamonWriter.write("\n             <tr><td colspan=\"3\" style=\"height:61px\"></td></tr>\n             ");
                    ++recordItr;
                }
                jamonWriter.write("\n                   </table>\n             </div>\n         ");
            }
            jamonWriter.write("\n         </div>\n         <nav>\n             <ul class=\"nav nav-pills pagination\">\n             ");
            for (int i = 1; i <= numOfPages; ++i) {
                jamonWriter.write("\n                 ");
                if (i == 1) {
                    jamonWriter.write("\n                 <li class=\"active\">\n                 ");
                } else {
                    jamonWriter.write("\n                 <li>\n                 ");
                }
                jamonWriter.write("\n                 <a href=\"#tab_rits");
                Escaping.HTML.write(StandardEmitter.valueOf((int)i), jamonWriter);
                jamonWriter.write("\">");
                Escaping.HTML.write(StandardEmitter.valueOf((int)i), jamonWriter);
                jamonWriter.write("</a></li>\n             ");
            }
            jamonWriter.write("\n             </ul>\n         </nav>\n     </div>\n   </section>\n ");
        }
        jamonWriter.write("\n\n");
    }
}

