/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.wal.WAL;

@InterfaceAudience.Private
@VisibleForTesting
@SuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="Use of an atomic type both as monitor and condition variable is intended")
public class LogRoller
extends HasThread {
    private static final Log LOG = LogFactory.getLog(LogRoller.class);
    private final ReentrantLock rollLock = new ReentrantLock();
    private final AtomicBoolean rollLog = new AtomicBoolean(false);
    private final ConcurrentHashMap<WAL, Boolean> walNeedsRoll = new ConcurrentHashMap();
    private final Server server;
    protected final RegionServerServices services;
    private volatile long lastrolltime = System.currentTimeMillis();
    private final long rollperiod;
    private final int threadWakeFrequency;
    private long checkLowReplicationInterval;

    public void addWAL(final WAL wal) {
        if (null == this.walNeedsRoll.putIfAbsent(wal, Boolean.FALSE)) {
            wal.registerWALActionsListener(new WALActionsListener.Base(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void logRollRequested(boolean lowReplicas) {
                    LogRoller.this.walNeedsRoll.put(wal, Boolean.TRUE);
                    AtomicBoolean atomicBoolean = LogRoller.this.rollLog;
                    synchronized (atomicBoolean) {
                        LogRoller.this.rollLog.set(true);
                        LogRoller.this.rollLog.notifyAll();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRollAll() {
        for (WAL wal : this.walNeedsRoll.keySet()) {
            this.walNeedsRoll.put(wal, Boolean.TRUE);
        }
        AtomicBoolean atomicBoolean = this.rollLog;
        synchronized (atomicBoolean) {
            this.rollLog.set(true);
            this.rollLog.notifyAll();
        }
    }

    public LogRoller(Server server, RegionServerServices services) {
        super("LogRoller");
        this.server = server;
        this.services = services;
        this.rollperiod = this.server.getConfiguration().getLong("hbase.regionserver.logroll.period", 3600000L);
        this.threadWakeFrequency = this.server.getConfiguration().getInt("hbase.server.thread.wakefrequency", 10000);
        this.checkLowReplicationInterval = this.server.getConfiguration().getLong("hbase.regionserver.hlog.check.lowreplication.interval", 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        AtomicBoolean atomicBoolean = this.rollLog;
        synchronized (atomicBoolean) {
            this.rollLog.notify();
        }
        super.interrupt();
    }

    void checkLowReplication(long now) {
        try {
            for (Map.Entry<WAL, Boolean> entry : this.walNeedsRoll.entrySet()) {
                FSHLog hlog;
                WAL wal = entry.getKey();
                boolean neeRollAlready = entry.getValue();
                if (!(wal instanceof FSHLog) || neeRollAlready || now - (hlog = (FSHLog)wal).getLastTimeCheckLowReplication() <= this.checkLowReplicationInterval) continue;
                hlog.checkLogRoll();
            }
        }
        catch (Throwable e) {
            LOG.warn((Object)"Failed checking low replication", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.server.isStopped()) {
            long now = System.currentTimeMillis();
            this.checkLowReplication(now);
            boolean periodic = false;
            if (!this.rollLog.get()) {
                boolean bl = periodic = now - this.lastrolltime > this.rollperiod;
                if (!periodic) {
                    AtomicBoolean atomicBoolean = this.rollLog;
                    synchronized (atomicBoolean) {
                        try {
                            if (!this.rollLog.get()) {
                                this.rollLog.wait(this.threadWakeFrequency);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Wal roll period " + this.rollperiod + "ms elapsed"));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"WAL roll requested");
            }
            this.rollLock.lock();
            try {
                this.lastrolltime = now;
                for (Map.Entry<WAL, Boolean> entry : this.walNeedsRoll.entrySet()) {
                    WAL wal = entry.getKey();
                    byte[][] regionsToFlush = wal.rollWriter(periodic || entry.getValue() != false);
                    this.walNeedsRoll.put(wal, Boolean.FALSE);
                    if (regionsToFlush == null) continue;
                    for (byte[] r : regionsToFlush) {
                        this.scheduleFlush(r);
                    }
                }
            }
            catch (FailedLogCloseException e) {
                this.server.abort("Failed log close in log roller", e);
            }
            catch (ConnectException e) {
                this.server.abort("Failed log close in log roller", e);
            }
            catch (IOException ex) {
                LOG.fatal((Object)"Aborting", (Throwable)ex);
                this.server.abort("IOE in log roller", RemoteExceptionHandler.checkIOException((IOException)ex));
            }
            catch (Exception ex) {
                String msg = "Failed rolling WAL; aborting to recover edits!";
                LOG.error((Object)"Failed rolling WAL; aborting to recover edits!", (Throwable)ex);
                this.server.abort("Failed rolling WAL; aborting to recover edits!", ex);
            }
            finally {
                try {
                    this.rollLog.set(false);
                }
                finally {
                    this.rollLock.unlock();
                }
            }
        }
        LOG.info((Object)"LogRoller exiting.");
    }

    private void scheduleFlush(byte[] encodedRegionName) {
        boolean scheduled = false;
        Region r = this.services.getFromOnlineRegions(Bytes.toString((byte[])encodedRegionName));
        FlushRequester requester = null;
        if (r != null && (requester = this.services.getFlushRequester()) != null) {
            requester.requestFlush(r, true);
            scheduled = true;
        }
        if (!scheduled) {
            LOG.warn((Object)("Failed to schedule flush of " + Bytes.toString((byte[])encodedRegionName) + ", region=" + r + ", requester=" + requester));
        }
    }

    @VisibleForTesting
    public boolean walRollFinished() {
        for (boolean needRoll : this.walNeedsRoll.values()) {
            if (!needRoll) continue;
            return false;
        }
        return true;
    }
}

