/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class LossyCounting {
    private static final Logger LOG = LoggerFactory.getLogger(LossyCounting.class);
    private long bucketSize;
    private long currentTerm;
    private double errorRate;
    private Map<String, Integer> data;
    private long totalDataCount;

    public LossyCounting(double errorRate) {
        this.errorRate = errorRate;
        if (errorRate < 0.0 || errorRate > 1.0) {
            throw new IllegalArgumentException(" Lossy Counting error rate should be within range [0,1]");
        }
        this.bucketSize = (long)Math.ceil(1.0 / errorRate);
        this.currentTerm = 1L;
        this.totalDataCount = 0L;
        this.errorRate = errorRate;
        this.data = new ConcurrentHashMap<String, Integer>();
        this.calculateCurrentTerm();
    }

    public LossyCounting() {
        Configuration conf = HBaseConfiguration.create();
        this.errorRate = conf.getDouble("hbase.util.default.lossycounting.errorrate", 0.02);
        this.bucketSize = (long)Math.ceil(1.0 / this.errorRate);
        this.currentTerm = 1L;
        this.totalDataCount = 0L;
        this.data = new ConcurrentHashMap<String, Integer>();
        this.calculateCurrentTerm();
    }

    public Set<String> addByOne(String key) {
        if (this.data.containsKey(key)) {
            this.data.put(key, this.data.get(key) + 1);
        } else {
            this.data.put(key, 1);
        }
        ++this.totalDataCount;
        this.calculateCurrentTerm();
        Set<String> dataToBeSwept = new HashSet<String>();
        if (this.totalDataCount % this.bucketSize == 0L) {
            dataToBeSwept = this.sweep();
        }
        return dataToBeSwept;
    }

    private Set<String> sweep() {
        HashSet<String> dataToBeSwept = new HashSet<String>();
        for (Map.Entry<String, Integer> entry : this.data.entrySet()) {
            if (!((double)entry.getValue().intValue() + this.errorRate < (double)this.currentTerm)) continue;
            dataToBeSwept.add(entry.getKey());
        }
        for (String key : dataToBeSwept) {
            this.data.remove(key);
        }
        LOG.debug(String.format("Swept %d of elements.", dataToBeSwept.size()));
        return dataToBeSwept;
    }

    private void calculateCurrentTerm() {
        this.currentTerm = (int)Math.ceil(1.0 * (double)this.totalDataCount / (double)this.bucketSize);
    }

    public long getBuketSize() {
        return this.bucketSize;
    }

    public long getDataSize() {
        return this.data.size();
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }
}

