/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFromClientGetWithClosestRowBefore {
    private static final Logger LOG = Logger.getLogger(TestFromClientGetWithClosestRowBefore.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Configuration CONF;
    private static final TableName TEST_TABLE;
    private static final byte[] COLUMN_FAMILY;
    private static final Random RANDOM;

    @BeforeClass
    public static void setup() throws Exception {
        CONF = UTIL.getConfiguration();
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
        HColumnDescriptor hcd = new HColumnDescriptor(COLUMN_FAMILY);
        htd.addFamily(hcd);
        UTIL.getHBaseAdmin().createTable(htd);
    }

    @After
    public void tearDown() throws Exception {
        for (HTableDescriptor htd : UTIL.getHBaseAdmin().listTables()) {
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void testGetWithClosestRowBeforeWhenSplitRegion() throws Exception {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    UTIL.getHBaseAdmin().split(TEST_TABLE);
                }
                catch (Exception e) {
                    LOG.error((Object)"split region failed: ", (Throwable)e);
                }
            }
        };
        try (Connection conn = ConnectionFactory.createConnection((Configuration)CONF);){
            int i;
            try (Table table = conn.getTable(TEST_TABLE);){
                for (i = 0; i < 1000; ++i) {
                    byte[] data = Bytes.toBytes((String)String.format("%026d", i));
                    Put put = new Put(data).addColumn(COLUMN_FAMILY, null, data);
                    table.put(put);
                }
            }
            table = conn.getTable(TableName.META_TABLE_NAME);
            var5_7 = null;
            try {
                t.start();
                for (i = 0; i < 10000; ++i) {
                    Get get = new Get(Bytes.toBytes((String)(TEST_TABLE + ",,:"))).addFamily(Bytes.toBytes((String)"info")).setClosestRowBefore(true);
                    Result result = table.get(get);
                    if (Result.getTotalSizeOfCells((Result)result) != 0L) continue;
                    Assert.fail((String)"Get with closestRowBefore return NONE result.");
                }
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (table != null) {
                    if (var5_7 != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable x2) {
                            var5_7.addSuppressed(x2);
                        }
                    } else {
                        table.close();
                    }
                }
            }
        }
    }

    @Test
    public void testClosestRowIsLatestPutRow() throws IOException {
        final int[] initialRowkeys = new int[]{1, 1000};
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    byte[] value = new byte[524288];
                    for (int i = 0; i < value.length; ++i) {
                        value[i] = (byte)RANDOM.nextInt(256);
                    }
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)CONF);
                         Table table = conn.getTable(TEST_TABLE);){
                        for (int i = initialRowkeys[0] + 1; i < initialRowkeys[1]; ++i) {
                            byte[] data = Bytes.toBytes((String)String.format("%026d", i));
                            Put put = new Put(data).addColumn(COLUMN_FAMILY, null, value);
                            table.put(put);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Put huge value into table failed: ", (Throwable)e);
                }
            }
        };
        try (Connection conn = ConnectionFactory.createConnection((Configuration)CONF);
             Table table = conn.getTable(TEST_TABLE);){
            for (int i = 0; i < initialRowkeys.length; ++i) {
                byte[] rowKey = Bytes.toBytes((String)String.format("%026d", initialRowkeys[i]));
                Put put = new Put(rowKey).addColumn(COLUMN_FAMILY, null, rowKey);
                table.put(put);
            }
            t.start();
            byte[] rowKey = Bytes.toBytes((String)String.format("%026d", initialRowkeys[1] - 1));
            for (int i = 0; i < 1000; ++i) {
                Get get = new Get(rowKey).addFamily(COLUMN_FAMILY).setClosestRowBefore(true);
                Result result = table.get(get);
                if (Result.getTotalSizeOfCells((Result)result) != 0L) continue;
                Assert.fail((String)"Get with closestRowBefore return NONE result.");
            }
        }
    }

    static {
        TEST_TABLE = TableName.valueOf((String)"test_table");
        COLUMN_FAMILY = Bytes.toBytes((String)"f1");
        RANDOM = new Random();
    }
}

