/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HeapMemStoreLAB;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestDefaultMemStore
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestDefaultMemStore.class);
    private DefaultMemStore memstore;
    private static final int ROW_COUNT = 10;
    private static final int QUALIFIER_COUNT = 10;
    private static final byte[] FAMILY = Bytes.toBytes((String)"column");
    private MultiVersionConcurrencyControl mvcc;
    private AtomicLong startSeqNum = new AtomicLong(0L);

    public void setUp() throws Exception {
        super.setUp();
        this.mvcc = new MultiVersionConcurrencyControl();
        this.memstore = new DefaultMemStore();
    }

    public void testPutSameKey() {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        KeyValue kv = new KeyValue(bytes, bytes, bytes, bytes);
        this.memstore.add((Cell)kv);
        byte[] other = Bytes.toBytes((String)"somethingelse");
        KeyValue samekey = new KeyValue(bytes, bytes, bytes, other);
        this.memstore.add((Cell)samekey);
        Cell found = this.memstore.activeSection.getCellSkipListSet().first();
        TestDefaultMemStore.assertEquals((int)1, (int)this.memstore.activeSection.getCellSkipListSet().size());
        TestDefaultMemStore.assertTrue((String)Bytes.toString((byte[])found.getValue()), (boolean)CellUtil.matchingValue((Cell)samekey, (Cell)found));
    }

    public void testPutSameCell() {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        KeyValue kv = new KeyValue(bytes, bytes, bytes, bytes);
        long sizeChangeForFirstCell = this.memstore.add((Cell)kv);
        long sizeChangeForSecondCell = this.memstore.add((Cell)kv);
        TestDefaultMemStore.assertEquals((long)DefaultMemStore.heapSizeChange((Cell)kv, (boolean)true), (long)sizeChangeForFirstCell);
        if (this.memstore.activeSection.getMemStoreLAB() != null) {
            TestDefaultMemStore.assertEquals((long)this.memstore.getCellLength((Cell)kv), (long)sizeChangeForSecondCell);
            if (this.memstore.activeSection.getMemStoreLAB() instanceof HeapMemStoreLAB) {
                TestDefaultMemStore.assertEquals((int)(2 * this.memstore.getCellLength((Cell)kv)), (int)((HeapMemStoreLAB)this.memstore.activeSection.getMemStoreLAB()).getCurrentChunk().getNextFreeOffset());
            }
        } else {
            TestDefaultMemStore.assertEquals((long)0L, (long)sizeChangeForSecondCell);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScanAcrossSnapshot() throws IOException {
        int rowCount = this.addRows((MemStore)this.memstore);
        List memstorescanners = this.memstore.getScanners(0L);
        Scan scan = new Scan();
        ArrayList result = new ArrayList();
        Configuration conf = HBaseConfiguration.create();
        ScanInfo scanInfo = new ScanInfo(conf, null, 0, 1, Long.MAX_VALUE, KeepDeletedCells.FALSE, 0L, this.memstore.comparator);
        ScanType scanType = ScanType.USER_SCAN;
        int count = 0;
        try (StoreScanner s = new StoreScanner(scan, scanInfo, scanType, null, memstorescanners);){
            while (s.next(result)) {
                LOG.info(result);
                ++count;
                TestDefaultMemStore.assertEquals((int)rowCount, (int)result.size());
                result.clear();
            }
        }
        TestDefaultMemStore.assertEquals((int)rowCount, (int)count);
        for (KeyValueScanner scanner : memstorescanners) {
            scanner.close();
        }
        memstorescanners = this.memstore.getScanners(this.mvcc.getReadPoint());
        s = new StoreScanner(scan, scanInfo, scanType, null, memstorescanners);
        count = 0;
        try {
            while (s.next(result)) {
                LOG.info(result);
                TestDefaultMemStore.assertTrue((boolean)CellUtil.matchingRow((Cell)((Cell)result.get(0)), (byte[])Bytes.toBytes((int)count)));
                TestDefaultMemStore.assertEquals((int)rowCount, (int)result.size());
                if (++count == 2) {
                    this.memstore.snapshot();
                    LOG.info((Object)"Snapshotted");
                }
                result.clear();
            }
        }
        finally {
            s.close();
        }
        TestDefaultMemStore.assertEquals((int)rowCount, (int)count);
        for (KeyValueScanner scanner : memstorescanners) {
            scanner.close();
        }
        memstorescanners = this.memstore.getScanners(this.mvcc.getReadPoint());
        long ts = System.currentTimeMillis();
        s = new StoreScanner(scan, scanInfo, scanType, null, memstorescanners);
        count = 0;
        int snapshotIndex = 5;
        try {
            while (s.next(result)) {
                LOG.info(result);
                TestDefaultMemStore.assertTrue((boolean)CellUtil.matchingRow((Cell)((Cell)result.get(0)), (byte[])Bytes.toBytes((int)count)));
                TestDefaultMemStore.assertEquals((String)("count=" + count + ", result=" + result), (int)rowCount, (int)result.size());
                if (++count == snapshotIndex) {
                    MemStoreSnapshot snapshot = this.memstore.snapshot();
                    this.memstore.clearSnapshot(snapshot.getId());
                    this.addRows((MemStore)this.memstore, ts);
                    LOG.info((Object)"Snapshotted, cleared it and then added values (which wont be seen)");
                }
                result.clear();
            }
        }
        finally {
            s.close();
        }
        TestDefaultMemStore.assertEquals((int)rowCount, (int)count);
    }

    public void testScanAcrossSnapshot2() throws IOException, CloneNotSupportedException {
        byte[] one = Bytes.toBytes((int)1);
        byte[] two = Bytes.toBytes((int)2);
        byte[] f = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        byte[] v = Bytes.toBytes((int)3);
        KeyValue kv1 = new KeyValue(one, f, q, v);
        KeyValue kv2 = new KeyValue(two, f, q, v);
        this.memstore.add((Cell)kv1.clone());
        this.memstore.add((Cell)kv2.clone());
        this.verifyScanAcrossSnapshot2(kv1, kv2);
        this.memstore.snapshot();
        this.verifyScanAcrossSnapshot2(kv1, kv2);
        this.memstore = new DefaultMemStore();
        this.memstore.add((Cell)kv1.clone());
        this.memstore.snapshot();
        this.memstore.add((Cell)kv2.clone());
        this.verifyScanAcrossSnapshot2(kv1, kv2);
    }

    private void verifyScanAcrossSnapshot2(KeyValue kv1, KeyValue kv2) throws IOException {
        List memstorescanners = this.memstore.getScanners(this.mvcc.getReadPoint());
        TestDefaultMemStore.assertEquals((int)1, (int)memstorescanners.size());
        KeyValueScanner scanner = (KeyValueScanner)memstorescanners.get(0);
        scanner.seek((Cell)KeyValueUtil.createFirstOnRow((byte[])HConstants.EMPTY_START_ROW));
        TestDefaultMemStore.assertEquals((Object)kv1, (Object)scanner.next());
        TestDefaultMemStore.assertEquals((Object)kv2, (Object)scanner.next());
        TestDefaultMemStore.assertNull((Object)scanner.next());
    }

    private void assertScannerResults(KeyValueScanner scanner, KeyValue[] expected) throws IOException {
        Cell next;
        scanner.seek((Cell)KeyValueUtil.createFirstOnRow((byte[])new byte[0]));
        ArrayList returned = Lists.newArrayList();
        while ((next = scanner.next()) != null) {
            returned.add(next);
        }
        TestDefaultMemStore.assertTrue((String)("Got:\n" + Joiner.on((String)"\n").join((Iterable)returned) + "\nExpected:\n" + Joiner.on((String)"\n").join((Object[])expected)), (boolean)Iterables.elementsEqual(Arrays.asList(expected), (Iterable)returned));
        TestDefaultMemStore.assertNull((Object)scanner.peek());
    }

    public void testMemstoreConcurrentControl() throws IOException {
        byte[] row = Bytes.toBytes((int)1);
        byte[] f = Bytes.toBytes((String)"family");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] v = Bytes.toBytes((String)"value");
        MultiVersionConcurrencyControl.WriteEntry w = this.mvcc.begin();
        KeyValue kv1 = new KeyValue(row, f, q1, v);
        kv1.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv1);
        TestDefaultMemStore.assertTrue((this.memstore.getScanners(this.mvcc.getReadPoint()) == null ? 1 : 0) != 0);
        this.mvcc.completeAndWait(w);
        KeyValueScanner s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv1});
        w = this.mvcc.begin();
        KeyValue kv2 = new KeyValue(row, f, q2, v);
        kv2.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv2);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv1});
        this.mvcc.completeAndWait(w);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv1, kv2});
    }

    public void testMemstoreEditsVisibilityWithSameKey() throws IOException {
        byte[] row = Bytes.toBytes((int)1);
        byte[] f = Bytes.toBytes((String)"family");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] v1 = Bytes.toBytes((String)"value1");
        byte[] v2 = Bytes.toBytes((String)"value2");
        MultiVersionConcurrencyControl.WriteEntry w = this.mvcc.begin();
        KeyValue kv11 = new KeyValue(row, f, q1, v1);
        kv11.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv11);
        KeyValue kv12 = new KeyValue(row, f, q2, v1);
        kv12.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv12);
        this.mvcc.completeAndWait(w);
        KeyValueScanner s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kv12});
        w = this.mvcc.begin();
        KeyValue kv21 = new KeyValue(row, f, q1, v2);
        kv21.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv21);
        KeyValue kv22 = new KeyValue(row, f, q2, v2);
        kv22.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv22);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kv12});
        this.mvcc.completeAndWait(w);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv21, kv11, kv22, kv12});
    }

    public void testMemstoreDeletesVisibilityWithSameKey() throws IOException {
        byte[] row = Bytes.toBytes((int)1);
        byte[] f = Bytes.toBytes((String)"family");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] v1 = Bytes.toBytes((String)"value1");
        MultiVersionConcurrencyControl.WriteEntry w = this.mvcc.begin();
        KeyValue kv11 = new KeyValue(row, f, q1, v1);
        kv11.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv11);
        KeyValue kv12 = new KeyValue(row, f, q2, v1);
        kv12.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv12);
        this.mvcc.completeAndWait(w);
        KeyValueScanner s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kv12});
        w = this.mvcc.begin();
        KeyValue kvDel = new KeyValue(row, f, q2, kv11.getTimestamp(), KeyValue.Type.DeleteColumn);
        kvDel.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kvDel);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kv12});
        this.mvcc.completeAndWait(w);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kvDel, kv12});
    }

    public void testReadOwnWritesUnderConcurrency() throws Throwable {
        int i;
        int NUM_THREADS = 8;
        ReadOwnWritesTester[] threads = new ReadOwnWritesTester[NUM_THREADS];
        AtomicReference<Throwable> caught = new AtomicReference<Throwable>();
        for (i = 0; i < NUM_THREADS; ++i) {
            threads[i] = new ReadOwnWritesTester(i, (MemStore)this.memstore, this.mvcc, caught, this.startSeqNum);
            threads[i].start();
        }
        for (i = 0; i < NUM_THREADS; ++i) {
            threads[i].join();
        }
        if (caught.get() != null) {
            throw (Throwable)caught.get();
        }
    }

    public void testSnapshotting() throws IOException {
        int snapshotCount = 5;
        for (int i = 0; i < 5; ++i) {
            this.addRows((MemStore)this.memstore);
            this.runSnapshot(this.memstore);
            TestDefaultMemStore.assertEquals((String)"History not being cleared", (int)0, (int)this.memstore.snapshotSection.getCellSkipListSet().size());
        }
    }

    public void testMultipleVersionsSimple() throws Exception {
        DefaultMemStore m = new DefaultMemStore(new Configuration(), KeyValue.COMPARATOR);
        byte[] row = Bytes.toBytes((String)"testRow");
        byte[] family = Bytes.toBytes((String)"testFamily");
        byte[] qf = Bytes.toBytes((String)"testQualifier");
        long[] stamps = new long[]{1L, 2L, 3L};
        byte[][] values = new byte[][]{Bytes.toBytes((String)"value0"), Bytes.toBytes((String)"value1"), Bytes.toBytes((String)"value2")};
        KeyValue key0 = new KeyValue(row, family, qf, stamps[0], values[0]);
        KeyValue key1 = new KeyValue(row, family, qf, stamps[1], values[1]);
        KeyValue key2 = new KeyValue(row, family, qf, stamps[2], values[2]);
        m.add((Cell)key0);
        m.add((Cell)key1);
        m.add((Cell)key2);
        TestDefaultMemStore.assertTrue((String)("Expected memstore to hold 3 values, actually has " + m.activeSection.getCellSkipListSet().size()), (m.activeSection.getCellSkipListSet().size() == 3 ? 1 : 0) != 0);
    }

    public void testGetNextRow() throws Exception {
        this.addRows((MemStore)this.memstore);
        Thread.sleep(1L);
        this.addRows((MemStore)this.memstore);
        Cell closestToEmpty = this.memstore.getNextRow((Cell)KeyValue.LOWESTKEY);
        TestDefaultMemStore.assertTrue((KeyValue.COMPARATOR.compareRows(closestToEmpty, (Cell)new KeyValue(Bytes.toBytes((int)0), System.currentTimeMillis())) == 0 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            Cell nr = this.memstore.getNextRow((Cell)new KeyValue(Bytes.toBytes((int)i), System.currentTimeMillis()));
            if (i + 1 == 10) {
                TestDefaultMemStore.assertEquals((Object)nr, null);
                continue;
            }
            TestDefaultMemStore.assertTrue((KeyValue.COMPARATOR.compareRows(nr, (Cell)new KeyValue(Bytes.toBytes((int)(i + 1)), System.currentTimeMillis())) == 0 ? 1 : 0) != 0);
        }
        Configuration conf = HBaseConfiguration.create();
        for (int startRowId = 0; startRowId < 10; ++startRowId) {
            ScanInfo scanInfo = new ScanInfo(conf, FAMILY, 0, 1, Integer.MAX_VALUE, KeepDeletedCells.FALSE, 0L, this.memstore.comparator);
            ScanType scanType = ScanType.USER_SCAN;
            StoreScanner scanner = new StoreScanner(new Scan(Bytes.toBytes((int)startRowId)), scanInfo, scanType, null, this.memstore.getScanners(0L));
            ArrayList results = new ArrayList();
            int i = 0;
            while (scanner.next(results)) {
                int rowId = startRowId + i;
                Cell left = (Cell)results.get(0);
                byte[] row1 = Bytes.toBytes((int)rowId);
                TestDefaultMemStore.assertTrue((String)"Row name", (KeyValue.COMPARATOR.compareRows(left.getRowArray(), left.getRowOffset(), (int)left.getRowLength(), row1, 0, row1.length) == 0 ? 1 : 0) != 0);
                TestDefaultMemStore.assertEquals((String)"Count of columns", (int)10, (int)results.size());
                ArrayList<Cell> row = new ArrayList<Cell>();
                for (Cell kv : results) {
                    row.add(kv);
                }
                this.isExpectedRowWithoutTimestamps(rowId, row);
                results.clear();
                ++i;
            }
        }
    }

    public void testGet_memstoreAndSnapShot() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] val = Bytes.toBytes((String)"testval");
        this.memstore.add((Cell)new KeyValue(row, fam, qf1, val));
        this.memstore.add((Cell)new KeyValue(row, fam, qf2, val));
        this.memstore.add((Cell)new KeyValue(row, fam, qf3, val));
        this.memstore.snapshot();
        TestDefaultMemStore.assertEquals((int)3, (int)this.memstore.snapshotSection.getCellSkipListSet().size());
        TestDefaultMemStore.assertEquals((int)0, (int)this.memstore.activeSection.getCellSkipListSet().size());
        this.memstore.add((Cell)new KeyValue(row, fam, qf4, val));
        this.memstore.add((Cell)new KeyValue(row, fam, qf5, val));
        TestDefaultMemStore.assertEquals((int)2, (int)this.memstore.activeSection.getCellSkipListSet().size());
    }

    public void testGetWithDelete() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier");
        byte[] val = Bytes.toBytes((String)"testval");
        long ts1 = System.nanoTime();
        KeyValue put1 = new KeyValue(row, fam, qf1, ts1, val);
        long ts2 = ts1 + 1L;
        KeyValue put2 = new KeyValue(row, fam, qf1, ts2, val);
        long ts3 = ts2 + 1L;
        KeyValue put3 = new KeyValue(row, fam, qf1, ts3, val);
        this.memstore.add((Cell)put1);
        this.memstore.add((Cell)put2);
        this.memstore.add((Cell)put3);
        TestDefaultMemStore.assertEquals((int)3, (int)this.memstore.activeSection.getCellSkipListSet().size());
        KeyValue del2 = new KeyValue(row, fam, qf1, ts2, KeyValue.Type.Delete, val);
        this.memstore.delete((Cell)del2);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(put3);
        expected.add(del2);
        expected.add(put2);
        expected.add(put1);
        TestDefaultMemStore.assertEquals((int)4, (int)this.memstore.activeSection.getCellSkipListSet().size());
        int i = 0;
        for (Cell cell : this.memstore.activeSection.getCellSkipListSet()) {
            TestDefaultMemStore.assertEquals(expected.get(i++), (Object)cell);
        }
    }

    public void testGetWithDeleteColumn() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier");
        byte[] val = Bytes.toBytes((String)"testval");
        long ts1 = System.nanoTime();
        KeyValue put1 = new KeyValue(row, fam, qf1, ts1, val);
        long ts2 = ts1 + 1L;
        KeyValue put2 = new KeyValue(row, fam, qf1, ts2, val);
        long ts3 = ts2 + 1L;
        KeyValue put3 = new KeyValue(row, fam, qf1, ts3, val);
        this.memstore.add((Cell)put1);
        this.memstore.add((Cell)put2);
        this.memstore.add((Cell)put3);
        TestDefaultMemStore.assertEquals((int)3, (int)this.memstore.activeSection.getCellSkipListSet().size());
        KeyValue del2 = new KeyValue(row, fam, qf1, ts2, KeyValue.Type.DeleteColumn, val);
        this.memstore.delete((Cell)del2);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(put3);
        expected.add(del2);
        expected.add(put2);
        expected.add(put1);
        TestDefaultMemStore.assertEquals((int)4, (int)this.memstore.activeSection.getCellSkipListSet().size());
        int i = 0;
        for (Cell cell : this.memstore.activeSection.getCellSkipListSet()) {
            TestDefaultMemStore.assertEquals(expected.get(i++), (Object)cell);
        }
    }

    public void testGetWithDeleteFamily() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] val = Bytes.toBytes((String)"testval");
        long ts = System.nanoTime();
        KeyValue put1 = new KeyValue(row, fam, qf1, ts, val);
        KeyValue put2 = new KeyValue(row, fam, qf2, ts, val);
        KeyValue put3 = new KeyValue(row, fam, qf3, ts, val);
        KeyValue put4 = new KeyValue(row, fam, qf3, ts + 1L, val);
        this.memstore.add((Cell)put1);
        this.memstore.add((Cell)put2);
        this.memstore.add((Cell)put3);
        this.memstore.add((Cell)put4);
        KeyValue del = new KeyValue(row, fam, null, ts, KeyValue.Type.DeleteFamily, val);
        this.memstore.delete((Cell)del);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(del);
        expected.add(put1);
        expected.add(put2);
        expected.add(put4);
        expected.add(put3);
        TestDefaultMemStore.assertEquals((int)5, (int)this.memstore.activeSection.getCellSkipListSet().size());
        int i = 0;
        for (Cell cell : this.memstore.activeSection.getCellSkipListSet()) {
            TestDefaultMemStore.assertEquals(expected.get(i++), (Object)cell);
        }
    }

    public void testKeepDeleteInmemstore() {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf = Bytes.toBytes((String)"testqualifier");
        byte[] val = Bytes.toBytes((String)"testval");
        long ts = System.nanoTime();
        this.memstore.add((Cell)new KeyValue(row, fam, qf, ts, val));
        KeyValue delete = new KeyValue(row, fam, qf, ts, KeyValue.Type.Delete, val);
        this.memstore.delete((Cell)delete);
        TestDefaultMemStore.assertEquals((int)2, (int)this.memstore.activeSection.getCellSkipListSet().size());
        TestDefaultMemStore.assertEquals((Object)delete, (Object)this.memstore.activeSection.getCellSkipListSet().first());
    }

    public void testRetainsDeleteVersion() throws IOException {
        this.memstore.add((Cell)KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (String)"dont-care"));
        KeyValue delete = KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care");
        this.memstore.delete((Cell)delete);
        TestDefaultMemStore.assertEquals((int)2, (int)this.memstore.activeSection.getCellSkipListSet().size());
        TestDefaultMemStore.assertEquals((Object)delete, (Object)this.memstore.activeSection.getCellSkipListSet().first());
    }

    public void testRetainsDeleteColumn() throws IOException {
        this.memstore.add((Cell)KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (String)"dont-care"));
        KeyValue delete = KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care");
        this.memstore.delete((Cell)delete);
        TestDefaultMemStore.assertEquals((int)2, (int)this.memstore.activeSection.getCellSkipListSet().size());
        TestDefaultMemStore.assertEquals((Object)delete, (Object)this.memstore.activeSection.getCellSkipListSet().first());
    }

    public void testRetainsDeleteFamily() throws IOException {
        this.memstore.add((Cell)KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (String)"dont-care"));
        KeyValue delete = KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (KeyValue.Type)KeyValue.Type.DeleteFamily, (String)"dont-care");
        this.memstore.delete((Cell)delete);
        TestDefaultMemStore.assertEquals((int)2, (int)this.memstore.activeSection.getCellSkipListSet().size());
        TestDefaultMemStore.assertEquals((Object)delete, (Object)this.memstore.activeSection.getCellSkipListSet().first());
    }

    public void testMultipleTimestamps() throws Exception {
        long[] timestamps = new long[]{20L, 10L, 5L, 1L};
        Scan scan = new Scan();
        for (long timestamp : timestamps) {
            this.addRows((MemStore)this.memstore, timestamp);
        }
        byte[] fam = Bytes.toBytes((String)"fam");
        HColumnDescriptor hcd = (HColumnDescriptor)Mockito.mock(HColumnDescriptor.class);
        Mockito.when((Object)hcd.getName()).thenReturn((Object)fam);
        Store store = (Store)Mockito.mock(Store.class);
        Mockito.when((Object)store.getFamily()).thenReturn((Object)hcd);
        scan.setColumnFamilyTimeRange(fam, 0L, 2L);
        TestDefaultMemStore.assertTrue((boolean)this.memstore.shouldSeek(scan, store, Long.MIN_VALUE));
        scan.setColumnFamilyTimeRange(fam, 20L, 82L);
        TestDefaultMemStore.assertTrue((boolean)this.memstore.shouldSeek(scan, store, Long.MIN_VALUE));
        scan.setColumnFamilyTimeRange(fam, 10L, 20L);
        TestDefaultMemStore.assertTrue((boolean)this.memstore.shouldSeek(scan, store, Long.MIN_VALUE));
        scan.setColumnFamilyTimeRange(fam, 8L, 12L);
        TestDefaultMemStore.assertTrue((boolean)this.memstore.shouldSeek(scan, store, Long.MIN_VALUE));
        scan.setColumnFamilyTimeRange(fam, 28L, 42L);
        TestDefaultMemStore.assertTrue((!this.memstore.shouldSeek(scan, store, Long.MIN_VALUE) ? 1 : 0) != 0);
    }

    public void testUpsertMSLAB() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.hregion.memstore.mslab.enabled", true);
        this.memstore = new DefaultMemStore(conf, KeyValue.COMPARATOR);
        int ROW_SIZE = 2048;
        byte[] qualifier = new byte[ROW_SIZE - 4];
        MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
        for (int i = 0; i < 3; ++i) {
            System.gc();
        }
        long usageBefore = bean.getHeapMemoryUsage().getUsed();
        long size = 0L;
        long ts = 0L;
        for (int newValue = 0; newValue < 1000; ++newValue) {
            for (int row = newValue; row < newValue + 1000; ++row) {
                byte[] rowBytes = Bytes.toBytes((int)row);
                size += this.memstore.updateColumnValue(rowBytes, FAMILY, qualifier, (long)newValue, ++ts);
            }
        }
        System.out.println("Wrote " + ts + " vals");
        for (int i = 0; i < 3; ++i) {
            System.gc();
        }
        long usageAfter = bean.getHeapMemoryUsage().getUsed();
        System.out.println("Memory used: " + (usageAfter - usageBefore) + " (heapsize: " + this.memstore.heapSize() + " size: " + size + ")");
    }

    private static byte[] makeQualifier(int i1, int i2) {
        return Bytes.toBytes((String)(Integer.toString(i1) + ";" + Integer.toString(i2)));
    }

    public void testUpsertMemstoreSize() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        this.memstore = new DefaultMemStore(conf, KeyValue.COMPARATOR);
        long oldSize = this.memstore.activeSection.getHeapSize().get();
        ArrayList<KeyValue> l = new ArrayList<KeyValue>();
        KeyValue kv1 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v");
        KeyValue kv2 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)101L, (String)"v");
        KeyValue kv3 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)102L, (String)"v");
        kv1.setSequenceId(1L);
        kv2.setSequenceId(1L);
        kv3.setSequenceId(1L);
        l.add(kv1);
        l.add(kv2);
        l.add(kv3);
        this.memstore.upsert(l, 2L, null);
        long newSize = this.memstore.activeSection.getHeapSize().get();
        assert (newSize > oldSize);
        assert (this.memstore.activeSection.getCellSkipListSet().size() == 2);
        KeyValue kv4 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)104L, (String)"v");
        kv4.setSequenceId(1L);
        l.clear();
        l.add(kv4);
        this.memstore.upsert(l, 3L, null);
        TestDefaultMemStore.assertEquals((long)newSize, (long)this.memstore.activeSection.getHeapSize().get());
        assert (this.memstore.activeSection.getCellSkipListSet().size() == 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateToTimeOfOldestEdit() throws Exception {
        try {
            EnvironmentEdgeForMemstoreTest edge = new EnvironmentEdgeForMemstoreTest();
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
            DefaultMemStore memstore = new DefaultMemStore();
            long t = memstore.timeOfOldestEdit();
            TestDefaultMemStore.assertEquals((long)t, (long)Long.MAX_VALUE);
            memstore.add((Cell)KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v"));
            t = memstore.timeOfOldestEdit();
            TestDefaultMemStore.assertTrue((t == 1234L ? 1 : 0) != 0);
            t = this.runSnapshot(memstore);
            memstore.delete((Cell)KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v"));
            t = memstore.timeOfOldestEdit();
            TestDefaultMemStore.assertTrue((t == 1234L ? 1 : 0) != 0);
            t = this.runSnapshot(memstore);
            ArrayList<KeyValue> l = new ArrayList<KeyValue>();
            KeyValue kv1 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v");
            kv1.setSequenceId(100L);
            l.add(kv1);
            memstore.upsert(l, 1000L, null);
            t = memstore.timeOfOldestEdit();
            TestDefaultMemStore.assertTrue((t == 1234L ? 1 : 0) != 0);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    public void testShouldFlush() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hbase.regionserver.optionalcacheflushinterval", 1000);
        this.checkShouldFlush(conf, true);
        conf.setInt("hbase.regionserver.optionalcacheflushinterval", 0);
        this.checkShouldFlush(conf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShouldFlush(Configuration conf, boolean expected) throws Exception {
        try {
            EnvironmentEdgeForMemstoreTest edge = new EnvironmentEdgeForMemstoreTest();
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
            HBaseTestingUtility hbaseUtility = HBaseTestingUtility.createLocalHTU(conf);
            HRegion region = hbaseUtility.createTestRegion("foobar", new HColumnDescriptor("foo"));
            List stores = region.getStores();
            TestDefaultMemStore.assertTrue((stores.size() == 1 ? 1 : 0) != 0);
            Store s = (Store)stores.iterator().next();
            edge.setCurrentTimeMillis(1234L);
            s.add((Cell)KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v"));
            edge.setCurrentTimeMillis(1334L);
            StringBuffer sb = new StringBuffer();
            TestDefaultMemStore.assertTrue((!region.shouldFlush(sb) ? 1 : 0) != 0);
            edge.setCurrentTimeMillis(11234L);
            TestDefaultMemStore.assertTrue((region.shouldFlush(sb) == expected ? 1 : 0) != 0);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    public void testShouldFlushMeta() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hbase.regionserver.optionalcacheflushinterval", 3000000);
        HBaseTestingUtility hbaseUtility = HBaseTestingUtility.createLocalHTU(conf);
        Path testDir = hbaseUtility.getDataTestDir();
        EnvironmentEdgeForMemstoreTest edge = new EnvironmentEdgeForMemstoreTest();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        edge.setCurrentTimeMillis(1234L);
        WALFactory wFactory = new WALFactory(conf, null, "1234");
        HRegion meta = HRegion.createHRegion((HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (Path)testDir, (Configuration)conf, (HTableDescriptor)HTableDescriptor.metaTableDescriptor((Configuration)conf), (WAL)wFactory.getMetaWAL(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes()));
        HRegionInfo hri = new HRegionInfo(TableName.valueOf((String)"testShouldFlushMeta"), Bytes.toBytes((String)"row_0200"), Bytes.toBytes((String)"row_0300"));
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)"testShouldFlushMeta"));
        desc.addFamily(new HColumnDescriptor("foo".getBytes()));
        HRegion r = HRegion.createHRegion((HRegionInfo)hri, (Path)testDir, (Configuration)conf, (HTableDescriptor)desc, (WAL)wFactory.getWAL(hri.getEncodedNameAsBytes(), hri.getTable().getNamespace()));
        HRegion.addRegionToMETA((HRegion)meta, (HRegion)r);
        edge.setCurrentTimeMillis(1334L);
        StringBuffer sb = new StringBuffer();
        TestDefaultMemStore.assertTrue((!meta.shouldFlush(sb) ? 1 : 0) != 0);
        edge.setCurrentTimeMillis(edge.currentTime() + 300000L + 1L);
        TestDefaultMemStore.assertTrue((meta.shouldFlush(sb) ? 1 : 0) != 0);
    }

    private int addRows(MemStore hmc) {
        return this.addRows(hmc, Long.MAX_VALUE);
    }

    private int addRows(MemStore hmc, long ts) {
        for (int i = 0; i < 10; ++i) {
            long timestamp = ts == Long.MAX_VALUE ? System.currentTimeMillis() : ts;
            for (int ii = 0; ii < 10; ++ii) {
                byte[] row = Bytes.toBytes((int)i);
                byte[] qf = TestDefaultMemStore.makeQualifier(i, ii);
                hmc.add((Cell)new KeyValue(row, FAMILY, qf, timestamp, qf));
            }
        }
        return 10;
    }

    private long runSnapshot(DefaultMemStore hmc) throws UnexpectedStateException {
        int oldHistorySize = hmc.snapshotSection.getCellSkipListSet().size();
        MemStoreSnapshot snapshot = hmc.snapshot();
        TestDefaultMemStore.assertTrue((String)"History size has not increased", (oldHistorySize < hmc.snapshotSection.getCellSkipListSet().size() ? 1 : 0) != 0);
        long t = this.memstore.timeOfOldestEdit();
        TestDefaultMemStore.assertTrue((String)"Time of oldest edit is not Long.MAX_VALUE", (t == Long.MAX_VALUE ? 1 : 0) != 0);
        hmc.clearSnapshot(snapshot.getId());
        return t;
    }

    private void isExpectedRowWithoutTimestamps(int rowIndex, List<Cell> kvs) {
        int i = 0;
        for (Cell kv : kvs) {
            byte[] expectedColname = TestDefaultMemStore.makeQualifier(rowIndex, i++);
            TestDefaultMemStore.assertTrue((String)"Column name", (boolean)CellUtil.matchingQualifier((Cell)kv, (byte[])expectedColname));
            TestDefaultMemStore.assertTrue((String)"Content", (boolean)CellUtil.matchingValue((Cell)kv, (byte[])expectedColname));
        }
    }

    private static void addRows(int count, MemStore mem) {
        long nanos = System.nanoTime();
        for (int i = 0; i < count; ++i) {
            if (i % 1000 == 0) {
                System.out.println(i + " Took for 1k usec: " + (System.nanoTime() - nanos) / 1000L);
                nanos = System.nanoTime();
            }
            long timestamp = System.currentTimeMillis();
            for (int ii = 0; ii < 10; ++ii) {
                byte[] row = Bytes.toBytes((int)i);
                byte[] qf = TestDefaultMemStore.makeQualifier(i, ii);
                mem.add((Cell)new KeyValue(row, FAMILY, qf, timestamp, qf));
            }
        }
    }

    static void doScan(MemStore ms, int iteration) throws IOException {
        long nanos = System.nanoTime();
        KeyValueScanner s = (KeyValueScanner)ms.getScanners(0L).get(0);
        s.seek((Cell)KeyValueUtil.createFirstOnRow((byte[])new byte[0]));
        System.out.println(iteration + " create/seek took: " + (System.nanoTime() - nanos) / 1000L);
        int cnt = 0;
        while (s.next() != null) {
            ++cnt;
        }
        System.out.println(iteration + " took usec: " + (System.nanoTime() - nanos) / 1000L + " for: " + cnt);
    }

    public static void main(String[] args) throws IOException {
        DefaultMemStore ms = new DefaultMemStore();
        long n1 = System.nanoTime();
        TestDefaultMemStore.addRows(25000, (MemStore)ms);
        System.out.println("Took for insert: " + (System.nanoTime() - n1) / 1000L);
        System.out.println("foo");
        for (int i = 0; i < 50; ++i) {
            TestDefaultMemStore.doScan((MemStore)ms, i);
        }
    }

    private class EnvironmentEdgeForMemstoreTest
    implements EnvironmentEdge {
        long t = 1234L;

        private EnvironmentEdgeForMemstoreTest() {
        }

        public long currentTime() {
            return this.t;
        }

        public void setCurrentTimeMillis(long t) {
            this.t = t;
        }
    }

    private static class ReadOwnWritesTester
    extends Thread {
        static final int NUM_TRIES = 1000;
        final byte[] row;
        final byte[] f = Bytes.toBytes((String)"family");
        final byte[] q1 = Bytes.toBytes((String)"q1");
        final MultiVersionConcurrencyControl mvcc;
        final MemStore memstore;
        final AtomicLong startSeqNum;
        AtomicReference<Throwable> caughtException;

        public ReadOwnWritesTester(int id, MemStore memstore, MultiVersionConcurrencyControl mvcc, AtomicReference<Throwable> caughtException, AtomicLong startSeqNum) {
            this.mvcc = mvcc;
            this.memstore = memstore;
            this.caughtException = caughtException;
            this.row = Bytes.toBytes((int)id);
            this.startSeqNum = startSeqNum;
        }

        @Override
        public void run() {
            try {
                this.internalRun();
            }
            catch (Throwable t) {
                this.caughtException.compareAndSet(null, t);
            }
        }

        private void internalRun() throws IOException {
            for (long i = 0L; i < 1000L && this.caughtException.get() == null; ++i) {
                MultiVersionConcurrencyControl.WriteEntry w = this.mvcc.begin();
                byte[] v = Bytes.toBytes((long)i);
                KeyValue kv = new KeyValue(this.row, this.f, this.q1, i, v);
                kv.setSequenceId(w.getWriteNumber());
                this.memstore.add((Cell)kv);
                this.mvcc.completeAndWait(w);
                KeyValueScanner s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
                s.seek((Cell)kv);
                Cell ret = s.next();
                TestCase.assertNotNull((String)"Didnt find own write at all", (Object)ret);
                TestCase.assertEquals((String)"Didnt read own writes", (long)kv.getTimestamp(), (long)ret.getTimestamp());
            }
        }
    }
}

