/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestWALActionsListener {
    private static final Log LOG = LogFactory.getLog(TestWALActionsListener.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] SOME_BYTES = Bytes.toBytes((String)"t");
    private static Configuration conf;
    private static Path rootDir;
    private static Path walRootDir;
    private static FileSystem fs;
    private static FileSystem walFs;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.maxlogs", 5);
        rootDir = TEST_UTIL.createRootDir();
        walRootDir = TEST_UTIL.createWALRootDir();
        fs = FSUtils.getRootDirFileSystem((Configuration)conf);
        walFs = FSUtils.getWALFileSystem((Configuration)conf);
    }

    @Before
    public void setUp() throws Exception {
        fs.delete(rootDir, true);
        walFs.delete(new Path(walRootDir, "WALs"), true);
        walFs.delete(new Path(walRootDir, "oldWALs"), true);
    }

    @After
    public void tearDown() throws Exception {
        this.setUp();
    }

    @Test
    public void testActionListener() throws Exception {
        DummyWALActionsListener observer = new DummyWALActionsListener();
        ArrayList<DummyWALActionsListener> list = new ArrayList<DummyWALActionsListener>();
        list.add(observer);
        WALFactory wals = new WALFactory(conf, list, "testActionListener");
        DummyWALActionsListener laterobserver = new DummyWALActionsListener();
        HRegionInfo hri = new HRegionInfo(TableName.valueOf((byte[])SOME_BYTES), SOME_BYTES, SOME_BYTES, false);
        WAL wal = wals.getWAL(hri.getEncodedNameAsBytes(), hri.getTable().getNamespace());
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        for (int i = 0; i < 20; ++i) {
            byte[] b = Bytes.toBytes((String)(i + ""));
            KeyValue kv = new KeyValue(b, b, b);
            WALEdit edit = new WALEdit();
            edit.add((Cell)kv);
            HTableDescriptor htd = new HTableDescriptor();
            htd.addFamily(new HColumnDescriptor(b));
            long txid = wal.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), TableName.valueOf((byte[])b), 0L, mvcc), edit, true);
            wal.sync(txid);
            if (i == 10) {
                wal.registerWALActionsListener((WALActionsListener)laterobserver);
            }
            if (i % 2 != 0) continue;
            wal.rollWriter();
        }
        wal.close();
        Assert.assertEquals((long)11L, (long)observer.preLogRollCounter);
        Assert.assertEquals((long)11L, (long)observer.postLogRollCounter);
        Assert.assertEquals((long)5L, (long)laterobserver.preLogRollCounter);
        Assert.assertEquals((long)5L, (long)laterobserver.postLogRollCounter);
        Assert.assertEquals((long)1L, (long)observer.closedCount);
    }

    public static class DummyWALActionsListener
    extends WALActionsListener.Base {
        public int preLogRollCounter = 0;
        public int postLogRollCounter = 0;
        public int closedCount = 0;

        public void preLogRoll(Path oldFile, Path newFile) {
            ++this.preLogRollCounter;
        }

        public void postLogRoll(Path oldFile, Path newFile) {
            ++this.postLogRollCounter;
        }

        public void logCloseRequested() {
            ++this.closedCount;
        }
    }
}

