/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;

@InterfaceAudience.Private
public class TableDescriptor {
    private HTableDescriptor hTableDescriptor;
    private TableState.State tableState;

    public TableDescriptor(HTableDescriptor hTableDescriptor, TableState.State tableState) {
        this.hTableDescriptor = hTableDescriptor;
        this.tableState = tableState;
    }

    public TableDescriptor(HTableDescriptor hTableDescriptor) {
        this(hTableDescriptor, TableState.State.ENABLED);
    }

    public HTableDescriptor getHTableDescriptor() {
        return this.hTableDescriptor;
    }

    public void setHTableDescriptor(HTableDescriptor hTableDescriptor) {
        this.hTableDescriptor = hTableDescriptor;
    }

    public TableState.State getTableState() {
        return this.tableState;
    }

    public void setTableState(TableState.State tableState) {
        this.tableState = tableState;
    }

    public HBaseProtos.TableDescriptor convert() {
        return HBaseProtos.TableDescriptor.newBuilder().setSchema(this.hTableDescriptor.convert()).setState(this.tableState.convert()).build();
    }

    public static TableDescriptor convert(HBaseProtos.TableDescriptor proto) {
        HTableDescriptor hTableDescriptor = HTableDescriptor.convert((HBaseProtos.TableSchema)proto.getSchema());
        TableState.State state = TableState.State.convert((HBaseProtos.TableState.State)proto.getState());
        return new TableDescriptor(hTableDescriptor, state);
    }

    public byte[] toByteArray() {
        return ProtobufUtil.prependPBMagic((byte[])this.convert().toByteArray());
    }

    public static TableDescriptor parseFrom(byte[] bytes) throws DeserializationException, IOException {
        HBaseProtos.TableDescriptor ts;
        if (!ProtobufUtil.isPBMagicPrefix((byte[])bytes)) {
            throw new DeserializationException("Expected PB encoded TableDescriptor");
        }
        int pblen = ProtobufUtil.lengthOfPBMagic();
        HBaseProtos.TableDescriptor.Builder builder = HBaseProtos.TableDescriptor.newBuilder();
        try {
            ts = ((HBaseProtos.TableDescriptor.Builder)builder.mergeFrom(bytes, pblen, bytes.length - pblen)).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        return TableDescriptor.convert(ts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableDescriptor that = (TableDescriptor)o;
        if (this.hTableDescriptor != null ? !this.hTableDescriptor.equals((Object)that.hTableDescriptor) : that.hTableDescriptor != null) {
            return false;
        }
        return this.tableState == that.tableState;
    }

    public int hashCode() {
        int result = this.hTableDescriptor != null ? this.hTableDescriptor.hashCode() : 0;
        result = 31 * result + (this.tableState != null ? this.tableState.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TableDescriptor{hTableDescriptor=" + this.hTableDescriptor + ", tableState=" + this.tableState + '}';
    }
}

