/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableDescriptor;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.master.MasterServices;

@InterfaceAudience.Private
public class TableStateManager {
    private static final Log LOG = LogFactory.getLog(TableStateManager.class);
    private final TableDescriptors descriptors;
    private final Map<TableName, TableState.State> tableStates = Maps.newConcurrentMap();

    public TableStateManager(MasterServices master) {
        this.descriptors = master.getTableDescriptors();
    }

    public void start() throws IOException {
        Map<String, TableDescriptor> all = this.descriptors.getAllDescriptors();
        for (TableDescriptor table : all.values()) {
            TableName tableName = table.getHTableDescriptor().getTableName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding table state: " + tableName + ": " + table.getTableState()));
            }
            this.tableStates.put(tableName, table.getTableState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableState(TableName tableName, TableState.State newState) throws IOException {
        Map<TableName, TableState.State> map = this.tableStates;
        synchronized (map) {
            TableDescriptor descriptor = this.readDescriptor(tableName);
            if (descriptor == null) {
                throw new TableNotFoundException(tableName);
            }
            if (descriptor.getTableState() != newState) {
                this.writeDescriptor(new TableDescriptor(descriptor.getHTableDescriptor(), newState));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTableStateIfInStates(TableName tableName, TableState.State newState, TableState.State ... states) throws IOException {
        Map<TableName, TableState.State> map = this.tableStates;
        synchronized (map) {
            TableDescriptor descriptor = this.readDescriptor(tableName);
            if (descriptor == null) {
                throw new TableNotFoundException(tableName);
            }
            if (TableState.isInStates((TableState.State)descriptor.getTableState(), (TableState.State[])states)) {
                this.writeDescriptor(new TableDescriptor(descriptor.getHTableDescriptor(), newState));
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTableStateIfNotInStates(TableName tableName, TableState.State newState, TableState.State ... states) throws IOException {
        Map<TableName, TableState.State> map = this.tableStates;
        synchronized (map) {
            TableDescriptor descriptor = this.readDescriptor(tableName);
            if (descriptor == null) {
                throw new TableNotFoundException(tableName);
            }
            if (!TableState.isInStates((TableState.State)descriptor.getTableState(), (TableState.State[])states)) {
                this.writeDescriptor(new TableDescriptor(descriptor.getHTableDescriptor(), newState));
                return true;
            }
            return false;
        }
    }

    public boolean isTableState(TableName tableName, TableState.State ... states) {
        TableState.State tableState = null;
        try {
            tableState = this.getTableState(tableName);
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to get table state, probably table not exists");
            return false;
        }
        return tableState != null && TableState.isInStates((TableState.State)tableState, (TableState.State[])states);
    }

    public void setDeletedTable(TableName tableName) throws IOException {
        TableState.State remove = this.tableStates.remove(tableName);
        if (remove == null) {
            LOG.warn((Object)("Moving table " + tableName + " state to deleted but was " + "already deleted"));
        }
    }

    public boolean isTablePresent(TableName tableName) throws IOException {
        return this.getTableState(tableName) != null;
    }

    public Set<TableName> getTablesInStates(TableState.State ... states) throws IOException {
        HashSet rv = Sets.newHashSet();
        for (Map.Entry<TableName, TableState.State> entry : this.tableStates.entrySet()) {
            if (!TableState.isInStates((TableState.State)entry.getValue(), (TableState.State[])states)) continue;
            rv.add(entry.getKey());
        }
        return rv;
    }

    public TableState.State getTableState(TableName tableName) throws IOException {
        TableDescriptor descriptor;
        TableState.State tableState = this.tableStates.get(tableName);
        if (tableState == null && (descriptor = this.readDescriptor(tableName)) != null) {
            tableState = descriptor.getTableState();
        }
        return tableState;
    }

    private void writeDescriptor(TableDescriptor descriptor) throws IOException {
        TableName tableName = descriptor.getHTableDescriptor().getTableName();
        TableState.State state = descriptor.getTableState();
        this.descriptors.add(descriptor);
        LOG.debug((Object)("Table " + tableName + " written descriptor for state " + state));
        this.tableStates.put(tableName, state);
        LOG.debug((Object)("Table " + tableName + " updated state to " + state));
    }

    private TableDescriptor readDescriptor(TableName tableName) throws IOException {
        TableDescriptor descriptor = this.descriptors.getDescriptor(tableName);
        if (descriptor == null) {
            this.tableStates.remove(tableName);
        } else {
            this.tableStates.put(tableName, descriptor.getTableState());
        }
        return descriptor;
    }
}

