/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClusterBootOrder {
    private static final long SLEEP_INTERVAL = 1000L;
    private static final long SLEEP_TIME = 4000L;
    private HBaseTestingUtility testUtil;
    private LocalHBaseCluster cluster;
    private JVMClusterUtil.RegionServerThread rs;
    private JVMClusterUtil.MasterThread master;

    @Before
    public void setUp() throws Exception {
        this.testUtil = new HBaseTestingUtility();
        this.testUtil.startMiniDFSCluster(1);
        this.testUtil.startMiniZKCluster(1, new int[0]);
        this.testUtil.createRootDir();
        this.cluster = new LocalHBaseCluster(this.testUtil.getConfiguration(), 0, 0);
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.shutdown();
        this.cluster.join();
        this.testUtil.shutdownMiniZKCluster();
        this.testUtil.shutdownMiniDFSCluster();
    }

    private void startRegionServer() throws Exception {
        this.rs = this.cluster.addRegionServer();
        this.rs.start();
        int i = 0;
        while ((long)i * 1000L < 4000L) {
            Thread.sleep(1000L);
            Assert.assertTrue((boolean)this.rs.isAlive());
            ++i;
        }
    }

    private void startMaster() throws Exception {
        this.master = this.cluster.addMaster();
        this.master.start();
        int i = 0;
        while ((long)i * 1000L < 4000L) {
            Thread.sleep(1000L);
            Assert.assertTrue((boolean)this.master.isAlive());
            ++i;
        }
    }

    private void waitForClusterOnline() {
        while (!this.master.getMaster().isInitialized()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.rs.waitForServerOnline();
    }

    @Test
    public void testBootRegionServerFirst() throws Exception {
        this.startRegionServer();
        this.startMaster();
        this.waitForClusterOnline();
    }

    @Test
    public void testBootMasterFirst() throws Exception {
        this.startMaster();
        this.startRegionServer();
        this.waitForClusterOnline();
    }
}

