/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionsRecoveryChore;
import org.apache.hadoop.hbase.master.RegionsRecoveryConfigManager;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRegionsRecoveryConfigManager {
    private static final HBaseTestingUtility HBASE_TESTING_UTILITY = new HBaseTestingUtility();
    private MiniHBaseCluster cluster;
    private HMaster hMaster;
    private RegionsRecoveryChore regionsRecoveryChore;
    private RegionsRecoveryConfigManager regionsRecoveryConfigManager;
    private Configuration conf;

    @Before
    public void setup() throws Exception {
        this.conf = HBASE_TESTING_UTILITY.getConfiguration();
        this.conf.unset("hbase.regions.recovery.store.file.ref.count");
        this.conf.unset("hbase.master.regions.recovery.check.interval");
        HBASE_TESTING_UTILITY.startMiniCluster(1, 1);
        this.cluster = HBASE_TESTING_UTILITY.getMiniHBaseCluster();
    }

    @After
    public void tearDown() throws Exception {
        HBASE_TESTING_UTILITY.shutdownMiniCluster();
    }

    @Test
    public void testChoreSchedule() throws Exception {
        this.hMaster = this.cluster.getMaster();
        StoppableImplementation stoppable = new StoppableImplementation();
        this.regionsRecoveryChore = new RegionsRecoveryChore((Stoppable)stoppable, this.conf, this.hMaster);
        this.regionsRecoveryConfigManager = new RegionsRecoveryConfigManager(this.hMaster);
        Assert.assertFalse((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryChore));
        this.regionsRecoveryConfigManager.onConfigurationChange(this.conf);
        Assert.assertFalse((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryChore));
        this.conf.setInt("hbase.master.regions.recovery.check.interval", 10);
        this.regionsRecoveryConfigManager.onConfigurationChange(this.conf);
        Assert.assertFalse((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryChore));
        this.conf.setInt("hbase.regions.recovery.store.file.ref.count", 10);
        this.regionsRecoveryConfigManager.onConfigurationChange(this.conf);
        Assert.assertTrue((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryChore));
        this.conf.setInt("hbase.regions.recovery.store.file.ref.count", 20);
        this.regionsRecoveryConfigManager.onConfigurationChange(this.conf);
        Assert.assertTrue((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryChore));
        this.conf.setInt("hbase.regions.recovery.store.file.ref.count", 20);
        this.regionsRecoveryConfigManager.onConfigurationChange(this.conf);
        Assert.assertTrue((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryChore));
        this.conf.unset("hbase.regions.recovery.store.file.ref.count");
        this.regionsRecoveryConfigManager.onConfigurationChange(this.conf);
        Assert.assertFalse((boolean)this.hMaster.getChoreService().isChoreScheduled((ScheduledChore)this.regionsRecoveryChore));
    }

    private static class StoppableImplementation
    implements Stoppable {
        private boolean stop = false;

        private StoppableImplementation() {
        }

        public void stop(String why) {
            this.stop = true;
        }

        public boolean isStopped() {
            return this.stop;
        }
    }
}

