/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.MasterRegistry;
import org.apache.hadoop.hbase.exceptions.MasterRegistryFetchException;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestMasterRegistry {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int META_REPLICA_COUNT = 3;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.meta.replica.count", 3);
        TEST_UTIL.startMiniCluster(3, 3);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static String generateDummyMastersList(int size) {
        ArrayList<String> masters = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            masters.add(" localhost" + (i % 2 == 0 ? ":" + (1000 + i) : ""));
        }
        return Joiner.on((String)",").join(masters);
    }

    @Test
    public void testMasterAddressParsing() throws IOException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        int numMasters = 10;
        conf.set("hbase.masters", TestMasterRegistry.generateDummyMastersList(numMasters));
        ArrayList parsedMasters = new ArrayList(MasterRegistry.parseMasterAddrs((Configuration)conf));
        Assert.assertEquals((long)(numMasters / 2 + 1), (long)parsedMasters.size());
        Collections.sort(parsedMasters, new Comparator<ServerName>(){

            @Override
            public int compare(ServerName sn1, ServerName sn2) {
                return sn1.getPort() - sn2.getPort();
            }
        });
        for (int i = 0; i < parsedMasters.size(); ++i) {
            ServerName sn = (ServerName)parsedMasters.get(i);
            Assert.assertEquals((Object)"localhost", (Object)sn.getHostname());
            if (i == parsedMasters.size() - 1) {
                Assert.assertEquals((long)16000L, (long)sn.getPort());
                continue;
            }
            Assert.assertEquals((long)(1000 + 2 * i), (long)sn.getPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegistryRPCs() throws Exception {
        HMaster activeMaster = TEST_UTIL.getHBaseCluster().getMaster();
        try (final MasterRegistry registry = new MasterRegistry();){
            registry.init(TEST_UTIL.getConnection());
            TEST_UTIL.waitFor(10000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return registry.getMetaRegionLocations().size() == 3;
                }
            });
            Assert.assertEquals((Object)registry.getClusterId(), (Object)activeMaster.getClusterId());
            Assert.assertEquals((Object)registry.getActiveMaster(), (Object)activeMaster.getServerName());
            Assert.assertTrue((boolean)registry.isTableOnlineState(TableName.META_TABLE_NAME, true));
            Assert.assertFalse((boolean)registry.isTableOnlineState(TableName.META_TABLE_NAME, false));
            List<HRegionLocation> metaLocations = Arrays.asList(registry.getMetaRegionLocations().getRegionLocations());
            List actualMetaLocations = activeMaster.getMetaRegionLocationCache().getMetaRegionLocations();
            Collections.sort(metaLocations);
            Collections.sort(actualMetaLocations);
            Assert.assertEquals((Object)actualMetaLocations, metaLocations);
            int numRs = registry.getCurrentNrHRS();
            Assert.assertEquals((long)TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size(), (long)numRs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicMasterConfigurationRefresh() throws Exception {
        Configuration conf = TEST_UTIL.getConnection().getConfiguration();
        String currentMasterAddrs = (String)Preconditions.checkNotNull((Object)conf.get("hbase.masters"));
        HMaster activeMaster = TEST_UTIL.getHBaseCluster().getMaster();
        ServerName badServer = ServerName.valueOf((String)"localhost", (int)1234, (long)-1L);
        conf.set("hbase.masters", badServer.toShortString() + "," + currentMasterAddrs);
        conf.setLong("hbase.client.master_registry.min_secs_between_refreshes", 0L);
        final ExceptionInjectorRegistry registry = new ExceptionInjectorRegistry();
        try {
            registry.init(TEST_UTIL.getConnection());
            final ImmutableSet masters = registry.getParsedMasterServers();
            Assert.assertTrue((boolean)masters.contains((Object)badServer.toString()));
            try {
                registry.getClusterId();
            }
            catch (MasterRegistryFetchException masterRegistryFetchException) {
                // empty catch block
            }
            TEST_UTIL.waitFor(5000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return !registry.getParsedMasterServers().equals((Object)masters);
                }
            });
            ImmutableSet newMasters = registry.getParsedMasterServers();
            Assert.assertEquals((long)3L, (long)newMasters.size());
            Assert.assertFalse((boolean)newMasters.contains((Object)badServer.toString()));
            activeMaster.stopMaster();
            TEST_UTIL.waitFor(10000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() {
                    return TEST_UTIL.getMiniHBaseCluster().getLiveMasterThreads().size() == 2;
                }
            });
            TEST_UTIL.getMiniHBaseCluster().waitForActiveAndReadyMaster(10000L);
            try {
                registry.getClusterId();
            }
            catch (MasterRegistryFetchException masterRegistryFetchException) {
                // empty catch block
            }
            TEST_UTIL.waitFor(10000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return registry.getMasters().size() == 2;
                }
            });
            TEST_UTIL.waitFor(20000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return registry.getParsedMasterServers().size() == 2;
                }
            });
            ImmutableSet newMasters2 = registry.getParsedMasterServers();
            Assert.assertEquals((long)2L, (long)newMasters2.size());
            Assert.assertFalse((boolean)newMasters2.contains((Object)activeMaster.getServerName().toString()));
        }
        finally {
            registry.close();
            TEST_UTIL.getMiniHBaseCluster().startMaster();
        }
    }

    private static class ExceptionInjectorRegistry
    extends MasterRegistry {
        private ExceptionInjectorRegistry() {
        }

        public String getClusterId() throws IOException {
            MasterProtos.GetClusterIdResponse resp = (MasterProtos.GetClusterIdResponse)this.doCall((MasterRegistry.Callable)new MasterRegistry.Callable<MasterProtos.GetClusterIdResponse>(){

                public MasterProtos.GetClusterIdResponse call(MasterProtos.ClientMetaService.Interface stub, RpcController controller) throws IOException {
                    throw new SocketTimeoutException("Injected exception.");
                }
            });
            return resp.getClusterId();
        }
    }
}

