/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryFactory;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegionLocationCache;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, MasterTests.class})
public class TestMetaRegionLocationCache {
    private static final Log LOG = LogFactory.getLog((String)TestMetaRegionLocationCache.class.getName());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ConnectionRegistry REGISTRY;

    static void waitUntilAllMetaReplicasHavingRegionLocation(Configuration conf, final ConnectionRegistry registry, final int regionReplication) throws IOException {
        Waiter.waitFor((Configuration)conf, (long)conf.getLong("hbase.client.sync.wait.timeout.msec", 60000L), (long)200L, (boolean)true, (Waiter.Predicate)new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() throws IOException {
                return "Not all meta replicas get assigned";
            }

            public boolean evaluate() throws IOException {
                try {
                    RegionLocations locs = registry.getMetaRegionLocations();
                    if (locs == null || locs.size() < regionReplication) {
                        return false;
                    }
                    for (int i = 0; i < regionReplication; ++i) {
                        if (locs.getRegionLocation(i) != null) continue;
                        return false;
                    }
                    return true;
                }
                catch (Exception e) {
                    LOG.warn((Object)"Failed to get meta region locations", (Throwable)e);
                    return false;
                }
            }
        });
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.meta.replica.count", 3);
        TEST_UTIL.startMiniCluster(3);
        REGISTRY = ConnectionRegistryFactory.getRegistry((Connection)TEST_UTIL.getConnection());
        TestMetaRegionLocationCache.waitUntilAllMetaReplicasHavingRegionLocation(TEST_UTIL.getConfiguration(), REGISTRY, 3);
        TEST_UTIL.getConnection().getAdmin().setBalancerRunning(false, true);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private List<HRegionLocation> getCurrentMetaLocations(ZooKeeperWatcher zk) throws Exception {
        ArrayList<HRegionLocation> result = new ArrayList<HRegionLocation>();
        for (String znode : zk.getMetaReplicaNodes()) {
            String path = ZKUtil.joinZNode((String)zk.baseZNode, (String)znode);
            int replicaId = zk.getMetaReplicaIdFromPath(path);
            RegionState state = MetaTableLocator.getMetaRegionState((ZooKeeperWatcher)zk, (int)replicaId);
            result.add(new HRegionLocation(state.getRegion(), state.getServerName()));
        }
        return result;
    }

    private void verifyCachedMetaLocations(final HMaster master) throws Exception {
        ZooKeeperWatcher zk = master.getZooKeeper();
        final List metaZnodes = zk.getMetaReplicaNodes();
        Assert.assertEquals((long)3L, (long)metaZnodes.size());
        TEST_UTIL.waitFor(10000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return master.getMetaRegionLocationCache().getMetaRegionLocations().size() == metaZnodes.size();
            }
        });
        List metaHRLs = master.getMetaRegionLocationCache().getMetaRegionLocations();
        List<HRegionLocation> actualHRLs = this.getCurrentMetaLocations(zk);
        Collections.sort(metaHRLs);
        Collections.sort(actualHRLs);
        Assert.assertEquals(actualHRLs, (Object)metaHRLs);
    }

    @Test
    public void testInitialMetaLocations() throws Exception {
        this.verifyCachedMetaLocations(TEST_UTIL.getMiniHBaseCluster().getMaster());
    }

    @Test
    public void testStandByMetaLocations() throws Exception {
        HMaster standBy = TEST_UTIL.getMiniHBaseCluster().startMaster().getMaster();
        this.verifyCachedMetaLocations(standBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerName getOtherRS(List<ServerName> allServers, ServerName except) {
        ServerName ret;
        Preconditions.checkArgument((allServers.size() > 0 ? 1 : 0) != 0);
        allServers.remove(except);
        try {
            Collections.shuffle(allServers);
            ret = allServers.get(0);
        }
        finally {
            allServers.add(except);
        }
        return ret;
    }

    @Test
    public void testMetaLocationsChange() throws Exception {
        List<HRegionLocation> currentMetaLocs = this.getCurrentMetaLocations(TEST_UTIL.getMiniHBaseCluster().getMaster().getZooKeeper());
        ArrayList<ServerName> allServers = new ArrayList<ServerName>();
        for (JVMClusterUtil.RegionServerThread rs : TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            allServers.add(rs.getRegionServer().getServerName());
        }
        for (HRegionLocation location : currentMetaLocs) {
            TEST_UTIL.moveRegionAndWait(location.getRegionInfo(), TestMetaRegionLocationCache.getOtherRS(allServers, location.getServerName()));
        }
        TestMetaRegionLocationCache.waitUntilAllMetaReplicasHavingRegionLocation(TEST_UTIL.getConfiguration(), REGISTRY, 3);
        for (JVMClusterUtil.MasterThread masterThread : TEST_UTIL.getMiniHBaseCluster().getMasterThreads()) {
            this.verifyCachedMetaLocations(masterThread.getMaster());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaRegionLocationCache() throws Exception {
        String parentZnodeName = "/randomznodename";
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("zookeeper.znode.parent", "/randomznodename");
        ServerName sn = ServerName.valueOf((String)"localhost", (int)1234, (long)5678L);
        try (final ZooKeeperWatcher zkWatcher = new ZooKeeperWatcher(conf, null, null, true);){
            MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext(conf);
            ctx.addThread(new MultithreadedTestUtil.RepeatingTestThread(ctx){

                @Override
                public void doAnAction() throws Exception {
                    String testZnode = "/randomznodename/child";
                    ZKUtil.createNodeIfNotExistsAndWatch((ZooKeeperWatcher)zkWatcher, (String)"/randomznodename/child", (byte[])"/randomznodename/child".getBytes());
                    ZKUtil.deleteNode((ZooKeeperWatcher)zkWatcher, (String)"/randomznodename/child");
                }
            });
            ctx.startThreads();
            try {
                MetaRegionLocationCache metaCache = new MetaRegionLocationCache(zkWatcher);
                Assert.assertTrue((boolean)metaCache.getMetaRegionLocations().isEmpty());
                for (int i = 0; i < 3; ++i) {
                    MetaTableLocator.setMetaLocation((ZooKeeperWatcher)zkWatcher, (ServerName)sn, (int)i, (RegionState.State)RegionState.State.OPEN);
                }
                int iters = 0;
                while (iters++ < 10 && metaCache.getMetaRegionLocations().size() != 3) {
                    Thread.sleep(1000L);
                }
                List metaLocations = metaCache.getMetaRegionLocations();
                Assert.assertNotNull((Object)metaLocations);
                Assert.assertEquals((long)3L, (long)metaLocations.size());
                for (HRegionLocation location : metaLocations) {
                    Assert.assertEquals((Object)sn, (Object)location.getServerName());
                }
            }
            finally {
                ctx.stop();
                ZKUtil.deleteChildrenRecursively((ZooKeeperWatcher)zkWatcher, (String)"/randomznodename");
            }
        }
    }
}

