/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.HeterogeneousRegionCountCostFunction;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestStochasticLoadBalancerHeterogeneousCostRules
extends BalancerTestBase {
    static final String DEFAULT_RULES_TMP_LOCATION = "/tmp/hbase-balancer.rules";
    static Configuration conf;
    private HeterogeneousRegionCountCostFunction costFunction;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TestStochasticLoadBalancerHeterogeneousCostRules.createSimpleRulesFile(new ArrayList<String>());
        conf = new Configuration();
        conf.set("hbase.master.balancer.heterogeneousRegionCountRulesFile", DEFAULT_RULES_TMP_LOCATION);
    }

    static void createSimpleRulesFile(List<String> lines) throws IOException {
        TestStochasticLoadBalancerHeterogeneousCostRules.cleanup();
        java.nio.file.Path file = Paths.get(DEFAULT_RULES_TMP_LOCATION, new String[0]);
        Files.write(file, lines, Charset.forName("UTF-8"), new OpenOption[0]);
    }

    protected static void cleanup() {
        File file = new File(DEFAULT_RULES_TMP_LOCATION);
        file.delete();
    }

    @AfterClass
    public static void afterAllTests() {
        TestStochasticLoadBalancerHeterogeneousCostRules.cleanup();
    }

    @Test
    public void testNoRules() {
        TestStochasticLoadBalancerHeterogeneousCostRules.cleanup();
        this.costFunction = new HeterogeneousRegionCountCostFunction(conf);
        this.costFunction.loadRules();
        Assert.assertEquals((long)0L, (long)this.costFunction.getNumberOfRulesLoaded());
    }

    @Test
    public void testBadFormatInRules() throws IOException {
        TestStochasticLoadBalancerHeterogeneousCostRules.createSimpleRulesFile(new ArrayList<String>());
        this.costFunction = new HeterogeneousRegionCountCostFunction(conf);
        this.costFunction.loadRules();
        Assert.assertEquals((long)0L, (long)this.costFunction.getNumberOfRulesLoaded());
        TestStochasticLoadBalancerHeterogeneousCostRules.createSimpleRulesFile(Collections.singletonList("bad rules format"));
        this.costFunction = new HeterogeneousRegionCountCostFunction(conf);
        this.costFunction.loadRules();
        Assert.assertEquals((long)0L, (long)this.costFunction.getNumberOfRulesLoaded());
        TestStochasticLoadBalancerHeterogeneousCostRules.createSimpleRulesFile(Arrays.asList("srv[1-2] 10", "bad_rules format", "a"));
        this.costFunction = new HeterogeneousRegionCountCostFunction(conf);
        this.costFunction.loadRules();
        Assert.assertEquals((long)1L, (long)this.costFunction.getNumberOfRulesLoaded());
    }

    @Test
    public void testTwoRules() throws IOException {
        TestStochasticLoadBalancerHeterogeneousCostRules.createSimpleRulesFile(Arrays.asList("^server1$ 10", "^server2 21"));
        this.costFunction = new HeterogeneousRegionCountCostFunction(conf);
        this.costFunction.loadRules();
        Assert.assertEquals((long)2L, (long)this.costFunction.getNumberOfRulesLoaded());
    }

    @Test
    public void testBadRegexp() throws IOException {
        TestStochasticLoadBalancerHeterogeneousCostRules.createSimpleRulesFile(Collections.singletonList("server[ 1"));
        this.costFunction = new HeterogeneousRegionCountCostFunction(conf);
        this.costFunction.loadRules();
        Assert.assertEquals((long)0L, (long)this.costFunction.getNumberOfRulesLoaded());
    }

    @Test
    public void testNoOverride() throws IOException {
        TestStochasticLoadBalancerHeterogeneousCostRules.createSimpleRulesFile(Arrays.asList("^server1$ 10", "^server2 21"));
        this.costFunction = new HeterogeneousRegionCountCostFunction(conf);
        this.costFunction.loadRules();
        Assert.assertEquals((long)2L, (long)this.costFunction.getNumberOfRulesLoaded());
        TestStochasticLoadBalancerHeterogeneousCostRules.cleanup();
        this.costFunction.loadRules();
        Assert.assertEquals((long)2L, (long)this.costFunction.getNumberOfRulesLoaded());
    }

    @Test
    public void testLoadingFomHDFS() throws Exception {
        HBaseTestingUtility hBaseTestingUtility = new HBaseTestingUtility();
        hBaseTestingUtility.startMiniDFSCluster(3);
        MiniDFSCluster cluster = hBaseTestingUtility.getDFSCluster();
        DistributedFileSystem fs = cluster.getFileSystem();
        String path = cluster.getURI() + DEFAULT_RULES_TMP_LOCATION;
        FSDataOutputStream stream = fs.create(new Path(path));
        stream.write("server1 10".getBytes());
        stream.flush();
        stream.close();
        Configuration configuration = hBaseTestingUtility.getConfiguration();
        configuration.set("hbase.master.balancer.heterogeneousRegionCountRulesFile", path);
        this.costFunction = new HeterogeneousRegionCountCostFunction(configuration);
        this.costFunction.loadRules();
        Assert.assertEquals((long)1L, (long)this.costFunction.getNumberOfRulesLoaded());
        hBaseTestingUtility.shutdownMiniCluster();
    }
}

