/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

public class MockStoreFile
extends StoreFile {
    long length = 0L;
    boolean isRef = false;
    long ageInDisk;
    long sequenceid;
    private Map<byte[], byte[]> metadata = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
    byte[] splitPoint = null;
    TimeRangeTracker timeRangeTracker;
    long entryCount;
    boolean isMajor;
    HDFSBlocksDistribution hdfsBlocksDistribution;
    long modificationTime;
    boolean compactedAway;

    MockStoreFile(HBaseTestingUtility testUtil, Path testPath, long length, long ageInDisk, boolean isRef, long sequenceid) throws IOException {
        super(testUtil.getTestFileSystem(), testPath, testUtil.getConfiguration(), new CacheConfig(testUtil.getConfiguration()), BloomType.NONE);
        this.length = length;
        this.isRef = isRef;
        this.ageInDisk = ageInDisk;
        this.sequenceid = sequenceid;
        this.isMajor = false;
        this.hdfsBlocksDistribution = new HDFSBlocksDistribution();
        this.hdfsBlocksDistribution.addHostsAndBlockWeight(new String[]{RSRpcServices.getHostname((Configuration)testUtil.getConfiguration(), (boolean)false)}, 1L);
        this.modificationTime = EnvironmentEdgeManager.currentTime();
    }

    void setLength(long newLen) {
        this.length = newLen;
    }

    byte[] getFileSplitPoint(KeyValue.KVComparator comparator) throws IOException {
        return this.splitPoint;
    }

    public long getMaxSequenceId() {
        return this.sequenceid;
    }

    public boolean isMajorCompaction() {
        return this.isMajor;
    }

    public void setIsMajor(boolean isMajor) {
        this.isMajor = isMajor;
    }

    public boolean isReference() {
        return this.isRef;
    }

    public boolean isBulkLoadResult() {
        return false;
    }

    public byte[] getMetadataValue(byte[] key) {
        return this.metadata.get(key);
    }

    public void setMetadataValue(byte[] key, byte[] value) {
        this.metadata.put(key, value);
    }

    void setTimeRangeTracker(TimeRangeTracker timeRangeTracker) {
        this.timeRangeTracker = timeRangeTracker;
    }

    void setEntries(long entryCount) {
        this.entryCount = entryCount;
    }

    public Long getMinimumTimestamp() {
        return this.timeRangeTracker == null ? null : Long.valueOf(this.timeRangeTracker.getMin());
    }

    public Long getMaximumTimestamp() {
        return this.timeRangeTracker == null ? null : Long.valueOf(this.timeRangeTracker.getMax());
    }

    public void markCompactedAway() {
        this.compactedAway = true;
    }

    public long getModificationTimeStamp() {
        return this.modificationTime;
    }

    public HDFSBlocksDistribution getHDFSBlockDistribution() {
        return this.hdfsBlocksDistribution;
    }

    public StoreFile.Reader getReader() {
        final long len = this.length;
        final TimeRangeTracker timeRangeTracker = this.timeRangeTracker;
        final long entries = this.entryCount;
        final boolean compactedAway = this.compactedAway;
        return new StoreFile.Reader(){

            public long length() {
                return len;
            }

            public long getMaxTimestamp() {
                return this.timeRange == null ? Long.MAX_VALUE : timeRangeTracker.getMax();
            }

            public long getEntries() {
                return entries;
            }

            public boolean isCompactedAway() {
                return compactedAway;
            }

            public void close(boolean evictOnClose) throws IOException {
            }
        };
    }
}

