/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.mockito.exceptions.verification.WantedButNotInvoked;
import org.mockito.verification.VerificationMode;

@Category(value={MediumTests.class})
public class TestFailedAppendAndSync {
    private static final Log LOG = LogFactory.getLog(TestFailedAppendAndSync.class);
    @Rule
    public TestName name = new TestName();
    private static final String COLUMN_FAMILY = "MyCF";
    private static final byte[] COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"MyCF");
    HRegion region = null;
    private static HBaseTestingUtility TEST_UTIL;
    public static Configuration CONF;
    private String dir;
    protected TableName tableName;

    @Before
    public void setup() throws IOException {
        TEST_UTIL = HBaseTestingUtility.createLocalHTU();
        CONF = TEST_UTIL.getConfiguration();
        CONF.setFloat("hfile.block.cache.size", 0.0f);
        this.dir = TEST_UTIL.getDataTestDir("TestHRegion").toString();
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
        LOG.info((Object)("Cleaning test directory: " + TEST_UTIL.getDataTestDir()));
        TEST_UTIL.cleanupTestDir();
    }

    String getName() {
        return this.name.getMethodName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testLockupAroundBadAssignSync() throws IOException {
        final AtomicLong rolls = new AtomicLong(0L);
        Server server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)server.getConfiguration()).thenReturn((Object)CONF);
        Mockito.when((Object)server.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)server.isAborted()).thenReturn((Object)false);
        RegionServerServices services = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        FileSystem fs = FileSystem.get((Configuration)CONF);
        Path rootDir = new Path(this.dir + this.getName());
        class DodgyFSLog
        extends FSHLog {
            volatile boolean throwSyncException;
            volatile boolean throwAppendException;

            public DodgyFSLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
                super(fs, root, logDir, conf);
                this.throwSyncException = false;
                this.throwAppendException = false;
            }

            public byte[][] rollWriter(boolean force) throws FailedLogCloseException, IOException {
                byte[][] regions = super.rollWriter(force);
                rolls.getAndIncrement();
                return regions;
            }

            protected WALProvider.Writer createWriterInstance(Path path) throws IOException {
                final WALProvider.Writer w = super.createWriterInstance(path);
                return new WALProvider.Writer(){

                    public void close() throws IOException {
                        w.close();
                    }

                    public void sync(boolean forceSync) throws IOException {
                        if (throwSyncException) {
                            throw new IOException("FAKE! Failed to replace a bad datanode...");
                        }
                        w.sync(forceSync);
                    }

                    public void append(WAL.Entry entry) throws IOException {
                        if (throwAppendException) {
                            throw new IOException("FAKE! Failed to replace a bad datanode...");
                        }
                        w.append(entry);
                    }

                    public long getLength() throws IOException {
                        return w.getLength();
                    }
                };
            }
        }
        DodgyFSLog dodgyWAL = new DodgyFSLog(fs, rootDir, this.getName(), CONF);
        LogRoller logRoller = new LogRoller(server, services);
        logRoller.addWAL((WAL)dodgyWAL);
        logRoller.start();
        boolean threwOnSync = false;
        boolean threwOnAppend = false;
        boolean threwOnBoth = false;
        HRegion region = this.initHRegion(this.tableName, null, null, CONF, (WAL)dodgyWAL);
        region.setRegionServerServices(services);
        try {
            Put put;
            byte[] value = Bytes.toBytes((String)this.getName());
            try {
                Put put2 = new Put(value);
                put2.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"1"), value);
                region.put(put2);
            }
            catch (IOException ioe) {
                Assert.fail();
            }
            long rollsCount = rolls.get();
            try {
                dodgyWAL.throwAppendException = true;
                dodgyWAL.throwSyncException = false;
                put = new Put(value);
                put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"3"), value);
                region.put(put);
            }
            catch (IOException ioe) {
                threwOnAppend = true;
            }
            while (rollsCount == rolls.get()) {
                Threads.sleep((long)100L);
            }
            rollsCount = rolls.get();
            try {
                dodgyWAL.throwAppendException = true;
                dodgyWAL.throwSyncException = true;
                put = new Put(value);
                put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"4"), value);
                region.put(put);
            }
            catch (IOException ioe) {
                threwOnBoth = true;
            }
            while (rollsCount == rolls.get()) {
                Threads.sleep((long)100L);
            }
            ((Server)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeast((int)0))).abort(Mockito.anyString(), (Throwable)Mockito.anyObject());
            try {
                dodgyWAL.throwAppendException = false;
                dodgyWAL.throwSyncException = true;
                put = new Put(value);
                put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"2"), value);
                region.put(put);
            }
            catch (IOException ioe) {
                threwOnSync = true;
            }
            while (true) {
                try {
                    ((Server)Mockito.verify((Object)server, (VerificationMode)Mockito.atLeast((int)1))).abort(Mockito.anyString(), (Throwable)Mockito.anyObject());
                }
                catch (WantedButNotInvoked t) {
                    Threads.sleep((long)1L);
                    continue;
                }
                break;
            }
        }
        finally {
            Mockito.when((Object)server.isStopped()).thenReturn((Object)true);
            if (logRoller != null) {
                logRoller.interrupt();
            }
            if (region != null) {
                try {
                    region.close(true);
                }
                catch (DroppedSnapshotException e) {
                    LOG.info((Object)"On way out; expected!", (Throwable)e);
                }
            }
            if (dodgyWAL != null) {
                dodgyWAL.close();
            }
            Assert.assertTrue((String)"The regionserver should have thrown an exception", (boolean)threwOnBoth);
            Assert.assertTrue((String)"The regionserver should have thrown an exception", (boolean)threwOnAppend);
            Assert.assertTrue((String)"The regionserver should have thrown an exception", (boolean)threwOnSync);
        }
    }

    public HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, Configuration conf, WAL wal) throws IOException {
        return TEST_UTIL.createLocalHRegion(tableName.getName(), startKey, stopKey, this.getName(), conf, false, Durability.SYNC_WAL, wal, new byte[][]{COLUMN_FAMILY_BYTES});
    }
}

