/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.TestCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, SmallTests.class})
public class TestDateTieredCompactor {
    private static final byte[] NAME_OF_THINGS = Bytes.toBytes((String)"foo");
    private static final TableName TABLE_NAME = TableName.valueOf((byte[])NAME_OF_THINGS, (byte[])NAME_OF_THINGS);
    private static final KeyValue KV_A = new KeyValue(Bytes.toBytes((String)"aaa"), 100L);
    private static final KeyValue KV_B = new KeyValue(Bytes.toBytes((String)"bbb"), 200L);
    private static final KeyValue KV_C = new KeyValue(Bytes.toBytes((String)"ccc"), 300L);
    private static final KeyValue KV_D = new KeyValue(Bytes.toBytes((String)"ddd"), 400L);
    @Parameterized.Parameter
    public boolean usePrivateReaders;

    @Parameterized.Parameters(name="{index}: usePrivateReaders={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    private DateTieredCompactor createCompactor(TestCompactor.StoreFileWritersCapture writers, KeyValue[] input, List<StoreFile> storefiles) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.regionserver.compaction.private.readers", this.usePrivateReaders);
        final TestCompactor.Scanner scanner = new TestCompactor.Scanner(input);
        HColumnDescriptor col = new HColumnDescriptor(NAME_OF_THINGS);
        ScanInfo si = new ScanInfo(conf, col, Long.MAX_VALUE, 0L, new KeyValue.KVComparator());
        Store store = (Store)Mockito.mock(Store.class);
        Mockito.when((Object)store.getStorefiles()).thenReturn(storefiles);
        Mockito.when((Object)store.getFamily()).thenReturn((Object)col);
        Mockito.when((Object)store.getScanInfo()).thenReturn((Object)si);
        Mockito.when((Object)store.areWritesEnabled()).thenReturn((Object)true);
        Mockito.when((Object)store.getFileSystem()).thenReturn(Mockito.mock(FileSystem.class));
        Mockito.when((Object)store.getRegionInfo()).thenReturn((Object)new HRegionInfo(TABLE_NAME));
        Mockito.when((Object)store.createWriterInTmp(Matchers.anyLong(), (Compression.Algorithm)Matchers.any(Compression.Algorithm.class), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyLong())).thenAnswer((Answer)writers);
        Mockito.when((Object)store.getComparator()).thenReturn((Object)new KeyValue.KVComparator());
        long maxSequenceId = StoreFile.getMaxSequenceIdInList(storefiles);
        Mockito.when((Object)store.getMaxSequenceId()).thenReturn((Object)maxSequenceId);
        return new DateTieredCompactor(conf, store){

            protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
                return scanner;
            }

            protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
                return scanner;
            }
        };
    }

    private void verify(KeyValue[] input, List<Long> boundaries, KeyValue[][] output, boolean allFiles) throws Exception {
        TestCompactor.StoreFileWritersCapture writers = new TestCompactor.StoreFileWritersCapture();
        StoreFile sf1 = TestCompactor.createDummyStoreFile(1L);
        StoreFile sf2 = TestCompactor.createDummyStoreFile(2L);
        DateTieredCompactor dtc = this.createCompactor(writers, input, Arrays.asList(sf1, sf2));
        List paths = dtc.compact(new CompactionRequest(Arrays.asList(sf1)), boundaries.subList(0, boundaries.size() - 1), (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        writers.verifyKvs(output, allFiles, boundaries);
        if (allFiles) {
            Assert.assertEquals((long)output.length, (long)paths.size());
        }
    }

    private static <T> T[] a(T ... a) {
        return a;
    }

    @Test
    public void test() throws Exception {
        this.verify(TestDateTieredCompactor.a(KV_A, KV_B, KV_C, KV_D), Arrays.asList(100L, 200L, 300L, 400L, 500L), (KeyValue[][])TestDateTieredCompactor.a(TestDateTieredCompactor.a(KV_A), TestDateTieredCompactor.a(KV_B), TestDateTieredCompactor.a(KV_C), TestDateTieredCompactor.a(KV_D)), true);
        this.verify(TestDateTieredCompactor.a(KV_A, KV_B, KV_C, KV_D), Arrays.asList(Long.MIN_VALUE, 200L, Long.MAX_VALUE), (KeyValue[][])TestDateTieredCompactor.a(TestDateTieredCompactor.a(KV_A), TestDateTieredCompactor.a(KV_B, KV_C, KV_D)), false);
        this.verify(TestDateTieredCompactor.a(KV_A, KV_B, KV_C, KV_D), Arrays.asList(Long.MIN_VALUE, Long.MAX_VALUE), new KeyValue[][]{TestDateTieredCompactor.a(KV_A, KV_B, KV_C, KV_D)}, false);
    }

    @Test
    public void testEmptyOutputFile() throws Exception {
        TestCompactor.StoreFileWritersCapture writers = new TestCompactor.StoreFileWritersCapture();
        CompactionRequest request = TestCompactor.createDummyRequest();
        DateTieredCompactor dtc = this.createCompactor(writers, new KeyValue[0], new ArrayList<StoreFile>(request.getFiles()));
        List paths = dtc.compact(request, Arrays.asList(Long.MIN_VALUE, Long.MAX_VALUE), (ThroughputController)NoLimitThroughputController.INSTANCE, null);
        Assert.assertEquals((long)1L, (long)paths.size());
        List<TestCompactor.StoreFileWritersCapture.Writer> dummyWriters = writers.getWriters();
        Assert.assertEquals((long)1L, (long)dummyWriters.size());
        TestCompactor.StoreFileWritersCapture.Writer dummyWriter = dummyWriters.get(0);
        Assert.assertTrue((boolean)dummyWriter.kvs.isEmpty());
        Assert.assertTrue((boolean)dummyWriter.hasMetadata);
    }
}

